/*
 * Decompiled with CFR 0.152.
 */
package com.geekvivek.dropwizard.jmxmetricsutils;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.geekvivek.dropwizard.jmxmetricsutils.config.MetricConfig;
import com.geekvivek.jmx.utils.JmxMetric;
import com.geekvivek.jmx.utils.exceptions.MetricNotAvailableException;
import com.geekvivek.jmx.utils.interfaces.JmxMetricsListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.OperationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxToDropwizardReporter
implements JmxMetricsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxToDropwizardReporter.class);
    private final MetricRegistry registry;
    private final MetricConfig metricConfig;
    private final Map<JmxMetric, String> metricCache;

    public JmxToDropwizardReporter(MetricRegistry registry, MetricConfig metricConfig) {
        this.registry = registry;
        this.metricConfig = metricConfig;
        this.metricCache = new HashMap<JmxMetric, String>();
    }

    public void metricChange(JmxMetric metric) {
        this.metricConfig.getFilters().forEach(filter -> {
            if (metric.toString().matches(filter.getMetricsRegex())) {
                try {
                    this.handleNewMetric(metric, filter.getMetricType());
                }
                catch (InstanceNotFoundException e) {
                    LOGGER.error("Metric does not exist in MBeanServer - {}", (Object)metric);
                }
            }
        });
    }

    private void handleNewMetric(JmxMetric metric, String metricType) throws InstanceNotFoundException {
        switch (metricType) {
            case "gauge": {
                this.handleGaugeTypeMetric(metric, metricType);
                break;
            }
            case "histogram": {
                metric.addNotificationListener((NotificationListener)new ValueChangeListener(metric), (Object)this.registry.histogram(this.getDropWizardMetricName(metric)));
                break;
            }
            case "meter": {
                metric.addNotificationListener((NotificationListener)new ValueChangeListener(metric), (Object)this.registry.meter(this.getDropWizardMetricName(metric)));
                break;
            }
            default: {
                LOGGER.error("Unsupported metricType {} for metric {} ; Only supported meter types are : gauge,histogram,meter", (Object)metricType, (Object)metric);
            }
        }
    }

    public void metricRemoval(JmxMetric metric) {
        String name = this.metricCache.remove(metric);
        if (name != null) {
            LOGGER.debug("Removing {} from MetricRegistry", (Object)name);
            this.registry.remove(name);
        }
    }

    private String getDropWizardMetricName(JmxMetric metric) {
        ArrayList<String> nameParts = new ArrayList<String>(3);
        nameParts.add(metric.getType());
        metric.getTags().forEach((key, value) -> nameParts.add(key + "." + value));
        if (metric.getName() != null) {
            nameParts.add(metric.getName());
        }
        if (!Objects.equals(metric.getAttributeName(), "Value") && !Objects.equals(metric.getAttributeName(), "Number")) {
            nameParts.add(metric.getAttributeName());
        }
        if (metric.getItemName() != null) {
            nameParts.add(metric.getItemName());
        }
        StringBuilder builder = new StringBuilder();
        for (String namePart : nameParts) {
            builder.append(namePart);
            builder.append(".");
        }
        builder.setLength(builder.length() - 1);
        String processedName = builder.toString().replace(' ', '_');
        return MetricRegistry.name((String)metric.getDomain(), (String[])new String[]{processedName});
    }

    public void close() {
        for (String name : this.metricCache.values()) {
            this.registry.remove(name);
        }
    }

    private void handleGaugeTypeMetric(JmxMetric metric, String meterType) {
        Gauge gauge = () -> {
            try {
                return new Double(metric.getValue() + "");
            }
            catch (MetricNotAvailableException e) {
                return 0.0;
            }
            catch (RuntimeException e) {
                this.metricRemoval(metric);
                return 0.0;
            }
        };
        String name = this.getDropWizardMetricName(metric);
        LOGGER.info("Registering {} to MetricRegistry", (Object)name);
        try {
            this.registry.register(name, (Metric)gauge);
            this.metricCache.put(metric, name);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("metricChange called for `{}' which was already registered, ignoring.", (Object)name);
        }
    }

    public class ValueChangeListener
    implements NotificationListener {
        private JmxMetric metric;

        public ValueChangeListener(JmxMetric metric) {
            this.metric = metric;
        }

        @Override
        public void handleNotification(Notification notification, Object context) {
            try {
                if (context == null) {
                    return;
                }
                if (context instanceof Histogram) {
                    ((Histogram)context).update(new Long(this.metric.getValue() + "").longValue());
                } else if (context instanceof Meter) {
                    ((Meter)context).mark(new Long(this.metric.getValue() + "").longValue());
                }
            }
            catch (MetricNotAvailableException | RuntimeException e) {
                LOGGER.error("Invalid metric config for {}", (Object)notification, (Object)e);
                JmxToDropwizardReporter.this.metricRemoval(this.metric);
                try {
                    this.metric.removeNotificationListener((NotificationListener)this);
                }
                catch (OperationsException operationsException) {
                    // empty catch block
                }
            }
        }
    }
}

