/*
 * Decompiled with CFR 0.152.
 */
package com.geekvivek.jmx.utils;

import com.geekvivek.jmx.utils.exceptions.MetricNotAvailableException;
import java.util.Map;
import java.util.Objects;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class JmxMetric {
    private final String domain;
    private final String type;
    private final String name;
    private final Map<String, String> tags;
    private final String attributeName;
    private final String itemName;
    private final ObjectName mBeanObjectName;
    private final MBeanServer mBeanServer;

    public JmxMetric(ObjectName mBeanObjectName, MBeanAttributeInfo attributeInfo, String itemName, MBeanServer mBeanServer) {
        this.mBeanObjectName = mBeanObjectName;
        this.mBeanServer = mBeanServer;
        this.domain = mBeanObjectName.getDomain();
        this.tags = mBeanObjectName.getKeyPropertyList();
        this.type = this.tags.remove("type");
        this.name = this.tags.remove("name");
        this.attributeName = attributeInfo.getName();
        this.itemName = itemName;
    }

    public Object getValue() throws MetricNotAvailableException {
        try {
            Object value = this.mBeanServer.getAttribute(this.mBeanObjectName, this.attributeName);
            if (this.itemName != null && value instanceof CompositeDataSupport) {
                return ((CompositeDataSupport)value).get(this.itemName);
            }
            return value;
        }
        catch (JMException e) {
            throw new MetricNotAvailableException("metric is not available now for " + this);
        }
    }

    public void addNotificationListener(NotificationListener listener, Object context) throws InstanceNotFoundException {
        this.mBeanServer.addNotificationListener(this.mBeanObjectName, listener, null, context);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException, InstanceNotFoundException {
        this.mBeanServer.removeNotificationListener(this.mBeanObjectName, listener);
    }

    public int hashCode() {
        if (this.itemName != null) {
            return Objects.hash(this.mBeanObjectName, this.attributeName, this.itemName);
        }
        return Objects.hash(this.mBeanObjectName, this.attributeName);
    }

    public String toString() {
        if ("Value".equals(this.attributeName) || "Number".equals(this.attributeName)) {
            return this.mBeanObjectName.toString();
        }
        if (this.itemName == null) {
            return this.mBeanObjectName.toString() + "." + this.attributeName;
        }
        return this.mBeanObjectName.toString() + "." + this.attributeName + "." + this.itemName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getItemName() {
        return this.itemName;
    }
}

