/*
 * Decompiled with CFR 0.152.
 */
package com.geekvivek.jmx.utils.service;

import com.geekvivek.jmx.utils.JmxMetric;
import com.geekvivek.jmx.utils.exceptions.EmptyJmxMetricListenerListException;
import com.geekvivek.jmx.utils.interfaces.JmxMetricsListener;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricProviderService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMetricProviderService.class);
    private static final AtomicInteger FACTORY_ID = new AtomicInteger();
    private final ScheduledExecutorService executor;
    private final MBeanServer server;
    private final List<JmxMetricsListener> metricsUpdateListeners;
    private final HashMap<ObjectName, List<JmxMetric>> metricsCache;

    public JmxMetricProviderService(List<JmxMetricsListener> metricsUpdateListeners) {
        this(metricsUpdateListeners, Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("" + FACTORY_ID.incrementAndGet())));
    }

    public JmxMetricProviderService(List<JmxMetricsListener> metricsUpdateListeners, ScheduledExecutorService executor) {
        this.executor = executor;
        this.metricsUpdateListeners = metricsUpdateListeners;
        this.metricsCache = new HashMap();
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    public void start(long initialDelay, long period, TimeUnit unit) throws EmptyJmxMetricListenerListException {
        if (this.metricsUpdateListeners == null || this.metricsUpdateListeners.size() == 0) {
            throw new EmptyJmxMetricListenerListException();
        }
        this.executor.scheduleAtFixedRate(() -> {
            try {
                this.checkForMetricsUpdate();
            }
            catch (Exception ex) {
                LOG.error("Exception thrown from #report. Exception was suppressed.", (Throwable)ex);
            }
        }, initialDelay, period, unit);
    }

    private void checkForMetricsUpdate() {
        Set<ObjectName> mbeans = this.server.queryNames(null, null);
        HashSet<ObjectName> remaining = new HashSet<ObjectName>(this.metricsCache.keySet());
        for (ObjectName mbean : mbeans) {
            if (this.metricsCache.containsKey(mbean)) {
                remaining.remove(mbean);
                continue;
            }
            try {
                List<JmxMetric> metrics = this.getMetricsForMBean(mbean);
                this.metricsCache.put(mbean, metrics);
                LOG.debug("Metrics : {}", (Object)metrics.toString());
                metrics.forEach(metric -> this.metricsUpdateListeners.forEach(listener -> {
                    try {
                        listener.metricChange((JmxMetric)metric);
                    }
                    catch (Exception e) {
                        LOG.error("error while calling listener.metricChange for metric:{}, listener:{}", (Object)metric.toString(), (Object)listener.getClass().getCanonicalName());
                    }
                }));
            }
            catch (JMException e) {
                LOG.error("Exception in registering for MBean {}", (Object)mbean, (Object)e);
            }
        }
        for (ObjectName mbean : remaining) {
            this.metricsCache.get(mbean).forEach(metric -> this.metricsUpdateListeners.forEach(listener -> listener.metricRemoval((JmxMetric)metric)));
            this.metricsCache.remove(mbean);
        }
    }

    private List<JmxMetric> getMetricsForMBean(ObjectName mbean) throws JMException {
        MBeanAttributeInfo[] attrInfo = this.server.getMBeanInfo(mbean).getAttributes();
        ArrayList<JmxMetric> metrics = new ArrayList<JmxMetric>();
        for (MBeanAttributeInfo attr : attrInfo) {
            try {
                Object value = this.server.getAttribute(mbean, attr.getName());
                if (value instanceof Number) {
                    metrics.add(new JmxMetric(mbean, attr, null, this.server));
                }
                if (!(value instanceof CompositeDataSupport)) continue;
                CompositeDataSupport cd = (CompositeDataSupport)value;
                cd.getCompositeType().keySet().stream().forEach(item -> {
                    Object value1 = cd.get((String)item);
                    if (value1 instanceof Number) {
                        metrics.add(new JmxMetric(mbean, attr, (String)item, this.server));
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Error in getting metric value of {} for attr {}", (Object)mbean, (Object)attr.getName());
            }
        }
        return metrics;
    }

    public void stop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.err.println(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "jxm-metric-provider-service-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

