/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import io.riemann.riemann.client.CachingResolver;
import io.riemann.riemann.client.Resolver;
import io.riemann.riemann.client.SynchronousTransport;
import io.riemann.riemann.client.Transport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class SimpleUdpTransport
implements SynchronousTransport {
    public static final int DEFAULT_PORT = 5555;
    private volatile DatagramSocket socket;
    private volatile boolean connected = false;
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;
    private volatile Resolver resolver;
    private volatile Resolver localResolver;
    public volatile boolean cacheDns = true;

    public SimpleUdpTransport(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = null;
    }

    public SimpleUdpTransport(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
    }

    public SimpleUdpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public SimpleUdpTransport(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        this(new InetSocketAddress(remoteHost, remotePort), new InetSocketAddress(localHost, localPort));
    }

    public SimpleUdpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public SimpleUdpTransport(String remoteHost, String localHost) throws IOException {
        this(remoteHost, 5555, localHost, 0);
    }

    public SimpleUdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public Proto.Msg sendMessage(Proto.Msg msg) throws IOException {
        byte[] body = msg.toByteArray();
        DatagramPacket packet = new DatagramPacket(body, body.length, this.resolver.resolve());
        this.socket.send(packet);
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.cacheDns) {
            this.resolver = new CachingResolver(this.remoteAddress);
            if (this.localAddress != null) {
                this.localResolver = new CachingResolver(this.localAddress);
            }
        } else {
            this.resolver = new Resolver(this.remoteAddress);
            if (this.localAddress != null) {
                this.localResolver = new Resolver(this.localAddress);
            }
        }
        this.socket = this.localAddress != null ? new DatagramSocket(this.localResolver.resolve()) : new DatagramSocket();
        this.connected = true;
    }

    @Override
    public synchronized void close() {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
            this.connected = false;
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Transport transport() {
        return null;
    }
}

