/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import io.riemann.riemann.client.Promise;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class WriteQueue {
    public boolean isOpen = true;
    public volatile int size = 0;
    public final LinkedBlockingQueue<Promise<Proto.Msg>> queue = new LinkedBlockingQueue();

    public synchronized void open() {
        this.isOpen = true;
        this.size = 0;
    }

    public synchronized void close(Throwable t) {
        Promise<Proto.Msg> promise;
        this.isOpen = false;
        IOException ex = new IOException("channel closed", t);
        while ((promise = this.queue.poll()) != null) {
            promise.deliver(ex);
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized void put(Promise<Proto.Msg> p) throws InterruptedException {
        if (this.isOpen) {
            try {
                this.queue.put(p);
                ++this.size;
            }
            catch (RuntimeException e) {
                this.size = this.queue.size();
                throw e;
            }
            catch (InterruptedException e) {
                this.size = this.queue.size();
                throw e;
            }
        } else {
            p.deliver(new IOException("Channel closed."));
        }
    }

    public synchronized Promise<Proto.Msg> take() {
        try {
            Promise<Proto.Msg> p = this.queue.take();
            --this.size;
            return p;
        }
        catch (RuntimeException e) {
            this.size = this.queue.size();
            throw e;
        }
        catch (InterruptedException e) {
            this.size = this.queue.size();
            throw new RuntimeException(e);
        }
    }
}

