(defproject com.gibbonspace/clj-webdriver "0.7.0-SNAPSHOT"
  :description "Clojure API for Selenium-WebDriver"
  :url "https://github.com/semperos/clj-webdriver"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/core.cache "0.6.4"]
                 [org.clojure/tools.logging "0.2.3"]
                 ;; Exclude these, giving preference to Selenium-WebDriver's
                 ;; dependence on them.
                 [clj-http "1.0.0" :exclusions [org.apache.httpcomponents/httpclient
                                                org.apache.httpcomponents/httpcore
                                                org.apache.httpcomponents/httpmime]]
                 [cheshire "5.3.0"]
                 [org.mortbay.jetty/jetty "6.1.26"]
                 [org.seleniumhq.selenium/selenium-server "2.43.1"]
                 [org.seleniumhq.selenium/selenium-java "2.43.1"]
                 [org.seleniumhq.selenium/selenium-remote-driver "2.43.1"]
                 [com.github.detro.ghostdriver/phantomjsdriver "1.1.0"
                  :exclusion [org.seleniumhq.selenium/selenium-java
                              org.seleniumhq.selenium/selenium-server
                              org.seleniumhq.selenium/selenium-remote-driver]]]
  :profiles {:dev
             {:dependencies
              [[criterium "0.4.3"]
               [codox "0.8.10"]
               [clj-time "0.8.0"]
               [marginalia "0.8.0"]
               [ring "1.3.1"]
               [ring-http-basic-auth "0.0.2"]
               [enlive "1.1.5"]
               [net.cgrand/moustache "1.1.0"]]}}
  :aot [#"clj-webdriver\.ext\.*"]
  :scm {:url "git@github.com:semperos/clj-webdriver.git"}
  :pom-addition [:developers [:developer [:name "Daniel Gregoire"]]])
