(ns optimusbuf.main
  (:require [optimusbuf.ast-transform :refer [unnest extract-extends remove-extends merge-extends]]
            [optimusbuf.parse :refer [parse]]
            [com.rpl.specter :refer [select transform walker ALL MAP-VALS]]))

(defn crawl
  [path file registry depth]
  (if (or (registry file) (< depth 0))
    registry
    (let [ast (parse (slurp (str path "/" file))) ; TODO: this slurp isn't cljs compatible
          imports (select [ALL #(= (first %) :import) (walker string?)] ast)
          registry (conj registry [file ast])]
      (reduce #(crawl path %2 %1 (dec depth)) registry imports))))

(defn transpile [path file]
  (let [reg (crawl path file {} 1)
        reg-u (transform [MAP-VALS] unnest reg)
        reg-extends (extract-extends reg-u)
        reg-u2 (remove-extends reg-u)
        reg-ue (reduce merge-extends reg-u2 reg-extends)]
    reg-ue))

;; (def temp (transpile "resources/protobuf" "reference.proto"))
