(ns optimusbuf.parse-textformat
  (:require #?(:cljs [optimusbuf.util.slurp :include-macros true :refer [slurp]])
            [clojure.string :refer [join]]
            [instaparse.core :as insta :refer [parser]]))

(def ^:private void
  "Matches whitespaces and comments; to be used as :auto-whitespace param when
   creating instaparse parser."
  (insta/parser
   "void = { #'\\s+' | '#' #'.*' }"))

(def ^:private parser-tf
  (parser (slurp "resources/ebnf/textformat.ebnf")
          :auto-whitespace void
          :start :tf_Field))

(defn merge-tuple-into-map
  "(merge-tuple-into-map {}           [:a 4])       => {:a [4]}
   (merge-tuple-into-map {:a [1 2 3]} [:a 4])       => {:a [1 2 3 4]}
   (merge-tuple-into-map {:a [1]}     [:a [2 3 4]]) => {:a [1 2 3 4]}"
  [m [k v]]
  (let [f (if (seq? v) into conj)]
    (assoc m k (f (get m k []) v))))

(defn xform-string [& strs]
  (->> strs
       (map #(subs % 1 (dec (count %)))) ; strip leading/trailing quote
       (clojure.string/join)))

(def xform-tf
  {:tf_FieldName #(str (join %&))
   :tf_ScalarField #(into [] %&)
   :tf_MessageField #(into [] %&)
   :tf_ScalarValue identity
   :tf_String xform-string
   :tf_Float #(parse-double (join %&))
   :tf_Identifier keyword
   :tf_SignedIdentifier #(keyword (join %&))
   :tf_DecSignedInteger #(parse-long (join %&))
   :tf_DecUnsignedInteger parse-long
   :tf_HexSignedInteger #(read-string (join %&))
   :tf_HexUnsignedInteger #(read-string (join %&))
   :tf_OctSignedInteger #(read-string (join %&))
   :tf_OctUnsignedInteger #(read-string (join %&))
   :tf_ScalarList #(into [] %&)
   :tf_MessageList #(into [] %&)
   :tf_Message #(reduce merge-tuple-into-map {} %&)
   :tf_Field identity})

(defn parse [text]
  (let [ast (parser-tf text)
        ast+line (insta/add-line-and-column-info-to-metadata text ast)]
    (insta/transform xform-tf ast+line)))
