/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.asm.Type;
import clojure.asm.commons.GeneratorAdapter;
import clojure.asm.commons.Method;
import clojure.lang.AFn;
import clojure.lang.Compiler;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import clojure.storm.Tracer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class Emitter {
    static final Type TRACER_CLASS_TYPE;
    static final Type OBJECT_CLASS_TYPE;
    static final Type INT_TYPE;
    static final Type INTEGER_CLASS_TYPE;
    static final Type LONG_CLASS_TYPE;
    static final Type DOUBLE_CLASS_TYPE;
    static Keyword LINE_KEY;
    static Keyword NS_KEY;
    public static Var INSTRUMENTATION_ENABLE;
    private static ArrayList<String> instrumentationSkipPrefixes;
    private static ArrayList<String> instrumentationOnlyPrefixes;

    public static void setInstrumentationEnable(final Boolean x) {
        AFn f = new AFn(){

            @Override
            public Object invoke(Object prev2) {
                return x;
            }
        };
        INSTRUMENTATION_ENABLE.alterRoot(f, null);
        System.out.println("Storm instrumentation set to: " + INSTRUMENTATION_ENABLE.deref());
    }

    public static Boolean getInstrumentationEnable() {
        return (Boolean)INSTRUMENTATION_ENABLE.deref();
    }

    public static String makePrefixesString(ArrayList<String> prefixes) {
        if (prefixes.size() > 0) {
            List prefs = prefixes.stream().map(p -> Compiler.demunge(p)).collect(Collectors.toList());
            return String.join((CharSequence)",", prefs);
        }
        return null;
    }

    public static ArrayList<String> getInstrumentationSkipPrefixes() {
        return instrumentationSkipPrefixes;
    }

    public static void addInstrumentationSkipPrefix(String prefix) {
        instrumentationSkipPrefixes.add(Compiler.munge(prefix));
    }

    public static void removeInstrumentationSkipPrefix(String prefix) {
        instrumentationSkipPrefixes.remove(Compiler.munge(prefix));
    }

    public static ArrayList<String> getInstrumentationOnlyPrefixes() {
        return instrumentationOnlyPrefixes;
    }

    public static void addInstrumentationOnlyPrefix(String prefix) {
        instrumentationOnlyPrefixes.add(Compiler.munge(prefix));
    }

    public static void removeInstrumentationOnlyPrefix(String prefix) {
        instrumentationOnlyPrefixes.remove(Compiler.munge(prefix));
    }

    public static boolean skipInstrumentation(String fqFnName) {
        boolean instrument = false;
        for (String prefix : instrumentationOnlyPrefixes) {
            instrument |= fqFnName.startsWith(prefix);
        }
        for (String prefix : instrumentationSkipPrefixes) {
            instrument &= !fqFnName.startsWith(prefix);
        }
        boolean skip = Emitter.getInstrumentationEnable() == false || !instrument;
        return skip;
    }

    private static void dupAndBox(GeneratorAdapter gen, Type t) {
        if (t != null && (Type.LONG_TYPE.equals(t) || Type.DOUBLE_TYPE.equals(t))) {
            gen.dup2();
            gen.valueOf(t);
        } else if (t != null && (Type.INT_TYPE.equals(t) || Type.BYTE_TYPE.equals(t) || Type.FLOAT_TYPE.equals(t) || Type.BOOLEAN_TYPE.equals(t) || Type.CHAR_TYPE.equals(t) || Type.SHORT_TYPE.equals(t))) {
            gen.dup();
            gen.valueOf(t);
        } else {
            gen.dup();
        }
    }

    public static void emitFnCallTrace(GeneratorAdapter gen, Compiler.ObjExpr objx, String mungedFnName, Type[] argtypes, IPersistentVector arglocals) {
        boolean skipFn = Emitter.skipInstrumentation(mungedFnName);
        if (!skipFn) {
            Integer formId = (Integer)Compiler.FORM_ID.deref();
            if (formId == null) {
                formId = 0;
            }
            Symbol name2 = Symbol.create(Compiler.demunge(mungedFnName));
            String fnName = name2.getName();
            String fnNs = name2.getNamespace();
            gen.loadArgArray();
            gen.invokeStatic(Type.getType(PersistentVector.class), Method.getMethod("clojure.lang.PersistentVector create(Object[])"));
            gen.push(fnNs);
            gen.push(fnName);
            gen.push(formId);
            gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void traceFnCall(clojure.lang.IPersistentVector, String, String, int)"));
            Emitter.emitBindTraces(gen, objx, arglocals, PersistentVector.EMPTY);
        }
    }

    public static void emitFnReturnTrace(GeneratorAdapter gen, String mungedFnName, IPersistentVector coord, Type retType) {
        boolean skipFn = Emitter.skipInstrumentation(mungedFnName);
        if (!skipFn) {
            Integer formId = (Integer)Compiler.FORM_ID.deref();
            if (formId == null) {
                formId = 0;
            }
            if (Type.VOID_TYPE.equals(retType)) {
                gen.visitInsn(1);
            } else {
                Emitter.dupAndBox(gen, retType);
            }
            Emitter.emitCoord(gen, coord);
            gen.push(formId);
            gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void traceFnReturn(Object, String, int)"));
        }
    }

    private static void emitCoord(GeneratorAdapter gen, IPersistentVector coord) {
        HashSet emittedCoords = (HashSet)Compiler.FORM_COORDS.deref();
        if (coord == null) {
            coord = PersistentVector.EMPTY;
        }
        StringBuilder strCoordBuilder = new StringBuilder();
        for (int i = 0; i < coord.count(); ++i) {
            strCoordBuilder.append(coord.nth(i));
            if (i >= coord.count() - 1) continue;
            strCoordBuilder.append(",");
        }
        String strCoord = strCoordBuilder.toString();
        gen.push(strCoord);
        emittedCoords.add(strCoord);
    }

    public static void emitExprTrace(GeneratorAdapter gen, Compiler.ObjExpr objx, IPersistentVector coord, Type retType) {
        if (coord != null) {
            Integer formId = (Integer)Compiler.FORM_ID.deref();
            if (formId == null) {
                formId = 0;
            }
            if ((objx instanceof Compiler.FnExpr || objx instanceof Compiler.NewInstanceExpr) && !Emitter.skipInstrumentation(objx.name())) {
                Emitter.dupAndBox(gen, retType);
                Emitter.emitCoord(gen, coord);
                gen.push(formId);
                gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void traceExpr(Object, String, int)"));
            }
        }
    }

    public static void emitBindTrace(GeneratorAdapter gen, Compiler.ObjExpr objx, Compiler.BindingInit bi, IPersistentVector coord) {
        String symName = Compiler.demunge(bi.binding().name);
        Integer bIdx = bi.binding().idx;
        if (objx instanceof Compiler.FnExpr && !Emitter.skipInstrumentation(((Compiler.FnExpr)objx).name()) && coord != null && !symName.equals("-") && !symName.contains("--")) {
            Type valType = null;
            Class primc = Compiler.maybePrimitiveType(bi.init());
            if (primc != null) {
                valType = Type.getType(primc);
            }
            Emitter.dupAndBox(gen, valType);
            Emitter.emitCoord(gen, coord);
            gen.push(symName);
            gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void traceBind(Object, String, String)"));
        }
    }

    public static void emitBindTraces(GeneratorAdapter gen, Compiler.ObjExpr objx, IPersistentVector localBindings, IPersistentVector coord) {
        if (objx instanceof Compiler.FnExpr && !Emitter.skipInstrumentation(((Compiler.FnExpr)objx).name())) {
            for (int i = 0; i < localBindings.count(); ++i) {
                Compiler.LocalBinding lb = (Compiler.LocalBinding)localBindings.nth(i);
                String symName = Compiler.demunge(lb.name);
                if (coord == null || symName.equals("-") || symName.contains("--") || !lb.used) continue;
                objx.emitLocal(gen, lb, false, null);
                Emitter.emitCoord(gen, coord);
                gen.push(symName);
                gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void traceBind(Object, String, String)"));
            }
        }
    }

    public static void emitFormsRegistration(GeneratorAdapter gen, List<Object> forms, String sourcePath) {
        Namespace ns2 = (Namespace)RT.CURRENT_NS.deref();
        String fns = ns2.getName().toString();
        if (!Emitter.skipInstrumentation(Compiler.munge(fns))) {
            for (Object form : forms) {
                IPersistentMap fmeta = RT.meta(form);
                if (fmeta == null) continue;
                int fline = -1;
                Object oline = fmeta.valAt(LINE_KEY);
                if (oline instanceof Integer) {
                    fline = (Integer)oline;
                }
                int fid = form.hashCode();
                gen.push(fid);
                gen.push(fline);
                gen.push(fns);
                gen.push(sourcePath);
                gen.invokeStatic(TRACER_CLASS_TYPE, Method.getMethod("void registerFormLocation(int, int, String, String)"));
            }
        }
    }

    static {
        String onlyPrefixesProp;
        String skipPrefixesProp;
        TRACER_CLASS_TYPE = Type.getType(Tracer.class);
        OBJECT_CLASS_TYPE = Type.getType(Object.class);
        INT_TYPE = Type.getType(Integer.TYPE);
        INTEGER_CLASS_TYPE = Type.getType(Integer.class);
        LONG_CLASS_TYPE = Type.getType(Long.class);
        DOUBLE_CLASS_TYPE = Type.getType(Double.class);
        LINE_KEY = Keyword.intern(null, "line");
        NS_KEY = Keyword.intern(null, "ns");
        INSTRUMENTATION_ENABLE = Var.create(false).setDynamic();
        instrumentationSkipPrefixes = new ArrayList();
        instrumentationOnlyPrefixes = new ArrayList();
        String instrumentationEnableProp = System.getProperty("clojure.storm.instrumentEnable");
        if (instrumentationEnableProp != null) {
            Emitter.setInstrumentationEnable(Boolean.parseBoolean(instrumentationEnableProp));
        }
        if ((skipPrefixesProp = System.getProperty("clojure.storm.instrumentSkipPrefixes")) != null) {
            String[] prefixes;
            for (String p : prefixes = skipPrefixesProp.split(",")) {
                Emitter.addInstrumentationSkipPrefix(p);
            }
        }
        if ((onlyPrefixesProp = System.getProperty("clojure.storm.instrumentOnlyPrefixes")) != null) {
            String[] prefixes;
            for (String p : prefixes = onlyPrefixesProp.split(",")) {
                Emitter.addInstrumentationOnlyPrefix(p);
            }
        }
    }
}

