/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;

public class LineNumberingPushbackReader
extends PushbackReader {
    private static final int newline = 10;
    private boolean _atLineStart = true;
    private boolean _prev;
    private int _columnNumber = 1;
    private StringBuilder sb = null;

    public LineNumberingPushbackReader(Reader r) {
        super(new LineNumberReader(r));
    }

    public LineNumberingPushbackReader(Reader r, int size) {
        super(new LineNumberReader(r, size));
    }

    public int getLineNumber() {
        return ((LineNumberReader)this.in).getLineNumber() + 1;
    }

    public void setLineNumber(int line) {
        ((LineNumberReader)this.in).setLineNumber(line - 1);
    }

    public void captureString() {
        this.sb = new StringBuilder();
    }

    public String getString() {
        if (this.sb != null) {
            String ret = this.sb.toString();
            this.sb = null;
            return ret;
        }
        return null;
    }

    public int getColumnNumber() {
        return this._columnNumber;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        this._prev = this._atLineStart;
        if (c == 10 || c == -1) {
            this._atLineStart = true;
            this._columnNumber = 1;
        } else {
            this._atLineStart = false;
            ++this._columnNumber;
        }
        if (this.sb != null && c != -1) {
            this.sb.append((char)c);
        }
        return c;
    }

    @Override
    public void unread(int c) throws IOException {
        super.unread(c);
        this._atLineStart = this._prev;
        --this._columnNumber;
        if (this.sb != null) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
    }

    public String readLine() throws IOException {
        String line;
        int c = this.read();
        switch (c) {
            case -1: {
                line = null;
                break;
            }
            case 10: {
                line = "";
                break;
            }
            default: {
                String first = String.valueOf((char)c);
                String rest = ((LineNumberReader)this.in).readLine();
                if (this.sb != null) {
                    this.sb.append(rest + "\n");
                }
                line = rest == null ? first : first + rest;
                this._prev = false;
                this._atLineStart = true;
                this._columnNumber = 1;
            }
        }
        return line;
    }

    public boolean atLineStart() {
        return this._atLineStart;
    }
}

