// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimizations :none}
goog.provide('cljs.core');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
goog.require('goog.math.Long');
goog.scope(function(){
cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
goog.require('goog.object');
goog.scope(function(){
cljs.core.goog$module$goog$object = goog.module.get('goog.object');
});
goog.require('goog.array');
goog.scope(function(){
cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.60";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14028(){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

cljs.core.set_print_err_fn_BANG_((function cljs$core$enable_console_print_BANG__$_fn_14029(){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone.call(null,xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__9487__auto__ = ty;
if(cljs.core.truth_(and__9487__auto__)){
return ty.cljs$lang$type;
} else {
return and__9487__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__14034 = arguments.length;
switch (G__14034) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14040 = arguments.length;
var i__10823__auto___14041 = (0);
while(true){
if((i__10823__auto___14041 < len__10822__auto___14040)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14041]));

var G__14042 = (i__10823__auto___14041 + (1));
i__10823__auto___14041 = G__14042;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14035(size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14036(type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14037(type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__10581__auto___14043 = dimarray.length;
var i_14044 = (0);
while(true){
if((i_14044 < n__10581__auto___14043)){
(dimarray[i_14044] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__14045 = (i_14044 + (1));
i_14044 = G__14045;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function cljs$core$fn_14038(seq14031){
var G__14032 = cljs.core.first(seq14031);
var seq14031__$1 = cljs.core.next(seq14031);
var G__14033 = cljs.core.first(seq14031__$1);
var seq14031__$2 = cljs.core.next(seq14031__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14032,G__14033,seq14031__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__10581__auto___14046 = len;
var i_14047 = (0);
while(true){
if((i_14047 < n__10581__auto___14046)){
(new_arr[i_14047] = (arr[i_14047]));

var G__14048 = (i_14047 + (1));
i_14047 = G__14048;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__14049 = (i + (1));
i = G__14049;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__14054 = arguments.length;
switch (G__14054) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14060 = arguments.length;
var i__10823__auto___14061 = (0);
while(true){
if((i__10823__auto___14061 < len__10822__auto___14060)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14061]));

var G__14062 = (i__10823__auto___14061 + (1));
i__10823__auto___14061 = G__14062;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14055(array,idx){
try{if(cljs.core.truth_((function (){var or__9493__auto__ = cljs.core.array_QMARK_(array);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14056){var e_14063 = e14056;
cljs.core.maybe_warn(e_14063);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14057(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function cljs$core$fn_14058(seq14051){
var G__14052 = cljs.core.first(seq14051);
var seq14051__$1 = cljs.core.next(seq14051);
var G__14053 = cljs.core.first(seq14051__$1);
var seq14051__$2 = cljs.core.next(seq14051__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14052,G__14053,seq14051__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__14069 = arguments.length;
switch (G__14069) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14075 = arguments.length;
var i__10823__auto___14076 = (0);
while(true){
if((i__10823__auto___14076 < len__10822__auto___14075)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14076]));

var G__14077 = (i__10823__auto___14076 + (1));
i__10823__auto___14076 = G__14077;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14070(array,idx,val){
try{if(cljs.core.truth_((function (){var or__9493__auto__ = cljs.core.array_QMARK_(array);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e14071){var e_14078 = e14071;
cljs.core.maybe_warn(e_14078);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14072(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function cljs$core$fn_14073(seq14065){
var G__14066 = cljs.core.first(seq14065);
var seq14065__$1 = cljs.core.next(seq14065);
var G__14067 = cljs.core.first(seq14065__$1);
var seq14065__$2 = cljs.core.next(seq14065__$1);
var G__14068 = cljs.core.first(seq14065__$2);
var seq14065__$3 = cljs.core.next(seq14065__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14066,G__14067,G__14068,seq14065__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__14083 = arguments.length;
switch (G__14083) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14088 = arguments.length;
var i__10823__auto___14089 = (0);
while(true){
if((i__10823__auto___14089 < len__10822__auto___14088)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14089]));

var G__14090 = (i__10823__auto___14089 + (1));
i__10823__auto___14089 = G__14090;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14084(array,idx){
if(cljs.core.truth_((function (){var or__9493__auto__ = cljs.core.array_QMARK_(array);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14085(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14086(seq14080){
var G__14081 = cljs.core.first(seq14080);
var seq14080__$1 = cljs.core.next(seq14080);
var G__14082 = cljs.core.first(seq14080__$1);
var seq14080__$2 = cljs.core.next(seq14080__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14081,G__14082,seq14080__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__14096 = arguments.length;
switch (G__14096) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14101 = arguments.length;
var i__10823__auto___14102 = (0);
while(true){
if((i__10823__auto___14102 < len__10822__auto___14101)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14102]));

var G__14103 = (i__10823__auto___14102 + (1));
i__10823__auto___14102 = G__14103;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14097(array,idx,val){
if(cljs.core.truth_((function (){var or__9493__auto__ = cljs.core.array_QMARK_(array);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14098(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function cljs$core$fn_14099(seq14092){
var G__14093 = cljs.core.first(seq14092);
var seq14092__$1 = cljs.core.next(seq14092);
var G__14094 = cljs.core.first(seq14092__$1);
var seq14092__$2 = cljs.core.next(seq14092__$1);
var G__14095 = cljs.core.first(seq14092__$2);
var seq14092__$3 = cljs.core.next(seq14092__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14093,G__14094,G__14095,seq14092__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__14108 = arguments.length;
switch (G__14108) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14113 = arguments.length;
var i__10823__auto___14114 = (0);
while(true){
if((i__10823__auto___14114 < len__10822__auto___14113)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14114]));

var G__14115 = (i__10823__auto___14114 + (1));
i__10823__auto___14114 = G__14115;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14109(array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14110(array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function cljs$core$fn_14111(seq14105){
var G__14106 = cljs.core.first(seq14105);
var seq14105__$1 = cljs.core.next(seq14105);
var G__14107 = cljs.core.first(seq14105__$1);
var seq14105__$2 = cljs.core.next(seq14105__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14106,G__14107,seq14105__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__14121 = arguments.length;
switch (G__14121) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14126 = arguments.length;
var i__10823__auto___14127 = (0);
while(true){
if((i__10823__auto___14127 < len__10822__auto___14126)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14127]));

var G__14128 = (i__10823__auto___14127 + (1));
i__10823__auto___14127 = G__14128;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14122(array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14123(array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function cljs$core$fn_14124(seq14117){
var G__14118 = cljs.core.first(seq14117);
var seq14117__$1 = cljs.core.next(seq14117);
var G__14119 = cljs.core.first(seq14117__$1);
var seq14117__$2 = cljs.core.next(seq14117__$1);
var G__14120 = cljs.core.first(seq14117__$2);
var seq14117__$3 = cljs.core.next(seq14117__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14118,G__14119,G__14120,seq14117__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__14130 = arguments.length;
switch (G__14130) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14131(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14132(type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_14132_$_fn_14133(a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__10832__auto__ = [];
var len__10822__auto___14140 = arguments.length;
var i__10823__auto___14141 = (0);
while(true){
if((i__10823__auto___14141 < len__10822__auto___14140)){
args__10832__auto__.push((arguments[i__10823__auto___14141]));

var G__14142 = (i__10823__auto___14141 + (1));
i__10823__auto___14141 = G__14142;
continue;
} else {
}
break;
}

var argseq__10833__auto__ = ((((2) < args__10832__auto__.length))?(new cljs.core.IndexedSeq(args__10832__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10833__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14138(obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function cljs$core$fn_14139(seq14135){
var G__14136 = cljs.core.first(seq14135);
var seq14135__$1 = cljs.core.next(seq14135);
var G__14137 = cljs.core.first(seq14135__$1);
var seq14135__$2 = cljs.core.next(seq14135__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14136,G__14137,seq14135__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_14168 = (function() {
var cljs$core$fn_14143 = null;
var cljs$core$fn_14143__1 = (function (this$){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10243__auto__.call(null,this$));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__10241__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__2 = (function (this$,a){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10243__auto__.call(null,this$,a));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__10241__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__3 = (function (this$,a,b){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10243__auto__.call(null,this$,a,b));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__10241__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__4 = (function (this$,a,b,c){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10243__auto__.call(null,this$,a,b,c));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__10241__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__5 = (function (this$,a,b,c,d){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10243__auto__.call(null,this$,a,b,c,d));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__10241__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__6 = (function (this$,a,b,c,d,e){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10243__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$6 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__10241__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__7 = (function (this$,a,b,c,d,e,f){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10243__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$7 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__10241__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__8 = (function (this$,a,b,c,d,e,f,g){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$8 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$9 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$10 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$11 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$12 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$13 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$14 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$15 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$16 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$17 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$18 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$19 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$20 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$21 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var cljs$core$fn_14143__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._invoke[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10243__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__10241__auto__ = (cljs.core._invoke["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$22 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__10241__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
cljs$core$fn_14143 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14143__1.call(this,this$);
case 2:
return cljs$core$fn_14143__2.call(this,this$,a);
case 3:
return cljs$core$fn_14143__3.call(this,this$,a,b);
case 4:
return cljs$core$fn_14143__4.call(this,this$,a,b,c);
case 5:
return cljs$core$fn_14143__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$fn_14143__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$fn_14143__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14143__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14143__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14143__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14143__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14143__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14143__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14143__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14143__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14143__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14143__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14143__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14143__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14143__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14143__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14143__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14143__1;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14143__2;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14143__3;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14143__4;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14143__5;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14143__6;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14143__7;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14143__8;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14143__9;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14143__10;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14143__11;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14143__12;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14143__13;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14143__14;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14143__15;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14143__16;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14143__17;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14143__18;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14143__19;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14143__20;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14143__21;
cljs$core$fn_14143.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14143__22;
return cljs$core$fn_14143;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__14145 = arguments.length;
switch (G__14145) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14146(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14147(this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14148(this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14149(this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14150(this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14151(this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14152(this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14153(this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14154(this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14155(this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14156(this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14157(this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14158(this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14159(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14160(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14161(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14162(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14163(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14164(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14165(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14166(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function cljs$core$fn_14167(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_14168.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_14171 = (function cljs$core$fn_14170(value){
var x__10242__auto__ = (((value == null))?null:value);
var m__10243__auto__ = (cljs.core._clone[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10243__auto__.call(null,value));
} else {
var m__10241__auto__ = (cljs.core._clone["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__10241__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_14171(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_14173 = (function cljs$core$fn_14172(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._count[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._count["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_14173(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_14175 = (function cljs$core$fn_14174(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._empty[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._empty["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_14175(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_14177 = (function cljs$core$fn_14176(coll,o){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._conj[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10243__auto__.call(null,coll,o));
} else {
var m__10241__auto__ = (cljs.core._conj["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__10241__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_14177(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_14183 = (function() {
var cljs$core$fn_14178 = null;
var cljs$core$fn_14178__2 = (function (coll,n){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._nth[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10243__auto__.call(null,coll,n));
} else {
var m__10241__auto__ = (cljs.core._nth["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__10241__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var cljs$core$fn_14178__3 = (function (coll,n,not_found){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._nth[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10243__auto__.call(null,coll,n,not_found));
} else {
var m__10241__auto__ = (cljs.core._nth["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__10241__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
cljs$core$fn_14178 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14178__2.call(this,coll,n);
case 3:
return cljs$core$fn_14178__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14178.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14178__2;
cljs$core$fn_14178.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14178__3;
return cljs$core$fn_14178;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__14180 = arguments.length;
switch (G__14180) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14181(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_14183.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14182(coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_14183.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_14187 = (function cljs$core$fn_14185(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._first[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._first["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_14187(coll);
}
});

var cljs$core$ISeq$_rest$dyn_14188 = (function cljs$core$fn_14186(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._rest[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._rest["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_14188(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_14190 = (function cljs$core$fn_14189(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._next[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._next["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_14190(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_14196 = (function() {
var cljs$core$fn_14191 = null;
var cljs$core$fn_14191__2 = (function (o,k){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._lookup[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10243__auto__.call(null,o,k));
} else {
var m__10241__auto__ = (cljs.core._lookup["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__10241__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var cljs$core$fn_14191__3 = (function (o,k,not_found){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._lookup[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10243__auto__.call(null,o,k,not_found));
} else {
var m__10241__auto__ = (cljs.core._lookup["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__10241__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
cljs$core$fn_14191 = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14191__2.call(this,o,k);
case 3:
return cljs$core$fn_14191__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14191.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14191__2;
cljs$core$fn_14191.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14191__3;
return cljs$core$fn_14191;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__14193 = arguments.length;
switch (G__14193) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14194(o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_14196.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14195(o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_14196.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_14200 = (function cljs$core$fn_14198(coll,k){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10243__auto__.call(null,coll,k));
} else {
var m__10241__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10241__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_14200(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_14201 = (function cljs$core$fn_14199(coll,k,v){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._assoc[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10243__auto__.call(null,coll,k,v));
} else {
var m__10241__auto__ = (cljs.core._assoc["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__10241__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_14201(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_14203 = (function cljs$core$fn_14202(coll,k){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._find[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10243__auto__.call(null,coll,k));
} else {
var m__10241__auto__ = (cljs.core._find["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10241__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_14203(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_14205 = (function cljs$core$fn_14204(coll,k){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._dissoc[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10243__auto__.call(null,coll,k));
} else {
var m__10241__auto__ = (cljs.core._dissoc["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__10241__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_14205(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_14208 = (function cljs$core$fn_14206(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._key[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._key["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_14208(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_14209 = (function cljs$core$fn_14207(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._val[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._val["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_14209(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_14211 = (function cljs$core$fn_14210(coll,v){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._disjoin[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10243__auto__.call(null,coll,v));
} else {
var m__10241__auto__ = (cljs.core._disjoin["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__10241__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_14211(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_14214 = (function cljs$core$fn_14212(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._peek[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._peek["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_14214(coll);
}
});

var cljs$core$IStack$_pop$dyn_14215 = (function cljs$core$fn_14213(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._pop[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._pop["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_14215(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_14217 = (function cljs$core$fn_14216(coll,n,val){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._assoc_n[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10243__auto__.call(null,coll,n,val));
} else {
var m__10241__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__10241__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_14217(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_14219 = (function cljs$core$fn_14218(o){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._deref[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10243__auto__.call(null,o));
} else {
var m__10241__auto__ = (cljs.core._deref["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10241__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_14219(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14221 = (function cljs$core$fn_14220(o,msec,timeout_val){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10243__auto__.call(null,o,msec,timeout_val));
} else {
var m__10241__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__10241__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_14221(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_14223 = (function cljs$core$fn_14222(o){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._meta[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10243__auto__.call(null,o));
} else {
var m__10241__auto__ = (cljs.core._meta["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10241__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_14223(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_14225 = (function cljs$core$fn_14224(o,meta){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._with_meta[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10243__auto__.call(null,o,meta));
} else {
var m__10241__auto__ = (cljs.core._with_meta["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__10241__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_14225(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_14231 = (function() {
var cljs$core$fn_14226 = null;
var cljs$core$fn_14226__2 = (function (coll,f){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._reduce[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10243__auto__.call(null,coll,f));
} else {
var m__10241__auto__ = (cljs.core._reduce["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__10241__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var cljs$core$fn_14226__3 = (function (coll,f,start){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._reduce[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10243__auto__.call(null,coll,f,start));
} else {
var m__10241__auto__ = (cljs.core._reduce["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__10241__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
cljs$core$fn_14226 = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$fn_14226__2.call(this,coll,f);
case 3:
return cljs$core$fn_14226__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14226__2;
cljs$core$fn_14226.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14226__3;
return cljs$core$fn_14226;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__14228 = arguments.length;
switch (G__14228) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14229(coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_14231.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14230(coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_14231.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_14234 = (function cljs$core$fn_14233(coll,f,init){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10243__auto__.call(null,coll,f,init));
} else {
var m__10241__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__10241__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_14234(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_14236 = (function cljs$core$fn_14235(o,other){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._equiv[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10243__auto__.call(null,o,other));
} else {
var m__10241__auto__ = (cljs.core._equiv["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__10241__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_14236(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_14238 = (function cljs$core$fn_14237(o){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._hash[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10243__auto__.call(null,o));
} else {
var m__10241__auto__ = (cljs.core._hash["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10241__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_14238(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_14240 = (function cljs$core$fn_14239(o){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._seq[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10243__auto__.call(null,o));
} else {
var m__10241__auto__ = (cljs.core._seq["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__10241__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_14240(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_14242 = (function cljs$core$fn_14241(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._rseq[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._rseq["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_14242(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_14247 = (function cljs$core$fn_14243(coll,ascending_QMARK_){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10243__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__10241__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__10241__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_14247(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_14248 = (function cljs$core$fn_14244(coll,k,ascending_QMARK_){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10243__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__10241__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__10241__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_14248(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_14249 = (function cljs$core$fn_14245(coll,entry){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._entry_key[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10243__auto__.call(null,coll,entry));
} else {
var m__10241__auto__ = (cljs.core._entry_key["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__10241__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_14249(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_14250 = (function cljs$core$fn_14246(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._comparator[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._comparator["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_14250(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_14253 = (function cljs$core$fn_14251(writer,s){
var x__10242__auto__ = (((writer == null))?null:writer);
var m__10243__auto__ = (cljs.core._write[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10243__auto__.call(null,writer,s));
} else {
var m__10241__auto__ = (cljs.core._write["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__10241__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_14253(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_14254 = (function cljs$core$fn_14252(writer){
var x__10242__auto__ = (((writer == null))?null:writer);
var m__10243__auto__ = (cljs.core._flush[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10243__auto__.call(null,writer));
} else {
var m__10241__auto__ = (cljs.core._flush["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__10241__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_14254(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_14256 = (function cljs$core$fn_14255(o,writer,opts){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._pr_writer[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10243__auto__.call(null,o,writer,opts));
} else {
var m__10241__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__10241__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_14256(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_14258 = (function cljs$core$fn_14257(x){
var x__10242__auto__ = (((x == null))?null:x);
var m__10243__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10243__auto__.call(null,x));
} else {
var m__10241__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10241__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_14258(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_14262 = (function cljs$core$fn_14259(this$,oldval,newval){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._notify_watches[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10243__auto__.call(null,this$,oldval,newval));
} else {
var m__10241__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__10241__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_14262(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_14263 = (function cljs$core$fn_14260(this$,key,f){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._add_watch[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10243__auto__.call(null,this$,key,f));
} else {
var m__10241__auto__ = (cljs.core._add_watch["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__10241__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_14263(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_14264 = (function cljs$core$fn_14261(this$,key){
var x__10242__auto__ = (((this$ == null))?null:this$);
var m__10243__auto__ = (cljs.core._remove_watch[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10243__auto__.call(null,this$,key));
} else {
var m__10241__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__10241__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_14264(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_14266 = (function cljs$core$fn_14265(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._as_transient[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._as_transient["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_14266(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_14269 = (function cljs$core$fn_14267(tcoll,val){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10243__auto__.call(null,tcoll,val));
} else {
var m__10241__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__10241__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_14269(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_14270 = (function cljs$core$fn_14268(tcoll){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10243__auto__.call(null,tcoll));
} else {
var m__10241__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10241__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_14270(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14272 = (function cljs$core$fn_14271(tcoll,key,val){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10243__auto__.call(null,tcoll,key,val));
} else {
var m__10241__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__10241__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_14272(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_14274 = (function cljs$core$fn_14273(tcoll,key){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10243__auto__.call(null,tcoll,key));
} else {
var m__10241__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__10241__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_14274(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14277 = (function cljs$core$fn_14275(tcoll,n,val){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10243__auto__.call(null,tcoll,n,val));
} else {
var m__10241__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__10241__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_14277(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_14278 = (function cljs$core$fn_14276(tcoll){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10243__auto__.call(null,tcoll));
} else {
var m__10241__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__10241__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_14278(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_14280 = (function cljs$core$fn_14279(tcoll,v){
var x__10242__auto__ = (((tcoll == null))?null:tcoll);
var m__10243__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10243__auto__.call(null,tcoll,v));
} else {
var m__10241__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__10241__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_14280(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_14282 = (function cljs$core$fn_14281(x,y){
var x__10242__auto__ = (((x == null))?null:x);
var m__10243__auto__ = (cljs.core._compare[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10243__auto__.call(null,x,y));
} else {
var m__10241__auto__ = (cljs.core._compare["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__10241__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_14282(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_14284 = (function cljs$core$fn_14283(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._drop_first[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._drop_first["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_14284(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_14287 = (function cljs$core$fn_14285(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._chunked_first[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_14287(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_14288 = (function cljs$core$fn_14286(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_14288(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_14290 = (function cljs$core$fn_14289(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._chunked_next[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_14290(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_14293 = (function cljs$core$fn_14291(x){
var x__10242__auto__ = (((x == null))?null:x);
var m__10243__auto__ = (cljs.core._name[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10243__auto__.call(null,x));
} else {
var m__10241__auto__ = (cljs.core._name["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10241__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_14293(x);
}
});

var cljs$core$INamed$_namespace$dyn_14294 = (function cljs$core$fn_14292(x){
var x__10242__auto__ = (((x == null))?null:x);
var m__10243__auto__ = (cljs.core._namespace[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10243__auto__.call(null,x));
} else {
var m__10241__auto__ = (cljs.core._namespace["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__10241__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_14294(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_14296 = (function cljs$core$fn_14295(o,new_value){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10243__auto__.call(null,o,new_value));
} else {
var m__10241__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10241__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_14296(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_14304 = (function() {
var cljs$core$fn_14297 = null;
var cljs$core$fn_14297__2 = (function (o,f){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10243__auto__.call(null,o,f));
} else {
var m__10241__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__10241__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14297__3 = (function (o,f,a){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10243__auto__.call(null,o,f,a));
} else {
var m__10241__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$3 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__10241__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14297__4 = (function (o,f,a,b){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10243__auto__.call(null,o,f,a,b));
} else {
var m__10241__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$4 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__10241__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var cljs$core$fn_14297__5 = (function (o,f,a,b,xs){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10243__auto__.call(null,o,f,a,b,xs));
} else {
var m__10241__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$5 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__10241__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
cljs$core$fn_14297 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$fn_14297__2.call(this,o,f);
case 3:
return cljs$core$fn_14297__3.call(this,o,f,a);
case 4:
return cljs$core$fn_14297__4.call(this,o,f,a,b);
case 5:
return cljs$core$fn_14297__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14297.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14297__2;
cljs$core$fn_14297.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14297__3;
cljs$core$fn_14297.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14297__4;
cljs$core$fn_14297.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14297__5;
return cljs$core$fn_14297;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__14299 = arguments.length;
switch (G__14299) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14300(o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14304.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14301(o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14304.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14302(o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14304.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14303(o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_14304.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_14307 = (function cljs$core$fn_14306(o,new_value){
var x__10242__auto__ = (((o == null))?null:o);
var m__10243__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10243__auto__.call(null,o,new_value));
} else {
var m__10241__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$2 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__10241__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_14307(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_14309 = (function cljs$core$fn_14308(coll){
var x__10242__auto__ = (((coll == null))?null:coll);
var m__10243__auto__ = (cljs.core._iterator[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10243__auto__.call(null,coll));
} else {
var m__10241__auto__ = (cljs.core._iterator["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__10241__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_14309(coll);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function cljs$core$fn_14310(_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function cljs$core$fn_14311(_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function cljs$core$fn_14312(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function cljs$core$fn_14313(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__14314 = (i + (2));
var G__14315 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__14314;
h1 = G__14315;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__14318 = (i + (1));
var G__14319 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__14318;
hash = G__14319;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set.call(null,cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
return (Math.floor(o) % (2147483647));
} else {
var G__14323 = o;
switch (G__14323) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9487__auto__ = cljs.core.not(a.ns);
if(and__9487__auto__){
return b.ns;
} else {
return and__9487__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__14325 = a.ns;
var G__14326 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14325,G__14326);
})();
if(((0) === nsc)){
var G__14327 = a.name;
var G__14328 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14327,G__14328);
} else {
return nsc;
}
}
} else {
var G__14329 = a.name;
var G__14330 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14329,G__14330);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function cljs$core$fn_14332(){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function cljs$core$fn_14333(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14334(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var cljs$core$fn_14335 = null;
var cljs$core$fn_14335__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var cljs$core$fn_14335__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
cljs$core$fn_14335 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_14335__2.call(this,self__,coll);
case 3:
return cljs$core$fn_14335__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14335.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14335__2;
cljs$core$fn_14335.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14335__3;
return cljs$core$fn_14335;
})()
);

(cljs.core.Symbol.prototype.apply = (function cljs$core$fn_14336(self__,args14331){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args14331);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__14337 = args__10096__auto__.slice((0),(20));
G__14337.push(args__10096__auto__.slice((20)));

return G__14337;
})():args__10096__auto__)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14338(coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14339(coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14340(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14341(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14342(sym){
var self__ = this;
var sym__$1 = this;
var h__9954__auto__ = self__._hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_14343(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_14344(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_14345(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function cljs$core$fn_14346(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function cljs$core$fn_14347(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__14349 = arguments.length;
switch (G__14349) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14350(name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__14353 = name.fqn;
name = G__14353;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14351(ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function cljs$core$fn_14355(){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function cljs$core$fn_14356(){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14357(_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14358(_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14359(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14360(this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14361(_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var cljs$core$fn_14362 = null;
var cljs$core$fn_14362__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14363 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14363.cljs$core$IFn$_invoke$arity$0 ? fexpr__14363.cljs$core$IFn$_invoke$arity$0() : fexpr__14363.call(null));
});
var cljs$core$fn_14362__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14364 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14364.cljs$core$IFn$_invoke$arity$1 ? fexpr__14364.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14364.call(null,a));
});
var cljs$core$fn_14362__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14365 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14365.cljs$core$IFn$_invoke$arity$2 ? fexpr__14365.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14365.call(null,a,b));
});
var cljs$core$fn_14362__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14366 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14366.cljs$core$IFn$_invoke$arity$3 ? fexpr__14366.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14366.call(null,a,b,c));
});
var cljs$core$fn_14362__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14367 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14367.cljs$core$IFn$_invoke$arity$4 ? fexpr__14367.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14367.call(null,a,b,c,d));
});
var cljs$core$fn_14362__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14368 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14368.cljs$core$IFn$_invoke$arity$5 ? fexpr__14368.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14368.call(null,a,b,c,d,e));
});
var cljs$core$fn_14362__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14369 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14369.cljs$core$IFn$_invoke$arity$6 ? fexpr__14369.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14369.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14362__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14370 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14370.cljs$core$IFn$_invoke$arity$7 ? fexpr__14370.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14370.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14362__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14371 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14371.cljs$core$IFn$_invoke$arity$8 ? fexpr__14371.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14371.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14362__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14372 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14372.cljs$core$IFn$_invoke$arity$9 ? fexpr__14372.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14372.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14362__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14373 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14373.cljs$core$IFn$_invoke$arity$10 ? fexpr__14373.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14373.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14362__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14374 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14374.cljs$core$IFn$_invoke$arity$11 ? fexpr__14374.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14374.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14362__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14375 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14375.cljs$core$IFn$_invoke$arity$12 ? fexpr__14375.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14375.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14362__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14376 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14376.cljs$core$IFn$_invoke$arity$13 ? fexpr__14376.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14376.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14362__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14377 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14377.cljs$core$IFn$_invoke$arity$14 ? fexpr__14377.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14377.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14362__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14378 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14378.cljs$core$IFn$_invoke$arity$15 ? fexpr__14378.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14378.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14362__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14379 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14379.cljs$core$IFn$_invoke$arity$16 ? fexpr__14379.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14379.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14362__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14380 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14380.cljs$core$IFn$_invoke$arity$17 ? fexpr__14380.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14380.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14362__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14381 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14381.cljs$core$IFn$_invoke$arity$18 ? fexpr__14381.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14381.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14362__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14382 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14382.cljs$core$IFn$_invoke$arity$19 ? fexpr__14382.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14382.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14362__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__14383 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14383.cljs$core$IFn$_invoke$arity$20 ? fexpr__14383.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14383.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14362__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14362 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14362__1.call(this,self__);
case 2:
return cljs$core$fn_14362__2.call(this,self__,a);
case 3:
return cljs$core$fn_14362__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14362__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14362__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14362__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14362__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14362__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14362__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14362__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14362__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14362__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14362__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14362__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14362__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14362__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14362__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14362__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14362__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14362__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14362__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14362__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14362__1;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14362__2;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14362__3;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14362__4;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14362__5;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14362__6;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14362__7;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14362__8;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14362__9;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14362__10;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14362__11;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14362__12;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14362__13;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14362__14;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14362__15;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14362__16;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14362__17;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14362__18;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14362__19;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14362__20;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14362__21;
cljs$core$fn_14362.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14362__22;
return cljs$core$fn_14362;
})()
);

(cljs.core.Var.prototype.apply = (function cljs$core$fn_14384(self__,args14354){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args14354);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__14385 = args__10096__auto__.slice((0),(20));
G__14385.push(args__10096__auto__.slice((20)));

return G__14385;
})():args__10096__auto__)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14386(){
var self__ = this;
var _ = this;
var fexpr__14387 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14387.cljs$core$IFn$_invoke$arity$0 ? fexpr__14387.cljs$core$IFn$_invoke$arity$0() : fexpr__14387.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14388(a){
var self__ = this;
var _ = this;
var fexpr__14389 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14389.cljs$core$IFn$_invoke$arity$1 ? fexpr__14389.cljs$core$IFn$_invoke$arity$1(a) : fexpr__14389.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14390(a,b){
var self__ = this;
var _ = this;
var fexpr__14391 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14391.cljs$core$IFn$_invoke$arity$2 ? fexpr__14391.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__14391.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14392(a,b,c){
var self__ = this;
var _ = this;
var fexpr__14393 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14393.cljs$core$IFn$_invoke$arity$3 ? fexpr__14393.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__14393.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14394(a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__14395 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14395.cljs$core$IFn$_invoke$arity$4 ? fexpr__14395.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__14395.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14396(a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__14397 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14397.cljs$core$IFn$_invoke$arity$5 ? fexpr__14397.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__14397.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14398(a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__14399 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14399.cljs$core$IFn$_invoke$arity$6 ? fexpr__14399.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__14399.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14400(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__14401 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14401.cljs$core$IFn$_invoke$arity$7 ? fexpr__14401.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__14401.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14402(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__14403 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14403.cljs$core$IFn$_invoke$arity$8 ? fexpr__14403.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__14403.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14404(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__14405 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14405.cljs$core$IFn$_invoke$arity$9 ? fexpr__14405.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__14405.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14406(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__14407 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14407.cljs$core$IFn$_invoke$arity$10 ? fexpr__14407.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__14407.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14408(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__14409 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14409.cljs$core$IFn$_invoke$arity$11 ? fexpr__14409.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__14409.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14410(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__14411 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14411.cljs$core$IFn$_invoke$arity$12 ? fexpr__14411.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__14411.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14412(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__14413 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14413.cljs$core$IFn$_invoke$arity$13 ? fexpr__14413.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__14413.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14414(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__14415 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14415.cljs$core$IFn$_invoke$arity$14 ? fexpr__14415.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__14415.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14416(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__14417 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14417.cljs$core$IFn$_invoke$arity$15 ? fexpr__14417.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__14417.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14418(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__14419 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14419.cljs$core$IFn$_invoke$arity$16 ? fexpr__14419.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__14419.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14420(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__14421 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14421.cljs$core$IFn$_invoke$arity$17 ? fexpr__14421.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__14421.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14422(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__14423 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14423.cljs$core$IFn$_invoke$arity$18 ? fexpr__14423.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__14423.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14424(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__14425 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14425.cljs$core$IFn$_invoke$arity$19 ? fexpr__14425.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__14425.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14426(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__14427 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__14427.cljs$core$IFn$_invoke$arity$20 ? fexpr__14427.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__14427.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14428(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function cljs$core$fn_14429(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function cljs$core$fn_14430(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(cljs.core.goog$module$goog$object.get.call(null,coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__14441 = arguments.length;
switch (G__14441) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14447 = arguments.length;
var i__10823__auto___14448 = (0);
while(true){
if((i__10823__auto___14448 < len__10822__auto___14447)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14448]));

var G__14449 = (i__10823__auto___14448 + (1));
i__10823__auto___14448 = G__14449;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14442(x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14443(x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14444(x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__14450 = y;
var G__14451 = cljs.core.first(more);
var G__14452 = cljs.core.next(more);
x = G__14450;
y = G__14451;
more = G__14452;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function cljs$core$fn_14445(seq14438){
var G__14439 = cljs.core.first(seq14438);
var seq14438__$1 = cljs.core.next(seq14438);
var G__14440 = cljs.core.first(seq14438__$1);
var seq14438__$2 = cljs.core.next(seq14438__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14439,G__14440,seq14438__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function cljs$core$fn_14453(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function cljs$core$fn_14454(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14455(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14456(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14457(_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14458(_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function cljs$core$fn_14459(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14460(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14461 = (n + (1));
var G__14462 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14463 = cljs.core.next(coll__$1);
n = G__14461;
hash_code = G__14462;
coll__$1 = G__14463;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__14464 = (n + (1));
var G__14465 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__14466 = cljs.core.next(coll__$1);
n = G__14464;
hash_code = G__14465;
coll__$1 = G__14466;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function cljs$core$fn_14467(_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14468(o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function cljs$core$fn_14469(this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__14470 = this$__$1.valueOf();
var G__14471 = other.valueOf();
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__14470,G__14471);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_14473 = (function cljs$core$fn_14472(inst){
var x__10242__auto__ = (((inst == null))?null:inst);
var m__10243__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__10242__auto__)]);
if((!((m__10243__auto__ == null)))){
return (m__10243__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10243__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10243__auto__.call(null,inst));
} else {
var m__10241__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__10241__auto__ == null)))){
return (m__10241__auto__.cljs$core$IFn$_invoke$arity$1 ? m__10241__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__10241__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_14473(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function cljs$core$fn_14474(inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function cljs$core$fn_14476(x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function cljs$core$fn_14477(_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function cljs$core$fn_14478(o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_14479(o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function cljs$core$fn_14480(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function cljs$core$fn_14481(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__14483 = arguments.length;
switch (G__14483) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14484(cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14485 = val;
var G__14486 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14485,G__14486) : f.call(null,G__14485,G__14486));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14491 = nval;
var G__14492 = (n + (1));
val = G__14491;
n = G__14492;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14487(cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14488 = val__$1;
var G__14489 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14488,G__14489) : f.call(null,G__14488,G__14489));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14493 = nval;
var G__14494 = (n + (1));
val__$1 = G__14493;
n = G__14494;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__14496 = arguments.length;
switch (G__14496) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14497(arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__14498 = val;
var G__14499 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14498,G__14499) : f.call(null,G__14498,G__14499));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14507 = nval;
var G__14508 = (n + (1));
val = G__14507;
n = G__14508;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14500(arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__14501 = val__$1;
var G__14502 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14501,G__14502) : f.call(null,G__14501,G__14502));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14509 = nval;
var G__14510 = (n + (1));
val__$1 = G__14509;
n = G__14510;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14503(arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__14504 = val__$1;
var G__14505 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14504,G__14505) : f.call(null,G__14504,G__14505));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14511 = nval;
var G__14512 = (n + (1));
val__$1 = G__14511;
n = G__14512;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__14516 = arguments.length;
switch (G__14516) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14517(coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14518(coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__9850__auto__ = (0);
var y__9851__auto__ = (start + len);
return ((x__9850__auto__ > y__9851__auto__) ? x__9850__auto__ : y__9851__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14520 = (idx + (1));
idx = G__14520;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__14522 = arguments.length;
switch (G__14522) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14523(coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14524(coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__9857__auto__ = (len - (1));
var y__9858__auto__ = start;
return ((x__9857__auto__ < y__9858__auto__) ? x__9857__auto__ : y__9858__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__14526 = (idx - (1));
idx = G__14526;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function cljs$core$fn_14527(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function cljs$core$fn_14528(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function cljs$core$fn_14529(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_14530(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.IndexedSeq.prototype.toString = (function cljs$core$fn_14531(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function cljs$core$fn_14532(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var cljs$core$fn_14533 = null;
var cljs$core$fn_14533__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14533__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14533 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14533__1.call(this,x);
case 2:
return cljs$core$fn_14533__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14533.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14533__1;
cljs$core$fn_14533.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14533__2;
return cljs$core$fn_14533;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14534 = null;
var cljs$core$fn_14534__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14534__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14534 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14534__1.call(this,x);
case 2:
return cljs$core$fn_14534__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14534.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14534__1;
cljs$core$fn_14534.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14534__2;
return cljs$core$fn_14534;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_14535(coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_14536(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_14537(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14538(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14539(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14540(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14541(_){
var self__ = this;
var ___$1 = this;
var x__9850__auto__ = (0);
var y__9851__auto__ = (self__.arr.length - self__.i);
return ((x__9850__auto__ > y__9851__auto__) ? x__9850__auto__ : y__9851__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_14542(coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14543(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14544(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14545(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14546(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14547(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14548(_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14549(_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14550(this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14551(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14552(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.getBasis = (function cljs$core$fn_14553(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14554(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14555(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__14557 = arguments.length;
switch (G__14557) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14558(prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14559(prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__14562 = arguments.length;
switch (G__14562) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14563(array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14564(array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function cljs$core$fn_14566(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function cljs$core$fn_14567(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var cljs$core$fn_14568 = null;
var cljs$core$fn_14568__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_14568__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14568 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14568__1.call(this,x);
case 2:
return cljs$core$fn_14568__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14568.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14568__1;
cljs$core$fn_14568.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14568__2;
return cljs$core$fn_14568;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_14569 = null;
var cljs$core$fn_14569__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_14569__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_14569 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_14569__1.call(this,x);
case 2:
return cljs$core$fn_14569__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14569.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14569__1;
cljs$core$fn_14569.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14569__2;
return cljs$core$fn_14569;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14570(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_14571(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_14572(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_14573(coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_14574(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_14575(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_14576(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_14577(col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_14578(col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_14579(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_14580(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_14581(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14582(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_14583(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function cljs$core$fn_14584(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_14585(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_14586(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__14587 = sn;
s = G__14587;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function cljs$core$fn_14588(x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__14593 = arguments.length;
switch (G__14593) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14600 = arguments.length;
var i__10823__auto___14601 = (0);
while(true){
if((i__10823__auto___14601 < len__10822__auto___14600)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14601]));

var G__14602 = (i__10823__auto___14601 + (1));
i__10823__auto___14601 = G__14602;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14594(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14595(coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14596(coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14597(coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__14603 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__14604 = cljs.core.first(xs);
var G__14605 = cljs.core.next(xs);
coll = G__14603;
x = G__14604;
xs = G__14605;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function cljs$core$fn_14598(seq14590){
var G__14591 = cljs.core.first(seq14590);
var seq14590__$1 = cljs.core.next(seq14590);
var G__14592 = cljs.core.first(seq14590__$1);
var seq14590__$2 = cljs.core.next(seq14590__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14591,G__14592,seq14590__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__14608 = cljs.core.next(s);
var G__14609 = (acc + (1));
s = G__14608;
acc = G__14609;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__14613 = arguments.length;
switch (G__14613) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14614(coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__14617 = cljs.core.next(coll);
var G__14618 = (n - (1));
coll = G__14617;
n = G__14618;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14615(coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__14619 = cljs.core.next(coll);
var G__14620 = (n - (1));
var G__14621 = not_found;
coll = G__14619;
n = G__14620;
not_found = G__14621;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__14623 = arguments.length;
switch (G__14623) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14624(coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__9493__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9493__auto__){
return or__9493__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14628(coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__9493__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__9493__auto__){
return or__9493__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__14633 = (n__$1 - (1));
var G__14634 = cljs.core.rest(xs__$1);
n__$1 = G__14633;
xs = G__14634;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__14636 = arguments.length;
switch (G__14636) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14637(o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14639(o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__14647 = arguments.length;
switch (G__14647) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14653 = arguments.length;
var i__10823__auto___14654 = (0);
while(true){
if((i__10823__auto___14654 < len__10822__auto___14653)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14654]));

var G__14655 = (i__10823__auto___14654 + (1));
i__10823__auto___14654 = G__14655;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14648(coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14650(coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__14656 = ret;
var G__14657 = cljs.core.first(kvs);
var G__14658 = cljs.core.second(kvs);
var G__14659 = cljs.core.nnext(kvs);
coll = G__14656;
k = G__14657;
v = G__14658;
kvs = G__14659;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function cljs$core$fn_14651(seq14643){
var G__14644 = cljs.core.first(seq14643);
var seq14643__$1 = cljs.core.next(seq14643);
var G__14645 = cljs.core.first(seq14643__$1);
var seq14643__$2 = cljs.core.next(seq14643__$1);
var G__14646 = cljs.core.first(seq14643__$2);
var seq14643__$3 = cljs.core.next(seq14643__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14644,G__14645,G__14646,seq14643__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__14664 = arguments.length;
switch (G__14664) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14670 = arguments.length;
var i__10823__auto___14671 = (0);
while(true){
if((i__10823__auto___14671 < len__10822__auto___14670)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14671]));

var G__14672 = (i__10823__auto___14671 + (1));
i__10823__auto___14671 = G__14672;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14665(coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14666(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14667(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14673 = ret;
var G__14674 = cljs.core.first(ks);
var G__14675 = cljs.core.next(ks);
coll = G__14673;
k = G__14674;
ks = G__14675;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function cljs$core$fn_14668(seq14661){
var G__14662 = cljs.core.first(seq14661);
var seq14661__$1 = cljs.core.next(seq14661);
var G__14663 = cljs.core.first(seq14661__$1);
var seq14661__$2 = cljs.core.next(seq14661__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14662,G__14663,seq14661__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__9493__auto__ = typeof f === 'function';
if(or__9493__auto__){
return or__9493__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_14678(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_14679(_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var cljs$core$fn_14680 = null;
var cljs$core$fn_14680__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var cljs$core$fn_14680__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var cljs$core$fn_14680__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var cljs$core$fn_14680__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var cljs$core$fn_14680__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var cljs$core$fn_14680__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var cljs$core$fn_14680__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var cljs$core$fn_14680__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var cljs$core$fn_14680__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var cljs$core$fn_14680__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var cljs$core$fn_14680__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var cljs$core$fn_14680__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var cljs$core$fn_14680__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var cljs$core$fn_14680__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var cljs$core$fn_14680__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var cljs$core$fn_14680__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var cljs$core$fn_14680__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var cljs$core$fn_14680__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var cljs$core$fn_14680__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var cljs$core$fn_14680__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var cljs$core$fn_14680__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var cljs$core$fn_14680__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
cljs$core$fn_14680 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$fn_14680__1.call(this,self__);
case 2:
return cljs$core$fn_14680__2.call(this,self__,a);
case 3:
return cljs$core$fn_14680__3.call(this,self__,a,b);
case 4:
return cljs$core$fn_14680__4.call(this,self__,a,b,c);
case 5:
return cljs$core$fn_14680__5.call(this,self__,a,b,c,d);
case 6:
return cljs$core$fn_14680__6.call(this,self__,a,b,c,d,e);
case 7:
return cljs$core$fn_14680__7.call(this,self__,a,b,c,d,e,f);
case 8:
return cljs$core$fn_14680__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return cljs$core$fn_14680__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$fn_14680__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$fn_14680__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$fn_14680__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$fn_14680__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$fn_14680__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$fn_14680__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$fn_14680__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$fn_14680__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$fn_14680__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$fn_14680__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$fn_14680__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$fn_14680__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$fn_14680__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14680__1;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14680__2;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_14680__3;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$4 = cljs$core$fn_14680__4;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$5 = cljs$core$fn_14680__5;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$6 = cljs$core$fn_14680__6;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$7 = cljs$core$fn_14680__7;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$8 = cljs$core$fn_14680__8;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$9 = cljs$core$fn_14680__9;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$10 = cljs$core$fn_14680__10;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$11 = cljs$core$fn_14680__11;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$12 = cljs$core$fn_14680__12;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$13 = cljs$core$fn_14680__13;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$14 = cljs$core$fn_14680__14;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$15 = cljs$core$fn_14680__15;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$16 = cljs$core$fn_14680__16;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$17 = cljs$core$fn_14680__17;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$18 = cljs$core$fn_14680__18;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$19 = cljs$core$fn_14680__19;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$20 = cljs$core$fn_14680__20;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$21 = cljs$core$fn_14680__21;
cljs$core$fn_14680.cljs$core$IFn$_invoke$arity$22 = cljs$core$fn_14680__22;
return cljs$core$fn_14680;
})()
);

(cljs.core.MetaFn.prototype.apply = (function cljs$core$fn_14681(self__,args14677){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args14677);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__14682 = args__10096__auto__.slice((0),(20));
G__14682.push(args__10096__auto__.slice((20)));

return G__14682;
})():args__10096__auto__)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14683(){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14684(a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14685(a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14686(a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14687(a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_14688(a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_14689(a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_14690(a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function cljs$core$fn_14691(a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function cljs$core$fn_14692(a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function cljs$core$fn_14693(a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function cljs$core$fn_14694(a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function cljs$core$fn_14695(a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function cljs$core$fn_14696(a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function cljs$core$fn_14697(a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function cljs$core$fn_14698(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function cljs$core$fn_14699(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function cljs$core$fn_14700(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function cljs$core$fn_14701(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function cljs$core$fn_14702(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function cljs$core$fn_14703(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function cljs$core$fn_14704(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function cljs$core$fn_14705(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function cljs$core$fn_14706(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__9487__auto__ = (!((o == null)));
if(and__9487__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__9487__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__14712 = arguments.length;
switch (G__14712) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14718 = arguments.length;
var i__10823__auto___14719 = (0);
while(true){
if((i__10823__auto___14719 < len__10822__auto___14718)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14719]));

var G__14720 = (i__10823__auto___14719 + (1));
i__10823__auto___14719 = G__14720;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14713(coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14714(coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14715(coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__14721 = ret;
var G__14722 = cljs.core.first(ks);
var G__14723 = cljs.core.next(ks);
coll = G__14721;
k = G__14722;
ks = G__14723;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function cljs$core$fn_14716(seq14709){
var G__14710 = cljs.core.first(seq14709);
var seq14709__$1 = cljs.core.next(seq14709);
var G__14711 = cljs.core.first(seq14709__$1);
var seq14709__$2 = cljs.core.next(seq14709__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14710,G__14711,seq14709__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return (((coll == null)) || (cljs.core.not(cljs.core.seq(coll))));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__14737 = arguments.length;
switch (G__14737) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14744 = arguments.length;
var i__10823__auto___14745 = (0);
while(true){
if((i__10823__auto___14745 < len__10822__auto___14744)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14745]));

var G__14746 = (i__10823__auto___14745 + (1));
i__10823__auto___14745 = G__14746;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10852__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14738(){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14741(keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function cljs$core$fn_14742(seq14736){
var self__10808__auto__ = this;
return self__10808__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14736));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys.call(null,obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14747 = (i__$1 + (1));
var G__14748 = (j__$1 + (1));
var G__14749 = (len__$1 - (1));
i__$1 = G__14747;
j__$1 = G__14748;
len__$1 = G__14749;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__14750 = (i__$1 - (1));
var G__14751 = (j__$1 - (1));
var G__14752 = (len__$1 - (1));
i__$1 = G__14750;
j__$1 = G__14751;
len__$1 = G__14752;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__9493__auto__ = (s == null);
if(or__9493__auto__){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__9493__auto____$1){
return or__9493__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__9493__auto__ = cljs.core.fn_QMARK_(f);
if(or__9493__auto__){
return or__9493__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null,v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__14763 = arguments.length;
switch (G__14763) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14769 = arguments.length;
var i__10823__auto___14770 = (0);
while(true){
if((i__10823__auto___14770 < len__10822__auto___14769)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14770]));

var G__14771 = (i__10823__auto___14770 + (1));
i__10823__auto___14770 = G__14771;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14764(x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14765(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14766(x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__14772 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__14773 = etc;
s = G__14772;
xs = G__14773;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function cljs$core$fn_14767(seq14760){
var G__14761 = cljs.core.first(seq14760);
var seq14760__$1 = cljs.core.next(seq14760);
var G__14762 = cljs.core.first(seq14760__$1);
var seq14760__$2 = cljs.core.next(seq14760__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14761,G__14762,seq14760__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare.call(null,x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__14776 = arguments.length;
switch (G__14776) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14777(xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14778(xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__14780 = xs;
var G__14781 = ys;
var G__14782 = len;
var G__14783 = (n + (1));
xs = G__14780;
ys = G__14781;
len = G__14782;
n = G__14783;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function cljs$core$fn__GT_comparator_$_fn_14784(x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__14786 = arguments.length;
switch (G__14786) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14787(coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14788(comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__14789_14792 = a;
var G__14790_14793 = cljs.core.fn__GT_comparator(comp);
cljs.core.goog$module$goog$array.stableSort.call(null,G__14789_14792,G__14790_14793);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__14795 = arguments.length;
switch (G__14795) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14796(keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14797(keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_14797_$_fn_14798(x,y){
var G__14800 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__14801 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__14799 = cljs.core.fn__GT_comparator(comp);
return (fexpr__14799.cljs$core$IFn$_invoke$arity$2 ? fexpr__14799.cljs$core$IFn$_invoke$arity$2(G__14800,G__14801) : fexpr__14799.call(null,G__14800,G__14801));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__14804 = arguments.length;
switch (G__14804) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14805(f,coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14806(f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__14807 = val__$1;
var G__14808 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14807,G__14808) : f.call(null,G__14807,G__14808));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__14810 = nval;
var G__14811 = cljs.core.next(coll__$1);
val__$1 = G__14810;
coll__$1 = G__14811;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
cljs.core.goog$module$goog$array.shuffle.call(null,a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__14813 = arguments.length;
switch (G__14813) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14814(coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14815 = acc;
var G__14816 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14815,G__14816) : f.call(null,G__14815,G__14816));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14821 = nacc;
acc = G__14821;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14817(coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__14818 = acc;
var G__14819 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__14818,G__14819) : f.call(null,G__14818,G__14819));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__14822 = nacc;
acc = G__14822;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__14824 = arguments.length;
switch (G__14824) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14825(f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14827(f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((!((coll == null)))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__14831 = arguments.length;
switch (G__14831) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14832(f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14833(f,cf){
return (function() {
var cljs$core$fn_14833_$_fn_14834 = null;
var cljs$core$fn_14833_$_fn_14834__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var cljs$core$fn_14833_$_fn_14834__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var cljs$core$fn_14833_$_fn_14834__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
cljs$core$fn_14833_$_fn_14834 = function(x,y){
switch(arguments.length){
case 0:
return cljs$core$fn_14833_$_fn_14834__0.call(this);
case 1:
return cljs$core$fn_14833_$_fn_14834__1.call(this,x);
case 2:
return cljs$core$fn_14833_$_fn_14834__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_14833_$_fn_14834.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_14833_$_fn_14834__0;
cljs$core$fn_14833_$_fn_14834.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_14833_$_fn_14834__1;
cljs$core$fn_14833_$_fn_14834.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_14833_$_fn_14834__2;
return cljs$core$fn_14833_$_fn_14834;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__14837 = arguments.length;
switch (G__14837) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_14838(xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_14839(xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__14845 = arguments.length;
switch (G__14845) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14852 = arguments.length;
var i__10823__auto___14853 = (0);
while(true){
if((i__10823__auto___14853 < len__10822__auto___14852)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14853]));

var G__14854 = (i__10823__auto___14853 + (1));
i__10823__auto___14853 = G__14854;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14846(){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14847(x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14848(x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14849(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function cljs$core$fn_14850(seq14842){
var G__14843 = cljs.core.first(seq14842);
var seq14842__$1 = cljs.core.next(seq14842);
var G__14844 = cljs.core.first(seq14842__$1);
var seq14842__$2 = cljs.core.next(seq14842__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14843,G__14844,seq14842__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__14859 = arguments.length;
switch (G__14859) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14865 = arguments.length;
var i__10823__auto___14866 = (0);
while(true){
if((i__10823__auto___14866 < len__10822__auto___14865)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14866]));

var G__14867 = (i__10823__auto___14866 + (1));
i__10823__auto___14866 = G__14867;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14860(x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14861(x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14862(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function cljs$core$fn_14863(seq14856){
var G__14857 = cljs.core.first(seq14856);
var seq14856__$1 = cljs.core.next(seq14856);
var G__14858 = cljs.core.first(seq14856__$1);
var seq14856__$2 = cljs.core.next(seq14856__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14857,G__14858,seq14856__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__14872 = arguments.length;
switch (G__14872) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14879 = arguments.length;
var i__10823__auto___14880 = (0);
while(true){
if((i__10823__auto___14880 < len__10822__auto___14879)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14880]));

var G__14881 = (i__10823__auto___14880 + (1));
i__10823__auto___14880 = G__14881;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14873(){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14874(x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14875(x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14876(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function cljs$core$fn_14877(seq14869){
var G__14870 = cljs.core.first(seq14869);
var seq14869__$1 = cljs.core.next(seq14869);
var G__14871 = cljs.core.first(seq14869__$1);
var seq14869__$2 = cljs.core.next(seq14869__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14870,G__14871,seq14869__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__14886 = arguments.length;
switch (G__14886) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14892 = arguments.length;
var i__10823__auto___14893 = (0);
while(true){
if((i__10823__auto___14893 < len__10822__auto___14892)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14893]));

var G__14894 = (i__10823__auto___14893 + (1));
i__10823__auto___14893 = G__14894;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14887(x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14888(x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14889(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function cljs$core$fn_14890(seq14883){
var G__14884 = cljs.core.first(seq14883);
var seq14883__$1 = cljs.core.next(seq14883);
var G__14885 = cljs.core.first(seq14883__$1);
var seq14883__$2 = cljs.core.next(seq14883__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14884,G__14885,seq14883__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__14899 = arguments.length;
switch (G__14899) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14905 = arguments.length;
var i__10823__auto___14906 = (0);
while(true){
if((i__10823__auto___14906 < len__10822__auto___14905)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14906]));

var G__14907 = (i__10823__auto___14906 + (1));
i__10823__auto___14906 = G__14907;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14900(x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14901(x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14902(x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__14908 = y;
var G__14909 = cljs.core.first(more);
var G__14910 = cljs.core.next(more);
x = G__14908;
y = G__14909;
more = G__14910;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function cljs$core$fn_14903(seq14896){
var G__14897 = cljs.core.first(seq14896);
var seq14896__$1 = cljs.core.next(seq14896);
var G__14898 = cljs.core.first(seq14896__$1);
var seq14896__$2 = cljs.core.next(seq14896__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14897,G__14898,seq14896__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__14915 = arguments.length;
switch (G__14915) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14921 = arguments.length;
var i__10823__auto___14922 = (0);
while(true){
if((i__10823__auto___14922 < len__10822__auto___14921)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14922]));

var G__14923 = (i__10823__auto___14922 + (1));
i__10823__auto___14922 = G__14923;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14916(x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14917(x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14918(x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__14924 = y;
var G__14925 = cljs.core.first(more);
var G__14926 = cljs.core.next(more);
x = G__14924;
y = G__14925;
more = G__14926;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_14919(seq14912){
var G__14913 = cljs.core.first(seq14912);
var seq14912__$1 = cljs.core.next(seq14912);
var G__14914 = cljs.core.first(seq14912__$1);
var seq14912__$2 = cljs.core.next(seq14912__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14913,G__14914,seq14912__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__14931 = arguments.length;
switch (G__14931) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14937 = arguments.length;
var i__10823__auto___14938 = (0);
while(true){
if((i__10823__auto___14938 < len__10822__auto___14937)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14938]));

var G__14939 = (i__10823__auto___14938 + (1));
i__10823__auto___14938 = G__14939;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14932(x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14933(x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14934(x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__14940 = y;
var G__14941 = cljs.core.first(more);
var G__14942 = cljs.core.next(more);
x = G__14940;
y = G__14941;
more = G__14942;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function cljs$core$fn_14935(seq14928){
var G__14929 = cljs.core.first(seq14928);
var seq14928__$1 = cljs.core.next(seq14928);
var G__14930 = cljs.core.first(seq14928__$1);
var seq14928__$2 = cljs.core.next(seq14928__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14929,G__14930,seq14928__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__14947 = arguments.length;
switch (G__14947) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14953 = arguments.length;
var i__10823__auto___14954 = (0);
while(true){
if((i__10823__auto___14954 < len__10822__auto___14953)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14954]));

var G__14955 = (i__10823__auto___14954 + (1));
i__10823__auto___14954 = G__14955;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14948(x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14949(x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14950(x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__14956 = y;
var G__14957 = cljs.core.first(more);
var G__14958 = cljs.core.next(more);
x = G__14956;
y = G__14957;
more = G__14958;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function cljs$core$fn_14951(seq14944){
var G__14945 = cljs.core.first(seq14944);
var seq14944__$1 = cljs.core.next(seq14944);
var G__14946 = cljs.core.first(seq14944__$1);
var seq14944__$2 = cljs.core.next(seq14944__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14945,G__14946,seq14944__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__14963 = arguments.length;
switch (G__14963) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14969 = arguments.length;
var i__10823__auto___14970 = (0);
while(true){
if((i__10823__auto___14970 < len__10822__auto___14969)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14970]));

var G__14971 = (i__10823__auto___14970 + (1));
i__10823__auto___14970 = G__14971;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14964(x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14965(x,y){
var x__9850__auto__ = x;
var y__9851__auto__ = y;
return ((x__9850__auto__ > y__9851__auto__) ? x__9850__auto__ : y__9851__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14966(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__9850__auto__ = x;
var y__9851__auto__ = y;
return ((x__9850__auto__ > y__9851__auto__) ? x__9850__auto__ : y__9851__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function cljs$core$fn_14967(seq14960){
var G__14961 = cljs.core.first(seq14960);
var seq14960__$1 = cljs.core.next(seq14960);
var G__14962 = cljs.core.first(seq14960__$1);
var seq14960__$2 = cljs.core.next(seq14960__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14961,G__14962,seq14960__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__14976 = arguments.length;
switch (G__14976) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14982 = arguments.length;
var i__10823__auto___14983 = (0);
while(true){
if((i__10823__auto___14983 < len__10822__auto___14982)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14983]));

var G__14984 = (i__10823__auto___14983 + (1));
i__10823__auto___14983 = G__14984;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14977(x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14978(x,y){
var x__9857__auto__ = x;
var y__9858__auto__ = y;
return ((x__9857__auto__ < y__9858__auto__) ? x__9857__auto__ : y__9858__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14979(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__9857__auto__ = x;
var y__9858__auto__ = y;
return ((x__9857__auto__ < y__9858__auto__) ? x__9857__auto__ : y__9858__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function cljs$core$fn_14980(seq14973){
var G__14974 = cljs.core.first(seq14973);
var seq14973__$1 = cljs.core.next(seq14973);
var G__14975 = cljs.core.first(seq14973__$1);
var seq14973__$2 = cljs.core.next(seq14973__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14974,G__14975,seq14973__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__14989 = arguments.length;
switch (G__14989) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___14996 = arguments.length;
var i__10823__auto___14997 = (0);
while(true){
if((i__10823__auto___14997 < len__10822__auto___14996)){
args_arr__10851__auto__.push((arguments[i__10823__auto___14997]));

var G__14998 = (i__10823__auto___14997 + (1));
i__10823__auto___14997 = G__14998;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_14990(){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_14991(x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_14992(x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_14993(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function cljs$core$fn_14994(seq14986){
var G__14987 = cljs.core.first(seq14986);
var seq14986__$1 = cljs.core.next(seq14986);
var G__14988 = cljs.core.first(seq14986__$1);
var seq14986__$2 = cljs.core.next(seq14986__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14987,G__14988,seq14986__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__15003 = arguments.length;
switch (G__15003) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15010 = arguments.length;
var i__10823__auto___15011 = (0);
while(true){
if((i__10823__auto___15011 < len__10822__auto___15010)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15011]));

var G__15012 = (i__10823__auto___15011 + (1));
i__10823__auto___15011 = G__15012;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15004(){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15005(x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15006(x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15007(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function cljs$core$fn_15008(seq15000){
var G__15001 = cljs.core.first(seq15000);
var seq15000__$1 = cljs.core.next(seq15000);
var G__15002 = cljs.core.first(seq15000__$1);
var seq15000__$2 = cljs.core.next(seq15000__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15001,G__15002,seq15000__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__15017 = arguments.length;
switch (G__15017) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15023 = arguments.length;
var i__10823__auto___15024 = (0);
while(true){
if((i__10823__auto___15024 < len__10822__auto___15023)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15024]));

var G__15025 = (i__10823__auto___15024 + (1));
i__10823__auto___15024 = G__15025;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15018(x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15019(x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15020(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function cljs$core$fn_15021(seq15014){
var G__15015 = cljs.core.first(seq15014);
var seq15014__$1 = cljs.core.next(seq15014);
var G__15016 = cljs.core.first(seq15014__$1);
var seq15014__$2 = cljs.core.next(seq15014__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15015,G__15016,seq15014__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__15030 = arguments.length;
switch (G__15030) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15037 = arguments.length;
var i__10823__auto___15038 = (0);
while(true){
if((i__10823__auto___15038 < len__10822__auto___15037)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15038]));

var G__15039 = (i__10823__auto___15038 + (1));
i__10823__auto___15038 = G__15039;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15031(){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15032(x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15033(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15034(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function cljs$core$fn_15035(seq15027){
var G__15028 = cljs.core.first(seq15027);
var seq15027__$1 = cljs.core.next(seq15027);
var G__15029 = cljs.core.first(seq15027__$1);
var seq15027__$2 = cljs.core.next(seq15027__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15028,G__15029,seq15027__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__15044 = arguments.length;
switch (G__15044) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15051 = arguments.length;
var i__10823__auto___15052 = (0);
while(true){
if((i__10823__auto___15052 < len__10822__auto___15051)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15052]));

var G__15053 = (i__10823__auto___15052 + (1));
i__10823__auto___15052 = G__15053;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15045(){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15046(x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15047(x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15048(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function cljs$core$fn_15049(seq15041){
var G__15042 = cljs.core.first(seq15041);
var seq15041__$1 = cljs.core.next(seq15041);
var G__15043 = cljs.core.first(seq15041__$1);
var seq15041__$2 = cljs.core.next(seq15041__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15042,G__15043,seq15041__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__15058 = arguments.length;
switch (G__15058) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15064 = arguments.length;
var i__10823__auto___15065 = (0);
while(true){
if((i__10823__auto___15065 < len__10822__auto___15064)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15065]));

var G__15066 = (i__10823__auto___15065 + (1));
i__10823__auto___15065 = G__15066;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15059(x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15060(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15061(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function cljs$core$fn_15062(seq15055){
var G__15056 = cljs.core.first(seq15055);
var seq15055__$1 = cljs.core.next(seq15055);
var G__15057 = cljs.core.first(seq15055__$1);
var seq15055__$2 = cljs.core.next(seq15055__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15056,G__15057,seq15055__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__15071 = arguments.length;
switch (G__15071) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15077 = arguments.length;
var i__10823__auto___15078 = (0);
while(true){
if((i__10823__auto___15078 < len__10822__auto___15077)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15078]));

var G__15079 = (i__10823__auto___15078 + (1));
i__10823__auto___15078 = G__15079;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15072(x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15073(x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15074(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function cljs$core$fn_15075(seq15068){
var G__15069 = cljs.core.first(seq15068);
var seq15068__$1 = cljs.core.next(seq15068);
var G__15070 = cljs.core.first(seq15068__$1);
var seq15068__$2 = cljs.core.next(seq15068__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15069,G__15070,seq15068__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__15084 = arguments.length;
switch (G__15084) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15089 = arguments.length;
var i__10823__auto___15090 = (0);
while(true){
if((i__10823__auto___15090 < len__10822__auto___15089)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15090]));

var G__15091 = (i__10823__auto___15090 + (1));
i__10823__auto___15090 = G__15091;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15085(x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15086(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function cljs$core$fn_15087(seq15081){
var G__15082 = cljs.core.first(seq15081);
var seq15081__$1 = cljs.core.next(seq15081);
var G__15083 = cljs.core.first(seq15081__$1);
var seq15081__$2 = cljs.core.next(seq15081__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15082,G__15083,seq15081__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__15096 = arguments.length;
switch (G__15096) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15101 = arguments.length;
var i__10823__auto___15102 = (0);
while(true){
if((i__10823__auto___15102 < len__10822__auto___15101)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15102]));

var G__15103 = (i__10823__auto___15102 + (1));
i__10823__auto___15102 = G__15103;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15097(x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15098(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function cljs$core$fn_15099(seq15093){
var G__15094 = cljs.core.first(seq15093);
var seq15093__$1 = cljs.core.next(seq15093);
var G__15095 = cljs.core.first(seq15093__$1);
var seq15093__$2 = cljs.core.next(seq15093__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15094,G__15095,seq15093__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__15108 = arguments.length;
switch (G__15108) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15113 = arguments.length;
var i__10823__auto___15114 = (0);
while(true){
if((i__10823__auto___15114 < len__10822__auto___15113)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15114]));

var G__15115 = (i__10823__auto___15114 + (1));
i__10823__auto___15114 = G__15115;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15109(x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15110(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function cljs$core$fn_15111(seq15105){
var G__15106 = cljs.core.first(seq15105);
var seq15105__$1 = cljs.core.next(seq15105);
var G__15107 = cljs.core.first(seq15105__$1);
var seq15105__$2 = cljs.core.next(seq15105__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15106,G__15107,seq15105__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__15120 = arguments.length;
switch (G__15120) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15125 = arguments.length;
var i__10823__auto___15126 = (0);
while(true){
if((i__10823__auto___15126 < len__10822__auto___15125)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15126]));

var G__15127 = (i__10823__auto___15126 + (1));
i__10823__auto___15126 = G__15127;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15121(x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15122(x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function cljs$core$fn_15123(seq15117){
var G__15118 = cljs.core.first(seq15117);
var seq15117__$1 = cljs.core.next(seq15117);
var G__15119 = cljs.core.first(seq15117__$1);
var seq15117__$2 = cljs.core.next(seq15117__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15118,G__15119,seq15117__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__15132 = arguments.length;
switch (G__15132) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15138 = arguments.length;
var i__10823__auto___15139 = (0);
while(true){
if((i__10823__auto___15139 < len__10822__auto___15138)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15139]));

var G__15140 = (i__10823__auto___15139 + (1));
i__10823__auto___15139 = G__15140;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15133(x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15134(x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15135(x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__15141 = y;
var G__15142 = cljs.core.first(more);
var G__15143 = cljs.core.next(more);
x = G__15141;
y = G__15142;
more = G__15143;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function cljs$core$fn_15136(seq15129){
var G__15130 = cljs.core.first(seq15129);
var seq15129__$1 = cljs.core.next(seq15129);
var G__15131 = cljs.core.first(seq15129__$1);
var seq15129__$2 = cljs.core.next(seq15129__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15130,G__15131,seq15129__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__15144 = (n__$1 - (1));
var G__15145 = cljs.core.next(xs);
n__$1 = G__15144;
xs = G__15145;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__15149 = arguments.length;
switch (G__15149) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15155 = arguments.length;
var i__10823__auto___15156 = (0);
while(true){
if((i__10823__auto___15156 < len__10822__auto___15155)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15156]));

var G__15157 = (i__10823__auto___15156 + (1));
i__10823__auto___15156 = G__15157;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10852__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15150(){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15151(x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15152(x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__15158 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__15159 = cljs.core.next(more);
sb = G__15158;
more = G__15159;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function cljs$core$fn_15153(seq15147){
var G__15148 = cljs.core.first(seq15147);
var seq15147__$1 = cljs.core.next(seq15147);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15148,seq15147__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__15161 = arguments.length;
switch (G__15161) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15162(s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15163(s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__15165 = cljs.core.next(xs);
var G__15166 = cljs.core.next(ys);
xs = G__15165;
ys = G__15166;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__15167 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__15168 = cljs.core.next(s);
res = G__15167;
s = G__15168;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__15169 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__15170 = cljs.core.next(s);
h = G__15169;
s = G__15170;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__15171 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__15172 = cljs.core.next(s__$1);
h = G__15171;
s__$1 = G__15172;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__15173_15189 = cljs.core.seq(fn_map);
var chunk__15174_15190 = null;
var count__15175_15191 = (0);
var i__15176_15192 = (0);
while(true){
if((i__15176_15192 < count__15175_15191)){
var vec__15183_15193 = chunk__15174_15190.cljs$core$IIndexed$_nth$arity$2(null,i__15176_15192);
var key_name_15194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15183_15193,(0),null);
var f_15195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15183_15193,(1),null);
var str_name_15196 = cljs.core.name(key_name_15194);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15196,f_15195);


var G__15197 = seq__15173_15189;
var G__15198 = chunk__15174_15190;
var G__15199 = count__15175_15191;
var G__15200 = (i__15176_15192 + (1));
seq__15173_15189 = G__15197;
chunk__15174_15190 = G__15198;
count__15175_15191 = G__15199;
i__15176_15192 = G__15200;
continue;
} else {
var temp__5720__auto___15201 = cljs.core.seq(seq__15173_15189);
if(temp__5720__auto___15201){
var seq__15173_15202__$1 = temp__5720__auto___15201;
if(cljs.core.chunked_seq_QMARK_(seq__15173_15202__$1)){
var c__10465__auto___15203 = cljs.core.chunk_first(seq__15173_15202__$1);
var G__15204 = cljs.core.chunk_rest(seq__15173_15202__$1);
var G__15205 = c__10465__auto___15203;
var G__15206 = cljs.core.count(c__10465__auto___15203);
var G__15207 = (0);
seq__15173_15189 = G__15204;
chunk__15174_15190 = G__15205;
count__15175_15191 = G__15206;
i__15176_15192 = G__15207;
continue;
} else {
var vec__15186_15208 = cljs.core.first(seq__15173_15202__$1);
var key_name_15209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15186_15208,(0),null);
var f_15210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15186_15208,(1),null);
var str_name_15211 = cljs.core.name(key_name_15209);
cljs.core.goog$module$goog$object.set.call(null,obj,str_name_15211,f_15210);


var G__15212 = cljs.core.next(seq__15173_15202__$1);
var G__15213 = null;
var G__15214 = (0);
var G__15215 = (0);
seq__15173_15189 = G__15212;
chunk__15174_15190 = G__15213;
count__15175_15191 = G__15214;
i__15176_15192 = G__15215;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function cljs$core$fn_15216(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function cljs$core$fn_15217(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var cljs$core$fn_15218 = null;
var cljs$core$fn_15218__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15218__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15218 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15218__1.call(this,x);
case 2:
return cljs$core$fn_15218__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15218.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15218__1;
cljs$core$fn_15218.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15218__2;
return cljs$core$fn_15218;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var cljs$core$fn_15219 = null;
var cljs$core$fn_15219__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_15219__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15219 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15219__1.call(this,x);
case 2:
return cljs$core$fn_15219__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15219.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15219__1;
cljs$core$fn_15219.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15219__2;
return cljs$core$fn_15219;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15220(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15221(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15222(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15223(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15224(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15225(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15226(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15227(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15228(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15229(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15230(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15231(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15232(coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15233(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15234(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15235(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function cljs$core$fn_15236(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function cljs$core$fn_15237(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15239(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function cljs$core$fn_15240(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function cljs$core$fn_15241(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var cljs$core$fn_15242 = null;
var cljs$core$fn_15242__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15242__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15242 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15242__1.call(this,x);
case 2:
return cljs$core$fn_15242__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15242.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15242__1;
cljs$core$fn_15242.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15242__2;
return cljs$core$fn_15242;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var cljs$core$fn_15243 = null;
var cljs$core$fn_15243__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15243__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15243 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15243__1.call(this,x);
case 2:
return cljs$core$fn_15243__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15243.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15243__1;
cljs$core$fn_15243.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15243__2;
return cljs$core$fn_15243;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15244(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15245(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15246(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15247(coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_15248(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_15249(coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15250(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15251(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15252(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15253(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15254(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15255(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15256(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15257(coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15258(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15259(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function cljs$core$fn_15260(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function cljs$core$fn_15261(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15262(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__9493__auto__ = cljs.core.rseq(coll);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__10832__auto__ = [];
var len__10822__auto___15267 = arguments.length;
var i__10823__auto___15268 = (0);
while(true){
if((i__10823__auto___15268 < len__10822__auto___15267)){
args__10832__auto__.push((arguments[i__10823__auto___15268]));

var G__15269 = (i__10823__auto___15268 + (1));
i__10823__auto___15268 = G__15269;
continue;
} else {
}
break;
}

var argseq__10833__auto__ = ((((0) < args__10832__auto__.length))?(new cljs.core.IndexedSeq(args__10832__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10833__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15265(xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__15270 = cljs.core._next(xs__$1);
xs__$1 = G__15270;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__15271 = (i - (1));
var G__15272 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__15271;
r = G__15272;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function cljs$core$fn_15266(seq15264){
var self__10808__auto__ = this;
return self__10808__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15264));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function cljs$core$fn_15273(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function cljs$core$fn_15274(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var cljs$core$fn_15275 = null;
var cljs$core$fn_15275__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15275__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15275 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15275__1.call(this,x);
case 2:
return cljs$core$fn_15275__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15275.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15275__1;
cljs$core$fn_15275.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15275__2;
return cljs$core$fn_15275;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15276 = null;
var cljs$core$fn_15276__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15276__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15276 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15276__1.call(this,x);
case 2:
return cljs$core$fn_15276__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15276.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15276__1;
cljs$core$fn_15276.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15276__2;
return cljs$core$fn_15276;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15277(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_15278(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15279(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15280(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15281(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15282(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15283(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15284(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15285(coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15286(coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15287(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15288(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15289(coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function cljs$core$fn_15290(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15291(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15292(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__9487__auto__ = cljs.core.not(a.ns);
if(and__9487__auto__){
return b.ns;
} else {
return and__9487__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15294 = a.ns;
var G__15295 = b.ns;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15294,G__15295);
})();
if(((0) === nsc)){
var G__15296 = a.name;
var G__15297 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15296,G__15297);
} else {
return nsc;
}
}
} else {
var G__15298 = a.name;
var G__15299 = b.name;
return cljs.core.goog$module$goog$array.defaultCompare.call(null,G__15298,G__15299);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function cljs$core$fn_15301(){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function cljs$core$fn_15302(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15303(_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var cljs$core$fn_15304 = null;
var cljs$core$fn_15304__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var cljs$core$fn_15304__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
cljs$core$fn_15304 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_15304__2.call(this,self__,coll);
case 3:
return cljs$core$fn_15304__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_15304.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15304__2;
cljs$core$fn_15304.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15304__3;
return cljs$core$fn_15304;
})()
);

(cljs.core.Keyword.prototype.apply = (function cljs$core$fn_15305(self__,args15300){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args15300);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__15306 = args__10096__auto__.slice((0),(20));
G__15306.push(args__10096__auto__.slice((20)));

return G__15306;
})():args__10096__auto__)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15307(coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15308(coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15309(this$){
var self__ = this;
var this$__$1 = this;
var h__9954__auto__ = self__._hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function cljs$core$fn_15310(_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function cljs$core$fn_15311(_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function cljs$core$fn_15312(o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function cljs$core$fn_15313(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function cljs$core$fn_15314(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__9487__auto__ = cljs.core.ident_QMARK_(x);
if(and__9487__auto__){
var and__9487__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9487__auto____$1)){
return true;
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__9487__auto__ = (x instanceof cljs.core.Symbol);
if(and__9487__auto__){
var and__9487__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9487__auto____$1)){
return true;
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__9487__auto__ = (x instanceof cljs.core.Keyword);
if(and__9487__auto__){
var and__9487__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__9487__auto____$1)){
return true;
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__15317 = arguments.length;
switch (G__15317) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15318(name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15319(ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function cljs$core$fn_15321(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function cljs$core$fn_15322(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function cljs$core$fn_15323(){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var cljs$core$fn_15324 = null;
var cljs$core$fn_15324__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15324__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15324 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15324__1.call(this,x);
case 2:
return cljs$core$fn_15324__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15324.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15324__1;
cljs$core$fn_15324.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15324__2;
return cljs$core$fn_15324;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_15325 = null;
var cljs$core$fn_15325__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15325__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15325 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15325__1.call(this,x);
case 2:
return cljs$core$fn_15325__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15325.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15325__1;
cljs$core$fn_15325.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15325__2;
return cljs$core$fn_15325;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15326(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15327(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15328(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15329(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15330(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_15331(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15332(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15333(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15334(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15335(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15336(coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__15342 = ls.sval();
ls = G__15342;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15337(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function cljs$core$fn_15337_$_fn_15338(){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15339(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function cljs$core$fn_15340(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_15341(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15343(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function cljs$core$fn_15344(o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function cljs$core$fn_15345(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15346(_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function cljs$core$fn_15347(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function cljs$core$fn_15348(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_15349(_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_15350(coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_15351(coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function cljs$core$fn_15352(coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_15353(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_15354(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function cljs$core$fn_15355(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function cljs$core$fn_15356(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__15358 = arguments.length;
switch (G__15358) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15359(arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15360(arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15361(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function cljs$core$fn_15363(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function cljs$core$fn_15364(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var cljs$core$fn_15365 = null;
var cljs$core$fn_15365__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_15365__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15365 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15365__1.call(this,x);
case 2:
return cljs$core$fn_15365__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15365.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15365__1;
cljs$core$fn_15365.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15365__2;
return cljs$core$fn_15365;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var cljs$core$fn_15366 = null;
var cljs$core$fn_15366__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_15366__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_15366 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_15366__1.call(this,x);
case 2:
return cljs$core$fn_15366__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15366.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15366__1;
cljs$core$fn_15366.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15366__2;
return cljs$core$fn_15366;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15367(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_15368(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15369(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15370(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_15371(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_15372(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_15373(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_15374(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_15375(coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_15376(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_15377(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_15378(this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_15379(coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function cljs$core$fn_15380(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function cljs$core$fn_15381(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15382(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__15384 = cljs.core.next(s);
s = G__15384;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_15385 = (0);
var xs_15386 = cljs.core.seq(coll);
while(true){
if((xs_15386 == null)){
} else {
(ret[i_15385] = cljs.core.to_array(cljs.core.first(xs_15386)));

var G__15387 = (i_15385 + (1));
var G__15388 = cljs.core.next(xs_15386);
i_15385 = G__15387;
xs_15386 = G__15388;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__15390 = arguments.length;
switch (G__15390) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15391(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15392(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15394 = (i + (1));
var G__15395 = cljs.core.next(s__$1);
i = G__15394;
s__$1 = G__15395;
continue;
} else {
return a;
}
break;
}
} else {
var n__10581__auto___15396 = size;
var i_15397 = (0);
while(true){
if((i_15397 < n__10581__auto___15396)){
(a[i_15397] = init_val_or_seq);

var G__15398 = (i_15397 + (1));
i_15397 = G__15398;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__15400 = arguments.length;
switch (G__15400) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15401(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15402(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15404 = (i + (1));
var G__15405 = cljs.core.next(s__$1);
i = G__15404;
s__$1 = G__15405;
continue;
} else {
return a;
}
break;
}
} else {
var n__10581__auto___15406 = size;
var i_15407 = (0);
while(true){
if((i_15407 < n__10581__auto___15406)){
(a[i_15407] = init_val_or_seq);

var G__15408 = (i_15407 + (1));
i_15407 = G__15408;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__15410 = arguments.length;
switch (G__15410) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15411(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15412(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15414 = (i + (1));
var G__15415 = cljs.core.next(s__$1);
i = G__15414;
s__$1 = G__15415;
continue;
} else {
return a;
}
break;
}
} else {
var n__10581__auto___15416 = size;
var i_15417 = (0);
while(true){
if((i_15417 < n__10581__auto___15416)){
(a[i_15417] = init_val_or_seq);

var G__15418 = (i_15417 + (1));
i_15417 = G__15418;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__15420 = arguments.length;
switch (G__15420) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15421(size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15422(size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__15424 = (i + (1));
var G__15425 = cljs.core.next(s__$1);
i = G__15424;
s__$1 = G__15425;
continue;
} else {
return a;
}
break;
}
} else {
var n__10581__auto___15426 = size;
var i_15427 = (0);
while(true){
if((i_15427 < n__10581__auto___15426)){
(a[i_15427] = init_val_or_seq);

var G__15428 = (i_15427 + (1));
i_15427 = G__15428;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__15429 = (i + (1));
var G__15430 = cljs.core.next(s);
i = G__15429;
s = G__15430;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__15435 = arguments.length;
switch (G__15435) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15446 = arguments.length;
var i__10823__auto___15447 = (0);
while(true){
if((i__10823__auto___15447 < len__10822__auto___15446)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15447]));

var G__15448 = (i__10823__auto___15447 + (1));
i__10823__auto___15447 = G__15448;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15436(){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15436_$_fn_15437(){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15438(x){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15438_$_fn_15439(){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15440(x,y){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15440_$_fn_15441(){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15442(x,y,zs){
var cat = (function cljs$core$fn_15442_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15442_$_cat_$_fn_15443(){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$fn_15442_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$fn_15442_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$fn_15442_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function cljs$core$fn_15444(seq15432){
var G__15433 = cljs.core.first(seq15432);
var seq15432__$1 = cljs.core.next(seq15432);
var G__15434 = cljs.core.first(seq15432__$1);
var seq15432__$2 = cljs.core.next(seq15432__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15433,G__15434,seq15432__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__15455 = arguments.length;
switch (G__15455) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15463 = arguments.length;
var i__10823__auto___15464 = (0);
while(true){
if((i__10823__auto___15464 < len__10822__auto___15463)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15464]));

var G__15465 = (i__10823__auto___15464 + (1));
i__10823__auto___15464 = G__15465;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15456(args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15457(a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15458(a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15459(a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15460(a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function cljs$core$fn_15461(seq15450){
var G__15451 = cljs.core.first(seq15450);
var seq15450__$1 = cljs.core.next(seq15450);
var G__15452 = cljs.core.first(seq15450__$1);
var seq15450__$2 = cljs.core.next(seq15450__$1);
var G__15453 = cljs.core.first(seq15450__$2);
var seq15450__$3 = cljs.core.next(seq15450__$2);
var G__15454 = cljs.core.first(seq15450__$3);
var seq15450__$4 = cljs.core.next(seq15450__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15451,G__15452,G__15453,G__15454,seq15450__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__15470 = arguments.length;
switch (G__15470) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15477 = arguments.length;
var i__10823__auto___15478 = (0);
while(true){
if((i__10823__auto___15478 < len__10822__auto___15477)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15478]));

var G__15479 = (i__10823__auto___15478 + (1));
i__10823__auto___15478 = G__15479;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15471(){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15472(tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15473(tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15474(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15480 = ntcoll;
var G__15481 = cljs.core.first(vals);
var G__15482 = cljs.core.next(vals);
tcoll = G__15480;
val = G__15481;
vals = G__15482;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15475(seq15467){
var G__15468 = cljs.core.first(seq15467);
var seq15467__$1 = cljs.core.next(seq15467);
var G__15469 = cljs.core.first(seq15467__$1);
var seq15467__$2 = cljs.core.next(seq15467__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15468,G__15469,seq15467__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__15488 = arguments.length;
switch (G__15488) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15493 = arguments.length;
var i__10823__auto___15494 = (0);
while(true){
if((i__10823__auto___15494 < len__10822__auto___15493)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15494]));

var G__15495 = (i__10823__auto___15494 + (1));
i__10823__auto___15494 = G__15495;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15489(tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15490(tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__15496 = ntcoll;
var G__15497 = cljs.core.first(kvs);
var G__15498 = cljs.core.second(kvs);
var G__15499 = cljs.core.nnext(kvs);
tcoll = G__15496;
key = G__15497;
val = G__15498;
kvs = G__15499;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15491(seq15484){
var G__15485 = cljs.core.first(seq15484);
var seq15484__$1 = cljs.core.next(seq15484);
var G__15486 = cljs.core.first(seq15484__$1);
var seq15484__$2 = cljs.core.next(seq15484__$1);
var G__15487 = cljs.core.first(seq15484__$2);
var seq15484__$3 = cljs.core.next(seq15484__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15485,G__15486,G__15487,seq15484__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__15504 = arguments.length;
switch (G__15504) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15509 = arguments.length;
var i__10823__auto___15510 = (0);
while(true){
if((i__10823__auto___15510 < len__10822__auto___15509)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15510]));

var G__15511 = (i__10823__auto___15510 + (1));
i__10823__auto___15510 = G__15511;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15505(tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15506(tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__15512 = ntcoll;
var G__15513 = cljs.core.first(ks);
var G__15514 = cljs.core.next(ks);
tcoll = G__15512;
key = G__15513;
ks = G__15514;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15507(seq15501){
var G__15502 = cljs.core.first(seq15501);
var seq15501__$1 = cljs.core.next(seq15501);
var G__15503 = cljs.core.first(seq15501__$1);
var seq15501__$2 = cljs.core.next(seq15501__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15502,G__15503,seq15501__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__15519 = arguments.length;
switch (G__15519) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15524 = arguments.length;
var i__10823__auto___15525 = (0);
while(true){
if((i__10823__auto___15525 < len__10822__auto___15524)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15525]));

var G__15526 = (i__10823__auto___15525 + (1));
i__10823__auto___15525 = G__15526;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15520(tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15521(tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__15527 = ntcoll;
var G__15528 = cljs.core.first(vals);
var G__15529 = cljs.core.next(vals);
tcoll = G__15527;
val = G__15528;
vals = G__15529;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15522(seq15516){
var G__15517 = cljs.core.first(seq15516);
var seq15516__$1 = cljs.core.next(seq15516);
var G__15518 = cljs.core.first(seq15516__$1);
var seq15516__$2 = cljs.core.next(seq15516__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15517,G__15518,seq15516__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a10625 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10625) : f.call(null,a10625));
} else {
var b10626 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10625,b10626) : f.call(null,a10625,b10626));
} else {
var c10627 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10625,b10626,c10627) : f.call(null,a10625,b10626,c10627));
} else {
var d10628 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10625,b10626,c10627,d10628) : f.call(null,a10625,b10626,c10627,d10628));
} else {
var e10629 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10625,b10626,c10627,d10628,e10629) : f.call(null,a10625,b10626,c10627,d10628,e10629));
} else {
var f10630 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10625,b10626,c10627,d10628,e10629,f10630) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630));
} else {
var g10631 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10625,b10626,c10627,d10628,e10629,f10630,g10631) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631));
} else {
var h10632 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632));
} else {
var i10633 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633));
} else {
var j10634 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634));
} else {
var k10635 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635));
} else {
var l10636 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636));
} else {
var m10637 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637));
} else {
var n10638 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638));
} else {
var o10639 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639));
} else {
var p10640 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640));
} else {
var q10641 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641));
} else {
var r10642 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642));
} else {
var s10643 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642,s10643) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642,s10643));
} else {
var t10644 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642,s10643,t10644) : f.call(null,a10625,b10626,c10627,d10628,e10629,f10630,g10631,h10632,i10633,j10634,k10635,l10636,m10637,n10638,o10639,p10640,q10641,r10642,s10643,t10644));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__15532 = arguments.length;
switch (G__15532) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15533(f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15534(f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15535(f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15536(f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15537(f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__10653__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__10654__auto___15539 = next_19;
while(true){
if(s__10654__auto___15539){
arr__10653__auto__.push(cljs.core._first(s__10654__auto___15539));

var G__15540 = cljs.core.next(s__10654__auto___15539);
s__10654__auto___15539 = G__15540;
continue;
} else {
}
break;
}

return f.apply(f,arr__10653__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__15548 = arguments.length;
switch (G__15548) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15556 = arguments.length;
var i__10823__auto___15557 = (0);
while(true){
if((i__10823__auto___15557 < len__10822__auto___15556)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15557]));

var G__15558 = (i__10823__auto___15557 + (1));
i__10823__auto___15557 = G__15558;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__10852__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15549(f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15550(f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15551(f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15552(f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15553(f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function cljs$core$fn_15554(seq15542){
var G__15543 = cljs.core.first(seq15542);
var seq15542__$1 = cljs.core.next(seq15542);
var G__15544 = cljs.core.first(seq15542__$1);
var seq15542__$2 = cljs.core.next(seq15542__$1);
var G__15545 = cljs.core.first(seq15542__$2);
var seq15542__$3 = cljs.core.next(seq15542__$2);
var G__15546 = cljs.core.first(seq15542__$3);
var seq15542__$4 = cljs.core.next(seq15542__$3);
var G__15547 = cljs.core.first(seq15542__$4);
var seq15542__$5 = cljs.core.next(seq15542__$4);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15543,G__15544,G__15545,G__15546,G__15547,seq15542__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__15568 = arguments.length;
switch (G__15568) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15592 = arguments.length;
var i__10823__auto___15593 = (0);
while(true){
if((i__10823__auto___15593 < len__10822__auto___15592)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15593]));

var G__15594 = (i__10823__auto___15593 + (1));
i__10823__auto___15593 = G__15594;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10852__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15569(obj,f){
return cljs.core.with_meta(obj,(function (){var G__15570 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15570) : f.call(null,G__15570));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15571(obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__15572 = cljs.core.meta(obj);
var G__15573 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15572,G__15573) : f.call(null,G__15572,G__15573));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15574(obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__15575 = cljs.core.meta(obj);
var G__15576 = a;
var G__15577 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15575,G__15576,G__15577) : f.call(null,G__15575,G__15576,G__15577));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_15578(obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__15579 = cljs.core.meta(obj);
var G__15580 = a;
var G__15581 = b;
var G__15582 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__15579,G__15580,G__15581,G__15582) : f.call(null,G__15579,G__15580,G__15581,G__15582));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_15583(obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__15584 = cljs.core.meta(obj);
var G__15585 = a;
var G__15586 = b;
var G__15587 = c;
var G__15588 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__15584,G__15585,G__15586,G__15587,G__15588) : f.call(null,G__15584,G__15585,G__15586,G__15587,G__15588));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15589(obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function cljs$core$fn_15590(seq15561){
var G__15562 = cljs.core.first(seq15561);
var seq15561__$1 = cljs.core.next(seq15561);
var G__15563 = cljs.core.first(seq15561__$1);
var seq15561__$2 = cljs.core.next(seq15561__$1);
var G__15564 = cljs.core.first(seq15561__$2);
var seq15561__$3 = cljs.core.next(seq15561__$2);
var G__15565 = cljs.core.first(seq15561__$3);
var seq15561__$4 = cljs.core.next(seq15561__$3);
var G__15566 = cljs.core.first(seq15561__$4);
var seq15561__$5 = cljs.core.next(seq15561__$4);
var G__15567 = cljs.core.first(seq15561__$5);
var seq15561__$6 = cljs.core.next(seq15561__$5);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15562,G__15563,G__15564,G__15565,G__15566,G__15567,seq15561__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__15599 = arguments.length;
switch (G__15599) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15605 = arguments.length;
var i__10823__auto___15606 = (0);
while(true){
if((i__10823__auto___15606 < len__10822__auto___15605)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15606]));

var G__15607 = (i__10823__auto___15606 + (1));
i__10823__auto___15606 = G__15607;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15600(x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15601(x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15602(x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function cljs$core$fn_15603(seq15596){
var G__15597 = cljs.core.first(seq15596);
var seq15596__$1 = cljs.core.next(seq15596);
var G__15598 = cljs.core.first(seq15596__$1);
var seq15596__$2 = cljs.core.next(seq15596__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15597,G__15598,seq15596__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core15608 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core15608 = (function (meta15609){
this.meta15609 = meta15609;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core15608.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$nil_iter_$_fn_15611(_15610,meta15609__$1){
var self__ = this;
var _15610__$1 = this;
return (new cljs.core.t_cljs$core15608(meta15609__$1));
}));

(cljs.core.t_cljs$core15608.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$nil_iter_$_fn_15612(_15610){
var self__ = this;
var _15610__$1 = this;
return self__.meta15609;
}));

(cljs.core.t_cljs$core15608.prototype.hasNext = (function cljs$core$nil_iter_$_fn_15613(){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core15608.prototype.next = (function cljs$core$nil_iter_$_fn_15614(){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core15608.prototype.remove = (function cljs$core$nil_iter_$_fn_15615(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core15608.getBasis = (function cljs$core$nil_iter_$_fn_15616(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta15609","meta15609",-112283595,null)], null);
}));

(cljs.core.t_cljs$core15608.cljs$lang$type = true);

(cljs.core.t_cljs$core15608.cljs$lang$ctorStr = "cljs.core/t_cljs$core15608");

(cljs.core.t_cljs$core15608.cljs$lang$ctorPrWriter = (function cljs$core$nil_iter_$_fn_15617(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/t_cljs$core15608");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core15608.
 */
cljs.core.__GT_t_cljs$core15608 = (function cljs$core$nil_iter_$___GT_t_cljs$core15608(meta15609){
return (new cljs.core.t_cljs$core15608(meta15609));
});

}

return (new cljs.core.t_cljs$core15608(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function cljs$core$fn_15618(){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function cljs$core$fn_15619(){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function cljs$core$fn_15620(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function cljs$core$fn_15621(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15622(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function cljs$core$fn_15623(){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function cljs$core$fn_15624(){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function cljs$core$fn_15625(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function cljs$core$fn_15626(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15627(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function cljs$core$fn_15628(){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function cljs$core$fn_15629(){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function cljs$core$fn_15630(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function cljs$core$fn_15631(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_15632(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function cljs$core$fn_15633(o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function cljs$core$fn_15634(){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function cljs$core$fn_15635(){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function cljs$core$fn_15636(){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function cljs$core$fn_15637(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function cljs$core$fn_15638(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function cljs$core$fn_15639(o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function cljs$core$fn_15640(){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function cljs$core$fn_15641(){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function cljs$core$fn_15642(){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function cljs$core$fn_15643(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function cljs$core$fn_15644(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function cljs$core$fn_15645(o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function cljs$core$fn_15646(){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function cljs$core$fn_15647(){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function cljs$core$fn_15648(){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function cljs$core$fn_15649(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function cljs$core$fn_15650(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function cljs$core$fn_15651(){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__15655 = cljs.core.next(iters__$1);
iters__$1 = G__15655;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function cljs$core$fn_15652(){
var self__ = this;
var _ = this;
var nexts = [];
var n__10581__auto___15656 = self__.iters.length;
var i_15657 = (0);
while(true){
if((i_15657 < n__10581__auto___15656)){
(nexts[i_15657] = (self__.iters[i_15657]).next());

var G__15658 = (i_15657 + (1));
i_15657 = G__15658;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function cljs$core$fn_15653(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15654(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function cljs$core$chunkIteratorSeq_$_fn_15659(){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__9487__auto__ = iter.hasNext();
if(cljs.core.truth_(and__9487__auto__)){
return (n < (32));
} else {
return and__9487__auto__;
}
})())){
(arr[n] = iter.next());

var G__15660 = (n + (1));
n = G__15660;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function cljs$core$fn_15661(){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__15662 = null;
var G__15663 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__15662,G__15663) : self__.xf.call(null,G__15662,G__15663));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function cljs$core$fn_15664(){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function cljs$core$fn_15665(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function cljs$core$fn_15666(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function cljs$core$fn_15667(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_15668(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_15669(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__15670 = (function() {
var cljs$core$transformer_iterator_$_fn_15671 = null;
var cljs$core$transformer_iterator_$_fn_15671__0 = (function (){
return null;
});
var cljs$core$transformer_iterator_$_fn_15671__1 = (function (acc){
return acc;
});
var cljs$core$transformer_iterator_$_fn_15671__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
cljs$core$transformer_iterator_$_fn_15671 = function(acc,o){
switch(arguments.length){
case 0:
return cljs$core$transformer_iterator_$_fn_15671__0.call(this);
case 1:
return cljs$core$transformer_iterator_$_fn_15671__1.call(this,acc);
case 2:
return cljs$core$transformer_iterator_$_fn_15671__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transformer_iterator_$_fn_15671.cljs$core$IFn$_invoke$arity$0 = cljs$core$transformer_iterator_$_fn_15671__0;
cljs$core$transformer_iterator_$_fn_15671.cljs$core$IFn$_invoke$arity$1 = cljs$core$transformer_iterator_$_fn_15671__1;
cljs$core$transformer_iterator_$_fn_15671.cljs$core$IFn$_invoke$arity$2 = cljs$core$transformer_iterator_$_fn_15671__2;
return cljs$core$transformer_iterator_$_fn_15671;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__15670) : xform.call(null,G__15670));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function cljs$core$fn_15672(xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function cljs$core$fn_15673(xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__15678 = arguments.length;
switch (G__15678) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15684 = arguments.length;
var i__10823__auto___15685 = (0);
while(true){
if((i__10823__auto___15685 < len__10822__auto___15684)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15685]));

var G__15686 = (i__10823__auto___15685 + (1));
i__10823__auto___15685 = G__15686;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15679(coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__9493__auto__ = cljs.core.seq(coll);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15680(xform,coll){
var or__9493__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15681(xform,coll,colls){
var or__9493__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function cljs$core$fn_15682(seq15675){
var G__15676 = cljs.core.first(seq15675);
var seq15675__$1 = cljs.core.next(seq15675);
var G__15677 = cljs.core.first(seq15675__$1);
var seq15675__$2 = cljs.core.next(seq15675__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15676,G__15677,seq15675__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__15687 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15687) : pred.call(null,G__15687));
})())){
var G__15688 = pred;
var G__15689 = cljs.core.next(coll);
pred = G__15688;
coll = G__15689;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__9493__auto__ = (function (){var G__15690 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__15690) : pred.call(null,G__15690));
})();
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var G__15691 = pred;
var G__15692 = cljs.core.next(s);
pred = G__15691;
coll = G__15692;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var cljs$core$complement_$_fn_15693 = null;
var cljs$core$complement_$_fn_15693__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var cljs$core$complement_$_fn_15693__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var cljs$core$complement_$_fn_15693__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var cljs$core$complement_$_fn_15693__3 = (function() { 
var G__15694__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__15694 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__15695__i = 0, G__15695__a = new Array(arguments.length -  2);
while (G__15695__i < G__15695__a.length) {G__15695__a[G__15695__i] = arguments[G__15695__i + 2]; ++G__15695__i;}
  zs = new cljs.core.IndexedSeq(G__15695__a,0,null);
} 
return G__15694__delegate.call(this,x,y,zs);};
G__15694.cljs$lang$maxFixedArity = 2;
G__15694.cljs$lang$applyTo = (function (arglist__15696){
var x = cljs.core.first(arglist__15696);
arglist__15696 = cljs.core.next(arglist__15696);
var y = cljs.core.first(arglist__15696);
var zs = cljs.core.rest(arglist__15696);
return G__15694__delegate(x,y,zs);
});
G__15694.cljs$core$IFn$_invoke$arity$variadic = G__15694__delegate;
return G__15694;
})()
;
cljs$core$complement_$_fn_15693 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$complement_$_fn_15693__0.call(this);
case 1:
return cljs$core$complement_$_fn_15693__1.call(this,x);
case 2:
return cljs$core$complement_$_fn_15693__2.call(this,x,y);
default:
var G__15697 = null;
if (arguments.length > 2) {
var G__15698__i = 0, G__15698__a = new Array(arguments.length -  2);
while (G__15698__i < G__15698__a.length) {G__15698__a[G__15698__i] = arguments[G__15698__i + 2]; ++G__15698__i;}
G__15697 = new cljs.core.IndexedSeq(G__15698__a,0,null);
}
return cljs$core$complement_$_fn_15693__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__15697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$complement_$_fn_15693.cljs$lang$maxFixedArity = 2;
cljs$core$complement_$_fn_15693.cljs$lang$applyTo = cljs$core$complement_$_fn_15693__3.cljs$lang$applyTo;
cljs$core$complement_$_fn_15693.cljs$core$IFn$_invoke$arity$0 = cljs$core$complement_$_fn_15693__0;
cljs$core$complement_$_fn_15693.cljs$core$IFn$_invoke$arity$1 = cljs$core$complement_$_fn_15693__1;
cljs$core$complement_$_fn_15693.cljs$core$IFn$_invoke$arity$2 = cljs$core$complement_$_fn_15693__2;
cljs$core$complement_$_fn_15693.cljs$core$IFn$_invoke$arity$variadic = cljs$core$complement_$_fn_15693__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$complement_$_fn_15693;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var cljs$core$constantly_$_fn_15699__delegate = function (args){
return x;
};
var cljs$core$constantly_$_fn_15699 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15700__i = 0, G__15700__a = new Array(arguments.length -  0);
while (G__15700__i < G__15700__a.length) {G__15700__a[G__15700__i] = arguments[G__15700__i + 0]; ++G__15700__i;}
  args = new cljs.core.IndexedSeq(G__15700__a,0,null);
} 
return cljs$core$constantly_$_fn_15699__delegate.call(this,args);};
cljs$core$constantly_$_fn_15699.cljs$lang$maxFixedArity = 0;
cljs$core$constantly_$_fn_15699.cljs$lang$applyTo = (function (arglist__15701){
var args = cljs.core.seq(arglist__15701);
return cljs$core$constantly_$_fn_15699__delegate(args);
});
cljs$core$constantly_$_fn_15699.cljs$core$IFn$_invoke$arity$variadic = cljs$core$constantly_$_fn_15699__delegate;
return cljs$core$constantly_$_fn_15699;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__15707 = arguments.length;
switch (G__15707) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15734 = arguments.length;
var i__10823__auto___15735 = (0);
while(true){
if((i__10823__auto___15735 < len__10822__auto___15734)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15735]));

var G__15736 = (i__10823__auto___15735 + (1));
i__10823__auto___15735 = G__15736;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_15708(){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15709(f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15710(f,g){
return (function() {
var cljs$core$fn_15710_$_fn_15711 = null;
var cljs$core$fn_15710_$_fn_15711__0 = (function (){
var G__15712 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15712) : f.call(null,G__15712));
});
var cljs$core$fn_15710_$_fn_15711__1 = (function (x){
var G__15713 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15713) : f.call(null,G__15713));
});
var cljs$core$fn_15710_$_fn_15711__2 = (function (x,y){
var G__15714 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15714) : f.call(null,G__15714));
});
var cljs$core$fn_15710_$_fn_15711__3 = (function (x,y,z){
var G__15715 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15715) : f.call(null,G__15715));
});
var cljs$core$fn_15710_$_fn_15711__4 = (function() { 
var G__15737__delegate = function (x,y,z,args){
var G__15716 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15716) : f.call(null,G__15716));
};
var G__15737 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15738__i = 0, G__15738__a = new Array(arguments.length -  3);
while (G__15738__i < G__15738__a.length) {G__15738__a[G__15738__i] = arguments[G__15738__i + 3]; ++G__15738__i;}
  args = new cljs.core.IndexedSeq(G__15738__a,0,null);
} 
return G__15737__delegate.call(this,x,y,z,args);};
G__15737.cljs$lang$maxFixedArity = 3;
G__15737.cljs$lang$applyTo = (function (arglist__15739){
var x = cljs.core.first(arglist__15739);
arglist__15739 = cljs.core.next(arglist__15739);
var y = cljs.core.first(arglist__15739);
arglist__15739 = cljs.core.next(arglist__15739);
var z = cljs.core.first(arglist__15739);
var args = cljs.core.rest(arglist__15739);
return G__15737__delegate(x,y,z,args);
});
G__15737.cljs$core$IFn$_invoke$arity$variadic = G__15737__delegate;
return G__15737;
})()
;
cljs$core$fn_15710_$_fn_15711 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15710_$_fn_15711__0.call(this);
case 1:
return cljs$core$fn_15710_$_fn_15711__1.call(this,x);
case 2:
return cljs$core$fn_15710_$_fn_15711__2.call(this,x,y);
case 3:
return cljs$core$fn_15710_$_fn_15711__3.call(this,x,y,z);
default:
var G__15740 = null;
if (arguments.length > 3) {
var G__15741__i = 0, G__15741__a = new Array(arguments.length -  3);
while (G__15741__i < G__15741__a.length) {G__15741__a[G__15741__i] = arguments[G__15741__i + 3]; ++G__15741__i;}
G__15740 = new cljs.core.IndexedSeq(G__15741__a,0,null);
}
return cljs$core$fn_15710_$_fn_15711__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15710_$_fn_15711.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15710_$_fn_15711.cljs$lang$applyTo = cljs$core$fn_15710_$_fn_15711__4.cljs$lang$applyTo;
cljs$core$fn_15710_$_fn_15711.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15710_$_fn_15711__0;
cljs$core$fn_15710_$_fn_15711.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15710_$_fn_15711__1;
cljs$core$fn_15710_$_fn_15711.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15710_$_fn_15711__2;
cljs$core$fn_15710_$_fn_15711.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15710_$_fn_15711__3;
cljs$core$fn_15710_$_fn_15711.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15710_$_fn_15711__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15710_$_fn_15711;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15717(f,g,h){
return (function() {
var cljs$core$fn_15717_$_fn_15718 = null;
var cljs$core$fn_15717_$_fn_15718__0 = (function (){
var G__15719 = (function (){var G__15720 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15720) : g.call(null,G__15720));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15719) : f.call(null,G__15719));
});
var cljs$core$fn_15717_$_fn_15718__1 = (function (x){
var G__15721 = (function (){var G__15722 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15722) : g.call(null,G__15722));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15721) : f.call(null,G__15721));
});
var cljs$core$fn_15717_$_fn_15718__2 = (function (x,y){
var G__15723 = (function (){var G__15724 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15724) : g.call(null,G__15724));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15723) : f.call(null,G__15723));
});
var cljs$core$fn_15717_$_fn_15718__3 = (function (x,y,z){
var G__15725 = (function (){var G__15726 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15726) : g.call(null,G__15726));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15725) : f.call(null,G__15725));
});
var cljs$core$fn_15717_$_fn_15718__4 = (function() { 
var G__15742__delegate = function (x,y,z,args){
var G__15727 = (function (){var G__15728 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__15728) : g.call(null,G__15728));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15727) : f.call(null,G__15727));
};
var G__15742 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15743__i = 0, G__15743__a = new Array(arguments.length -  3);
while (G__15743__i < G__15743__a.length) {G__15743__a[G__15743__i] = arguments[G__15743__i + 3]; ++G__15743__i;}
  args = new cljs.core.IndexedSeq(G__15743__a,0,null);
} 
return G__15742__delegate.call(this,x,y,z,args);};
G__15742.cljs$lang$maxFixedArity = 3;
G__15742.cljs$lang$applyTo = (function (arglist__15744){
var x = cljs.core.first(arglist__15744);
arglist__15744 = cljs.core.next(arglist__15744);
var y = cljs.core.first(arglist__15744);
arglist__15744 = cljs.core.next(arglist__15744);
var z = cljs.core.first(arglist__15744);
var args = cljs.core.rest(arglist__15744);
return G__15742__delegate(x,y,z,args);
});
G__15742.cljs$core$IFn$_invoke$arity$variadic = G__15742__delegate;
return G__15742;
})()
;
cljs$core$fn_15717_$_fn_15718 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15717_$_fn_15718__0.call(this);
case 1:
return cljs$core$fn_15717_$_fn_15718__1.call(this,x);
case 2:
return cljs$core$fn_15717_$_fn_15718__2.call(this,x,y);
case 3:
return cljs$core$fn_15717_$_fn_15718__3.call(this,x,y,z);
default:
var G__15745 = null;
if (arguments.length > 3) {
var G__15746__i = 0, G__15746__a = new Array(arguments.length -  3);
while (G__15746__i < G__15746__a.length) {G__15746__a[G__15746__i] = arguments[G__15746__i + 3]; ++G__15746__i;}
G__15745 = new cljs.core.IndexedSeq(G__15746__a,0,null);
}
return cljs$core$fn_15717_$_fn_15718__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15717_$_fn_15718.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15717_$_fn_15718.cljs$lang$applyTo = cljs$core$fn_15717_$_fn_15718__4.cljs$lang$applyTo;
cljs$core$fn_15717_$_fn_15718.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15717_$_fn_15718__0;
cljs$core$fn_15717_$_fn_15718.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15717_$_fn_15718__1;
cljs$core$fn_15717_$_fn_15718.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15717_$_fn_15718__2;
cljs$core$fn_15717_$_fn_15718.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15717_$_fn_15718__3;
cljs$core$fn_15717_$_fn_15718.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15717_$_fn_15718__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15717_$_fn_15718;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15729(f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var cljs$core$fn_15729_$_fn_15730__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__15747 = (function (){var fexpr__15731 = cljs.core.first(fs__$2);
return (fexpr__15731.cljs$core$IFn$_invoke$arity$1 ? fexpr__15731.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__15731.call(null,ret));
})();
var G__15748 = cljs.core.next(fs__$2);
ret = G__15747;
fs__$2 = G__15748;
continue;
} else {
return ret;
}
break;
}
};
var cljs$core$fn_15729_$_fn_15730 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15749__i = 0, G__15749__a = new Array(arguments.length -  0);
while (G__15749__i < G__15749__a.length) {G__15749__a[G__15749__i] = arguments[G__15749__i + 0]; ++G__15749__i;}
  args = new cljs.core.IndexedSeq(G__15749__a,0,null);
} 
return cljs$core$fn_15729_$_fn_15730__delegate.call(this,args);};
cljs$core$fn_15729_$_fn_15730.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15729_$_fn_15730.cljs$lang$applyTo = (function (arglist__15750){
var args = cljs.core.seq(arglist__15750);
return cljs$core$fn_15729_$_fn_15730__delegate(args);
});
cljs$core$fn_15729_$_fn_15730.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15729_$_fn_15730__delegate;
return cljs$core$fn_15729_$_fn_15730;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function cljs$core$fn_15732(seq15703){
var G__15704 = cljs.core.first(seq15703);
var seq15703__$1 = cljs.core.next(seq15703);
var G__15705 = cljs.core.first(seq15703__$1);
var seq15703__$2 = cljs.core.next(seq15703__$1);
var G__15706 = cljs.core.first(seq15703__$2);
var seq15703__$3 = cljs.core.next(seq15703__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15704,G__15705,G__15706,seq15703__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__15757 = arguments.length;
switch (G__15757) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15769 = arguments.length;
var i__10823__auto___15770 = (0);
while(true){
if((i__10823__auto___15770 < len__10822__auto___15769)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15770]));

var G__15771 = (i__10823__auto___15770 + (1));
i__10823__auto___15770 = G__15771;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15758(f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15759(f,arg1){
return (function() {
var cljs$core$fn_15759_$_fn_15760 = null;
var cljs$core$fn_15759_$_fn_15760__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var cljs$core$fn_15759_$_fn_15760__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var cljs$core$fn_15759_$_fn_15760__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var cljs$core$fn_15759_$_fn_15760__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var cljs$core$fn_15759_$_fn_15760__4 = (function() { 
var G__15772__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__15772 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15773__i = 0, G__15773__a = new Array(arguments.length -  3);
while (G__15773__i < G__15773__a.length) {G__15773__a[G__15773__i] = arguments[G__15773__i + 3]; ++G__15773__i;}
  args = new cljs.core.IndexedSeq(G__15773__a,0,null);
} 
return G__15772__delegate.call(this,x,y,z,args);};
G__15772.cljs$lang$maxFixedArity = 3;
G__15772.cljs$lang$applyTo = (function (arglist__15774){
var x = cljs.core.first(arglist__15774);
arglist__15774 = cljs.core.next(arglist__15774);
var y = cljs.core.first(arglist__15774);
arglist__15774 = cljs.core.next(arglist__15774);
var z = cljs.core.first(arglist__15774);
var args = cljs.core.rest(arglist__15774);
return G__15772__delegate(x,y,z,args);
});
G__15772.cljs$core$IFn$_invoke$arity$variadic = G__15772__delegate;
return G__15772;
})()
;
cljs$core$fn_15759_$_fn_15760 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15759_$_fn_15760__0.call(this);
case 1:
return cljs$core$fn_15759_$_fn_15760__1.call(this,x);
case 2:
return cljs$core$fn_15759_$_fn_15760__2.call(this,x,y);
case 3:
return cljs$core$fn_15759_$_fn_15760__3.call(this,x,y,z);
default:
var G__15775 = null;
if (arguments.length > 3) {
var G__15776__i = 0, G__15776__a = new Array(arguments.length -  3);
while (G__15776__i < G__15776__a.length) {G__15776__a[G__15776__i] = arguments[G__15776__i + 3]; ++G__15776__i;}
G__15775 = new cljs.core.IndexedSeq(G__15776__a,0,null);
}
return cljs$core$fn_15759_$_fn_15760__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15759_$_fn_15760.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15759_$_fn_15760.cljs$lang$applyTo = cljs$core$fn_15759_$_fn_15760__4.cljs$lang$applyTo;
cljs$core$fn_15759_$_fn_15760.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15759_$_fn_15760__0;
cljs$core$fn_15759_$_fn_15760.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15759_$_fn_15760__1;
cljs$core$fn_15759_$_fn_15760.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15759_$_fn_15760__2;
cljs$core$fn_15759_$_fn_15760.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15759_$_fn_15760__3;
cljs$core$fn_15759_$_fn_15760.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15759_$_fn_15760__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15759_$_fn_15760;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15761(f,arg1,arg2){
return (function() {
var cljs$core$fn_15761_$_fn_15762 = null;
var cljs$core$fn_15761_$_fn_15762__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var cljs$core$fn_15761_$_fn_15762__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var cljs$core$fn_15761_$_fn_15762__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var cljs$core$fn_15761_$_fn_15762__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var cljs$core$fn_15761_$_fn_15762__4 = (function() { 
var G__15777__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__15777 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15778__i = 0, G__15778__a = new Array(arguments.length -  3);
while (G__15778__i < G__15778__a.length) {G__15778__a[G__15778__i] = arguments[G__15778__i + 3]; ++G__15778__i;}
  args = new cljs.core.IndexedSeq(G__15778__a,0,null);
} 
return G__15777__delegate.call(this,x,y,z,args);};
G__15777.cljs$lang$maxFixedArity = 3;
G__15777.cljs$lang$applyTo = (function (arglist__15779){
var x = cljs.core.first(arglist__15779);
arglist__15779 = cljs.core.next(arglist__15779);
var y = cljs.core.first(arglist__15779);
arglist__15779 = cljs.core.next(arglist__15779);
var z = cljs.core.first(arglist__15779);
var args = cljs.core.rest(arglist__15779);
return G__15777__delegate(x,y,z,args);
});
G__15777.cljs$core$IFn$_invoke$arity$variadic = G__15777__delegate;
return G__15777;
})()
;
cljs$core$fn_15761_$_fn_15762 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15761_$_fn_15762__0.call(this);
case 1:
return cljs$core$fn_15761_$_fn_15762__1.call(this,x);
case 2:
return cljs$core$fn_15761_$_fn_15762__2.call(this,x,y);
case 3:
return cljs$core$fn_15761_$_fn_15762__3.call(this,x,y,z);
default:
var G__15780 = null;
if (arguments.length > 3) {
var G__15781__i = 0, G__15781__a = new Array(arguments.length -  3);
while (G__15781__i < G__15781__a.length) {G__15781__a[G__15781__i] = arguments[G__15781__i + 3]; ++G__15781__i;}
G__15780 = new cljs.core.IndexedSeq(G__15781__a,0,null);
}
return cljs$core$fn_15761_$_fn_15762__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15761_$_fn_15762.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15761_$_fn_15762.cljs$lang$applyTo = cljs$core$fn_15761_$_fn_15762__4.cljs$lang$applyTo;
cljs$core$fn_15761_$_fn_15762.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15761_$_fn_15762__0;
cljs$core$fn_15761_$_fn_15762.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15761_$_fn_15762__1;
cljs$core$fn_15761_$_fn_15762.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15761_$_fn_15762__2;
cljs$core$fn_15761_$_fn_15762.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15761_$_fn_15762__3;
cljs$core$fn_15761_$_fn_15762.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15761_$_fn_15762__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15761_$_fn_15762;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15763(f,arg1,arg2,arg3){
return (function() {
var cljs$core$fn_15763_$_fn_15764 = null;
var cljs$core$fn_15763_$_fn_15764__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var cljs$core$fn_15763_$_fn_15764__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var cljs$core$fn_15763_$_fn_15764__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var cljs$core$fn_15763_$_fn_15764__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var cljs$core$fn_15763_$_fn_15764__4 = (function() { 
var G__15782__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__15782 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__15783__i = 0, G__15783__a = new Array(arguments.length -  3);
while (G__15783__i < G__15783__a.length) {G__15783__a[G__15783__i] = arguments[G__15783__i + 3]; ++G__15783__i;}
  args = new cljs.core.IndexedSeq(G__15783__a,0,null);
} 
return G__15782__delegate.call(this,x,y,z,args);};
G__15782.cljs$lang$maxFixedArity = 3;
G__15782.cljs$lang$applyTo = (function (arglist__15784){
var x = cljs.core.first(arglist__15784);
arglist__15784 = cljs.core.next(arglist__15784);
var y = cljs.core.first(arglist__15784);
arglist__15784 = cljs.core.next(arglist__15784);
var z = cljs.core.first(arglist__15784);
var args = cljs.core.rest(arglist__15784);
return G__15782__delegate(x,y,z,args);
});
G__15782.cljs$core$IFn$_invoke$arity$variadic = G__15782__delegate;
return G__15782;
})()
;
cljs$core$fn_15763_$_fn_15764 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_15763_$_fn_15764__0.call(this);
case 1:
return cljs$core$fn_15763_$_fn_15764__1.call(this,x);
case 2:
return cljs$core$fn_15763_$_fn_15764__2.call(this,x,y);
case 3:
return cljs$core$fn_15763_$_fn_15764__3.call(this,x,y,z);
default:
var G__15785 = null;
if (arguments.length > 3) {
var G__15786__i = 0, G__15786__a = new Array(arguments.length -  3);
while (G__15786__i < G__15786__a.length) {G__15786__a[G__15786__i] = arguments[G__15786__i + 3]; ++G__15786__i;}
G__15785 = new cljs.core.IndexedSeq(G__15786__a,0,null);
}
return cljs$core$fn_15763_$_fn_15764__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__15785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15763_$_fn_15764.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15763_$_fn_15764.cljs$lang$applyTo = cljs$core$fn_15763_$_fn_15764__4.cljs$lang$applyTo;
cljs$core$fn_15763_$_fn_15764.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15763_$_fn_15764__0;
cljs$core$fn_15763_$_fn_15764.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15763_$_fn_15764__1;
cljs$core$fn_15763_$_fn_15764.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15763_$_fn_15764__2;
cljs$core$fn_15763_$_fn_15764.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15763_$_fn_15764__3;
cljs$core$fn_15763_$_fn_15764.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15763_$_fn_15764__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15763_$_fn_15764;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15765(f,arg1,arg2,arg3,more){
return (function() { 
var cljs$core$fn_15765_$_fn_15766__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var cljs$core$fn_15765_$_fn_15766 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15787__i = 0, G__15787__a = new Array(arguments.length -  0);
while (G__15787__i < G__15787__a.length) {G__15787__a[G__15787__i] = arguments[G__15787__i + 0]; ++G__15787__i;}
  args = new cljs.core.IndexedSeq(G__15787__a,0,null);
} 
return cljs$core$fn_15765_$_fn_15766__delegate.call(this,args);};
cljs$core$fn_15765_$_fn_15766.cljs$lang$maxFixedArity = 0;
cljs$core$fn_15765_$_fn_15766.cljs$lang$applyTo = (function (arglist__15788){
var args = cljs.core.seq(arglist__15788);
return cljs$core$fn_15765_$_fn_15766__delegate(args);
});
cljs$core$fn_15765_$_fn_15766.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15765_$_fn_15766__delegate;
return cljs$core$fn_15765_$_fn_15766;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function cljs$core$fn_15767(seq15752){
var G__15753 = cljs.core.first(seq15752);
var seq15752__$1 = cljs.core.next(seq15752);
var G__15754 = cljs.core.first(seq15752__$1);
var seq15752__$2 = cljs.core.next(seq15752__$1);
var G__15755 = cljs.core.first(seq15752__$2);
var seq15752__$3 = cljs.core.next(seq15752__$2);
var G__15756 = cljs.core.first(seq15752__$3);
var seq15752__$4 = cljs.core.next(seq15752__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15753,G__15754,G__15755,G__15756,seq15752__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__15790 = arguments.length;
switch (G__15790) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15791(f,x){
return (function() {
var cljs$core$fn_15791_$_fn_15792 = null;
var cljs$core$fn_15791_$_fn_15792__1 = (function (a){
var G__15793 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15793) : f.call(null,G__15793));
});
var cljs$core$fn_15791_$_fn_15792__2 = (function (a,b){
var G__15794 = (((a == null))?x:a);
var G__15795 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15794,G__15795) : f.call(null,G__15794,G__15795));
});
var cljs$core$fn_15791_$_fn_15792__3 = (function (a,b,c){
var G__15796 = (((a == null))?x:a);
var G__15797 = b;
var G__15798 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15796,G__15797,G__15798) : f.call(null,G__15796,G__15797,G__15798));
});
var cljs$core$fn_15791_$_fn_15792__4 = (function() { 
var G__15814__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__15814 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15815__i = 0, G__15815__a = new Array(arguments.length -  3);
while (G__15815__i < G__15815__a.length) {G__15815__a[G__15815__i] = arguments[G__15815__i + 3]; ++G__15815__i;}
  ds = new cljs.core.IndexedSeq(G__15815__a,0,null);
} 
return G__15814__delegate.call(this,a,b,c,ds);};
G__15814.cljs$lang$maxFixedArity = 3;
G__15814.cljs$lang$applyTo = (function (arglist__15816){
var a = cljs.core.first(arglist__15816);
arglist__15816 = cljs.core.next(arglist__15816);
var b = cljs.core.first(arglist__15816);
arglist__15816 = cljs.core.next(arglist__15816);
var c = cljs.core.first(arglist__15816);
var ds = cljs.core.rest(arglist__15816);
return G__15814__delegate(a,b,c,ds);
});
G__15814.cljs$core$IFn$_invoke$arity$variadic = G__15814__delegate;
return G__15814;
})()
;
cljs$core$fn_15791_$_fn_15792 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return cljs$core$fn_15791_$_fn_15792__1.call(this,a);
case 2:
return cljs$core$fn_15791_$_fn_15792__2.call(this,a,b);
case 3:
return cljs$core$fn_15791_$_fn_15792__3.call(this,a,b,c);
default:
var G__15817 = null;
if (arguments.length > 3) {
var G__15818__i = 0, G__15818__a = new Array(arguments.length -  3);
while (G__15818__i < G__15818__a.length) {G__15818__a[G__15818__i] = arguments[G__15818__i + 3]; ++G__15818__i;}
G__15817 = new cljs.core.IndexedSeq(G__15818__a,0,null);
}
return cljs$core$fn_15791_$_fn_15792__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15791_$_fn_15792.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15791_$_fn_15792.cljs$lang$applyTo = cljs$core$fn_15791_$_fn_15792__4.cljs$lang$applyTo;
cljs$core$fn_15791_$_fn_15792.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15791_$_fn_15792__1;
cljs$core$fn_15791_$_fn_15792.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15791_$_fn_15792__2;
cljs$core$fn_15791_$_fn_15792.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15791_$_fn_15792__3;
cljs$core$fn_15791_$_fn_15792.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15791_$_fn_15792__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15791_$_fn_15792;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15799(f,x,y){
return (function() {
var cljs$core$fn_15799_$_fn_15800 = null;
var cljs$core$fn_15799_$_fn_15800__2 = (function (a,b){
var G__15801 = (((a == null))?x:a);
var G__15802 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15801,G__15802) : f.call(null,G__15801,G__15802));
});
var cljs$core$fn_15799_$_fn_15800__3 = (function (a,b,c){
var G__15803 = (((a == null))?x:a);
var G__15804 = (((b == null))?y:b);
var G__15805 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15803,G__15804,G__15805) : f.call(null,G__15803,G__15804,G__15805));
});
var cljs$core$fn_15799_$_fn_15800__4 = (function() { 
var G__15819__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__15819 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15820__i = 0, G__15820__a = new Array(arguments.length -  3);
while (G__15820__i < G__15820__a.length) {G__15820__a[G__15820__i] = arguments[G__15820__i + 3]; ++G__15820__i;}
  ds = new cljs.core.IndexedSeq(G__15820__a,0,null);
} 
return G__15819__delegate.call(this,a,b,c,ds);};
G__15819.cljs$lang$maxFixedArity = 3;
G__15819.cljs$lang$applyTo = (function (arglist__15821){
var a = cljs.core.first(arglist__15821);
arglist__15821 = cljs.core.next(arglist__15821);
var b = cljs.core.first(arglist__15821);
arglist__15821 = cljs.core.next(arglist__15821);
var c = cljs.core.first(arglist__15821);
var ds = cljs.core.rest(arglist__15821);
return G__15819__delegate(a,b,c,ds);
});
G__15819.cljs$core$IFn$_invoke$arity$variadic = G__15819__delegate;
return G__15819;
})()
;
cljs$core$fn_15799_$_fn_15800 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15799_$_fn_15800__2.call(this,a,b);
case 3:
return cljs$core$fn_15799_$_fn_15800__3.call(this,a,b,c);
default:
var G__15822 = null;
if (arguments.length > 3) {
var G__15823__i = 0, G__15823__a = new Array(arguments.length -  3);
while (G__15823__i < G__15823__a.length) {G__15823__a[G__15823__i] = arguments[G__15823__i + 3]; ++G__15823__i;}
G__15822 = new cljs.core.IndexedSeq(G__15823__a,0,null);
}
return cljs$core$fn_15799_$_fn_15800__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15799_$_fn_15800.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15799_$_fn_15800.cljs$lang$applyTo = cljs$core$fn_15799_$_fn_15800__4.cljs$lang$applyTo;
cljs$core$fn_15799_$_fn_15800.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15799_$_fn_15800__2;
cljs$core$fn_15799_$_fn_15800.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15799_$_fn_15800__3;
cljs$core$fn_15799_$_fn_15800.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15799_$_fn_15800__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15799_$_fn_15800;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15806(f,x,y,z){
return (function() {
var cljs$core$fn_15806_$_fn_15807 = null;
var cljs$core$fn_15806_$_fn_15807__2 = (function (a,b){
var G__15808 = (((a == null))?x:a);
var G__15809 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15808,G__15809) : f.call(null,G__15808,G__15809));
});
var cljs$core$fn_15806_$_fn_15807__3 = (function (a,b,c){
var G__15810 = (((a == null))?x:a);
var G__15811 = (((b == null))?y:b);
var G__15812 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15810,G__15811,G__15812) : f.call(null,G__15810,G__15811,G__15812));
});
var cljs$core$fn_15806_$_fn_15807__4 = (function() { 
var G__15824__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__15824 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__15825__i = 0, G__15825__a = new Array(arguments.length -  3);
while (G__15825__i < G__15825__a.length) {G__15825__a[G__15825__i] = arguments[G__15825__i + 3]; ++G__15825__i;}
  ds = new cljs.core.IndexedSeq(G__15825__a,0,null);
} 
return G__15824__delegate.call(this,a,b,c,ds);};
G__15824.cljs$lang$maxFixedArity = 3;
G__15824.cljs$lang$applyTo = (function (arglist__15826){
var a = cljs.core.first(arglist__15826);
arglist__15826 = cljs.core.next(arglist__15826);
var b = cljs.core.first(arglist__15826);
arglist__15826 = cljs.core.next(arglist__15826);
var c = cljs.core.first(arglist__15826);
var ds = cljs.core.rest(arglist__15826);
return G__15824__delegate(a,b,c,ds);
});
G__15824.cljs$core$IFn$_invoke$arity$variadic = G__15824__delegate;
return G__15824;
})()
;
cljs$core$fn_15806_$_fn_15807 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return cljs$core$fn_15806_$_fn_15807__2.call(this,a,b);
case 3:
return cljs$core$fn_15806_$_fn_15807__3.call(this,a,b,c);
default:
var G__15827 = null;
if (arguments.length > 3) {
var G__15828__i = 0, G__15828__a = new Array(arguments.length -  3);
while (G__15828__i < G__15828__a.length) {G__15828__a[G__15828__i] = arguments[G__15828__i + 3]; ++G__15828__i;}
G__15827 = new cljs.core.IndexedSeq(G__15828__a,0,null);
}
return cljs$core$fn_15806_$_fn_15807__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__15827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15806_$_fn_15807.cljs$lang$maxFixedArity = 3;
cljs$core$fn_15806_$_fn_15807.cljs$lang$applyTo = cljs$core$fn_15806_$_fn_15807__4.cljs$lang$applyTo;
cljs$core$fn_15806_$_fn_15807.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15806_$_fn_15807__2;
cljs$core$fn_15806_$_fn_15807.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_15806_$_fn_15807__3;
cljs$core$fn_15806_$_fn_15807.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_15806_$_fn_15807__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_15806_$_fn_15807;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__15830 = arguments.length;
switch (G__15830) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15831(f){
return (function cljs$core$fn_15831_$_fn_15832(rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15831_$_fn_15832_$_fn_15833 = null;
var cljs$core$fn_15831_$_fn_15832_$_fn_15833__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15831_$_fn_15832_$_fn_15833__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15831_$_fn_15832_$_fn_15833__2 = (function (result,input){
var G__15834 = result;
var G__15835 = (function (){var G__15836 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__15837 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15836,G__15837) : f.call(null,G__15836,G__15837));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__15834,G__15835) : rf.call(null,G__15834,G__15835));
});
cljs$core$fn_15831_$_fn_15832_$_fn_15833 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15831_$_fn_15832_$_fn_15833__0.call(this);
case 1:
return cljs$core$fn_15831_$_fn_15832_$_fn_15833__1.call(this,result);
case 2:
return cljs$core$fn_15831_$_fn_15832_$_fn_15833__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15831_$_fn_15832_$_fn_15833.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15831_$_fn_15832_$_fn_15833__0;
cljs$core$fn_15831_$_fn_15832_$_fn_15833.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15831_$_fn_15832_$_fn_15833__1;
cljs$core$fn_15831_$_fn_15832_$_fn_15833.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15831_$_fn_15832_$_fn_15833__2;
return cljs$core$fn_15831_$_fn_15832_$_fn_15833;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15838(f,coll){
var mapi = (function cljs$core$fn_15838_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15838_$_mapi_$_fn_15844(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10581__auto___15850 = size;
var i_15851 = (0);
while(true){
if((i_15851 < n__10581__auto___15850)){
cljs.core.chunk_append(b,(function (){var G__15845 = (idx + i_15851);
var G__15846 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15851);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15845,G__15846) : f.call(null,G__15845,G__15846));
})());

var G__15852 = (i_15851 + (1));
i_15851 = G__15852;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15838_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__15847 = idx;
var G__15848 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15847,G__15848) : f.call(null,G__15847,G__15848));
})(),cljs$core$fn_15838_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__15854 = arguments.length;
switch (G__15854) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15855(f){
return (function cljs$core$fn_15855_$_fn_15856(rf){
return (function() {
var cljs$core$fn_15855_$_fn_15856_$_fn_15857 = null;
var cljs$core$fn_15855_$_fn_15856_$_fn_15857__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15855_$_fn_15856_$_fn_15857__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15855_$_fn_15856_$_fn_15857__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_15855_$_fn_15856_$_fn_15857 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15855_$_fn_15856_$_fn_15857__0.call(this);
case 1:
return cljs$core$fn_15855_$_fn_15856_$_fn_15857__1.call(this,result);
case 2:
return cljs$core$fn_15855_$_fn_15856_$_fn_15857__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15855_$_fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15855_$_fn_15856_$_fn_15857__0;
cljs$core$fn_15855_$_fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15855_$_fn_15856_$_fn_15857__1;
cljs$core$fn_15855_$_fn_15856_$_fn_15857.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15855_$_fn_15856_$_fn_15857__2;
return cljs$core$fn_15855_$_fn_15856_$_fn_15857;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15858(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15858_$_fn_15859(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10581__auto___15863 = size;
var i_15864 = (0);
while(true){
if((i_15864 < n__10581__auto___15863)){
var x_15865 = (function (){var G__15860 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15864);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15860) : f.call(null,G__15860));
})();
if((x_15865 == null)){
} else {
cljs.core.chunk_append(b,x_15865);
}

var G__15866 = (i_15864 + (1));
i_15864 = G__15866;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__15861 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15861) : f.call(null,G__15861));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function cljs$core$fn_15867(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_15868(o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_15869(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_15870(_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function cljs$core$fn_15871(this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__15872 = cljs.core.seq(self__.watches);
var chunk__15873 = null;
var count__15874 = (0);
var i__15875 = (0);
while(true){
if((i__15875 < count__15874)){
var vec__15882 = chunk__15873.cljs$core$IIndexed$_nth$arity$2(null,i__15875);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15882,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15882,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15893 = seq__15872;
var G__15894 = chunk__15873;
var G__15895 = count__15874;
var G__15896 = (i__15875 + (1));
seq__15872 = G__15893;
chunk__15873 = G__15894;
count__15874 = G__15895;
i__15875 = G__15896;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__15872);
if(temp__5720__auto__){
var seq__15872__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15872__$1)){
var c__10465__auto__ = cljs.core.chunk_first(seq__15872__$1);
var G__15897 = cljs.core.chunk_rest(seq__15872__$1);
var G__15898 = c__10465__auto__;
var G__15899 = cljs.core.count(c__10465__auto__);
var G__15900 = (0);
seq__15872 = G__15897;
chunk__15873 = G__15898;
count__15874 = G__15899;
i__15875 = G__15900;
continue;
} else {
var vec__15885 = cljs.core.first(seq__15872__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15885,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15885,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__15901 = cljs.core.next(seq__15872__$1);
var G__15902 = null;
var G__15903 = (0);
var G__15904 = (0);
seq__15872 = G__15901;
chunk__15873 = G__15902;
count__15874 = G__15903;
i__15875 = G__15904;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function cljs$core$fn_15888(this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function cljs$core$fn_15889(this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_15890(this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function cljs$core$fn_15891(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function cljs$core$fn_15892(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__15908 = arguments.length;
switch (G__15908) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15915 = arguments.length;
var i__10823__auto___15916 = (0);
while(true){
if((i__10823__auto___15916 < len__10822__auto___15915)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15916]));

var G__15917 = (i__10823__auto___15916 + (1));
i__10823__auto___15916 = G__15917;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10852__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15909(x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15911(x,p__15910){
var map__15912 = p__15910;
var map__15912__$1 = cljs.core.__destructure_map(map__15912);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15912__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15912__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function cljs$core$fn_15913(seq15906){
var G__15907 = cljs.core.first(seq15906);
var seq15906__$1 = cljs.core.next(seq15906);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15907,seq15906__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__15924 = arguments.length;
switch (G__15924) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15937 = arguments.length;
var i__10823__auto___15938 = (0);
while(true){
if((i__10823__auto___15938 < len__10822__auto___15937)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15938]));

var G__15939 = (i__10823__auto___15938 + (1));
i__10823__auto___15938 = G__15939;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15925(a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15926 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15926) : f.call(null,G__15926));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15927(a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15928 = a.state;
var G__15929 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15928,G__15929) : f.call(null,G__15928,G__15929));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15930(a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__15931 = a.state;
var G__15932 = x;
var G__15933 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15931,G__15932,G__15933) : f.call(null,G__15931,G__15932,G__15933));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15934(a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15935(seq15919){
var G__15920 = cljs.core.first(seq15919);
var seq15919__$1 = cljs.core.next(seq15919);
var G__15921 = cljs.core.first(seq15919__$1);
var seq15919__$2 = cljs.core.next(seq15919__$1);
var G__15922 = cljs.core.first(seq15919__$2);
var seq15919__$3 = cljs.core.next(seq15919__$2);
var G__15923 = cljs.core.first(seq15919__$3);
var seq15919__$4 = cljs.core.next(seq15919__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15920,G__15921,G__15922,G__15923,seq15919__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__15946 = arguments.length;
switch (G__15946) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___15959 = arguments.length;
var i__10823__auto___15960 = (0);
while(true){
if((i__10823__auto___15960 < len__10822__auto___15959)){
args_arr__10851__auto__.push((arguments[i__10823__auto___15960]));

var G__15961 = (i__10823__auto___15960 + (1));
i__10823__auto___15960 = G__15961;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15947(a,f){
return cljs.core.reset_vals_BANG_(a,(function (){var G__15948 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__15948) : f.call(null,G__15948));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_15949(a,f,x){
return cljs.core.reset_vals_BANG_(a,(function (){var G__15950 = a.state;
var G__15951 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15950,G__15951) : f.call(null,G__15950,G__15951));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_15952(a,f,x,y){
return cljs.core.reset_vals_BANG_(a,(function (){var G__15953 = a.state;
var G__15954 = x;
var G__15955 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__15953,G__15954,G__15955) : f.call(null,G__15953,G__15954,G__15955));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_15956(a,f,x,y,more){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function cljs$core$fn_15957(seq15941){
var G__15942 = cljs.core.first(seq15941);
var seq15941__$1 = cljs.core.next(seq15941);
var G__15943 = cljs.core.first(seq15941__$1);
var seq15941__$2 = cljs.core.next(seq15941__$1);
var G__15944 = cljs.core.first(seq15941__$2);
var seq15941__$3 = cljs.core.next(seq15941__$2);
var G__15945 = cljs.core.first(seq15941__$3);
var seq15941__$4 = cljs.core.next(seq15941__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15942,G__15943,G__15944,G__15945,seq15941__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__15962 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__15962) : val.call(null,G__15962));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function cljs$core$fn_15963(_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function cljs$core$fn_15964(_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function cljs$core$fn_15965(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function cljs$core$fn_15966(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__15968 = arguments.length;
switch (G__15968) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_15969(f){
return (function cljs$core$fn_15969_$_fn_15970(rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var cljs$core$fn_15969_$_fn_15970_$_fn_15971 = null;
var cljs$core$fn_15969_$_fn_15970_$_fn_15971__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_15969_$_fn_15970_$_fn_15971__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_15969_$_fn_15970_$_fn_15971__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
cljs$core$fn_15969_$_fn_15970_$_fn_15971 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_15969_$_fn_15970_$_fn_15971__0.call(this);
case 1:
return cljs$core$fn_15969_$_fn_15970_$_fn_15971__1.call(this,result);
case 2:
return cljs$core$fn_15969_$_fn_15970_$_fn_15971__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_15969_$_fn_15970_$_fn_15971.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_15969_$_fn_15970_$_fn_15971__0;
cljs$core$fn_15969_$_fn_15970_$_fn_15971.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_15969_$_fn_15970_$_fn_15971__1;
cljs$core$fn_15969_$_fn_15970_$_fn_15971.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_15969_$_fn_15970_$_fn_15971__2;
return cljs$core$fn_15969_$_fn_15970_$_fn_15971;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_15972(f,coll){
var keepi = (function cljs$core$fn_15972_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_15972_$_keepi_$_fn_15978(){
var temp__5720__auto__ = cljs.core.seq(coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10581__auto___15984 = size;
var i_15985 = (0);
while(true){
if((i_15985 < n__10581__auto___15984)){
var x_15986 = (function (){var G__15979 = (idx + i_15985);
var G__15980 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_15985);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15979,G__15980) : f.call(null,G__15979,G__15980));
})();
if((x_15986 == null)){
} else {
cljs.core.chunk_append(b,x_15986);
}

var G__15987 = (i_15985 + (1));
i_15985 = G__15987;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$fn_15972_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__15981 = idx;
var G__15982 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15981,G__15982) : f.call(null,G__15981,G__15982));
})();
if((x == null)){
return cljs$core$fn_15972_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$fn_15972_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__15999 = arguments.length;
switch (G__15999) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16012 = arguments.length;
var i__10823__auto___16013 = (0);
while(true){
if((i__10823__auto___16013 < len__10822__auto___16012)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16013]));

var G__16014 = (i__10823__auto___16013 + (1));
i__10823__auto___16013 = G__16014;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16000(p){
return (function() {
var cljs$core$fn_16000_$_ep1 = null;
var cljs$core$fn_16000_$_ep1__0 = (function (){
return true;
});
var cljs$core$fn_16000_$_ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$fn_16000_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16000_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16000_$_ep1__4 = (function() { 
var G__16015__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9487__auto__ = cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9487__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__9487__auto__;
}
})());
};
var G__16015 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16016__i = 0, G__16016__a = new Array(arguments.length -  3);
while (G__16016__i < G__16016__a.length) {G__16016__a[G__16016__i] = arguments[G__16016__i + 3]; ++G__16016__i;}
  args = new cljs.core.IndexedSeq(G__16016__a,0,null);
} 
return G__16015__delegate.call(this,x,y,z,args);};
G__16015.cljs$lang$maxFixedArity = 3;
G__16015.cljs$lang$applyTo = (function (arglist__16017){
var x = cljs.core.first(arglist__16017);
arglist__16017 = cljs.core.next(arglist__16017);
var y = cljs.core.first(arglist__16017);
arglist__16017 = cljs.core.next(arglist__16017);
var z = cljs.core.first(arglist__16017);
var args = cljs.core.rest(arglist__16017);
return G__16015__delegate(x,y,z,args);
});
G__16015.cljs$core$IFn$_invoke$arity$variadic = G__16015__delegate;
return G__16015;
})()
;
cljs$core$fn_16000_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16000_$_ep1__0.call(this);
case 1:
return cljs$core$fn_16000_$_ep1__1.call(this,x);
case 2:
return cljs$core$fn_16000_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$fn_16000_$_ep1__3.call(this,x,y,z);
default:
var G__16018 = null;
if (arguments.length > 3) {
var G__16019__i = 0, G__16019__a = new Array(arguments.length -  3);
while (G__16019__i < G__16019__a.length) {G__16019__a[G__16019__i] = arguments[G__16019__i + 3]; ++G__16019__i;}
G__16018 = new cljs.core.IndexedSeq(G__16019__a,0,null);
}
return cljs$core$fn_16000_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16000_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16000_$_ep1.cljs$lang$applyTo = cljs$core$fn_16000_$_ep1__4.cljs$lang$applyTo;
cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16000_$_ep1__0;
cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16000_$_ep1__1;
cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16000_$_ep1__2;
cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16000_$_ep1__3;
cljs$core$fn_16000_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16000_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16000_$_ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16001(p1,p2){
return (function() {
var cljs$core$fn_16001_$_ep2 = null;
var cljs$core$fn_16001_$_ep2__0 = (function (){
return true;
});
var cljs$core$fn_16001_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16001_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
var and__9487__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9487__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__9487__auto____$2;
}
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16001_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
var and__9487__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9487__auto____$2)){
var and__9487__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9487__auto____$3)){
var and__9487__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9487__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__9487__auto____$4;
}
} else {
return and__9487__auto____$3;
}
} else {
return and__9487__auto____$2;
}
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16001_$_ep2__4 = (function() { 
var G__16020__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9487__auto__ = cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9487__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16001_$_ep2_$_fn_16002(p1__15988_SHARP_){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__15988_SHARP_) : p1.call(null,p1__15988_SHARP_));
if(cljs.core.truth_(and__9487__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__15988_SHARP_) : p2.call(null,p1__15988_SHARP_));
} else {
return and__9487__auto____$1;
}
}),args);
} else {
return and__9487__auto__;
}
})());
};
var G__16020 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16021__i = 0, G__16021__a = new Array(arguments.length -  3);
while (G__16021__i < G__16021__a.length) {G__16021__a[G__16021__i] = arguments[G__16021__i + 3]; ++G__16021__i;}
  args = new cljs.core.IndexedSeq(G__16021__a,0,null);
} 
return G__16020__delegate.call(this,x,y,z,args);};
G__16020.cljs$lang$maxFixedArity = 3;
G__16020.cljs$lang$applyTo = (function (arglist__16022){
var x = cljs.core.first(arglist__16022);
arglist__16022 = cljs.core.next(arglist__16022);
var y = cljs.core.first(arglist__16022);
arglist__16022 = cljs.core.next(arglist__16022);
var z = cljs.core.first(arglist__16022);
var args = cljs.core.rest(arglist__16022);
return G__16020__delegate(x,y,z,args);
});
G__16020.cljs$core$IFn$_invoke$arity$variadic = G__16020__delegate;
return G__16020;
})()
;
cljs$core$fn_16001_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16001_$_ep2__0.call(this);
case 1:
return cljs$core$fn_16001_$_ep2__1.call(this,x);
case 2:
return cljs$core$fn_16001_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$fn_16001_$_ep2__3.call(this,x,y,z);
default:
var G__16023 = null;
if (arguments.length > 3) {
var G__16024__i = 0, G__16024__a = new Array(arguments.length -  3);
while (G__16024__i < G__16024__a.length) {G__16024__a[G__16024__i] = arguments[G__16024__i + 3]; ++G__16024__i;}
G__16023 = new cljs.core.IndexedSeq(G__16024__a,0,null);
}
return cljs$core$fn_16001_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16001_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16001_$_ep2.cljs$lang$applyTo = cljs$core$fn_16001_$_ep2__4.cljs$lang$applyTo;
cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16001_$_ep2__0;
cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16001_$_ep2__1;
cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16001_$_ep2__2;
cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16001_$_ep2__3;
cljs$core$fn_16001_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16001_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16001_$_ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16003(p1,p2,p3){
return (function() {
var cljs$core$fn_16003_$_ep3 = null;
var cljs$core$fn_16003_$_ep3__0 = (function (){
return true;
});
var cljs$core$fn_16003_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9487__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16003_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
var and__9487__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9487__auto____$2)){
var and__9487__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9487__auto____$3)){
var and__9487__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9487__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__9487__auto____$4;
}
} else {
return and__9487__auto____$3;
}
} else {
return and__9487__auto____$2;
}
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16003_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__9487__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
var and__9487__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__9487__auto____$2)){
var and__9487__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__9487__auto____$3)){
var and__9487__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__9487__auto____$4)){
var and__9487__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__9487__auto____$5)){
var and__9487__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__9487__auto____$6)){
var and__9487__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__9487__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__9487__auto____$7;
}
} else {
return and__9487__auto____$6;
}
} else {
return and__9487__auto____$5;
}
} else {
return and__9487__auto____$4;
}
} else {
return and__9487__auto____$3;
}
} else {
return and__9487__auto____$2;
}
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
})());
});
var cljs$core$fn_16003_$_ep3__4 = (function() { 
var G__16025__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9487__auto__ = cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9487__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16003_$_ep3_$_fn_16004(p1__15989_SHARP_){
var and__9487__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__15989_SHARP_) : p1.call(null,p1__15989_SHARP_));
if(cljs.core.truth_(and__9487__auto____$1)){
var and__9487__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__15989_SHARP_) : p2.call(null,p1__15989_SHARP_));
if(cljs.core.truth_(and__9487__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__15989_SHARP_) : p3.call(null,p1__15989_SHARP_));
} else {
return and__9487__auto____$2;
}
} else {
return and__9487__auto____$1;
}
}),args);
} else {
return and__9487__auto__;
}
})());
};
var G__16025 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16026__i = 0, G__16026__a = new Array(arguments.length -  3);
while (G__16026__i < G__16026__a.length) {G__16026__a[G__16026__i] = arguments[G__16026__i + 3]; ++G__16026__i;}
  args = new cljs.core.IndexedSeq(G__16026__a,0,null);
} 
return G__16025__delegate.call(this,x,y,z,args);};
G__16025.cljs$lang$maxFixedArity = 3;
G__16025.cljs$lang$applyTo = (function (arglist__16027){
var x = cljs.core.first(arglist__16027);
arglist__16027 = cljs.core.next(arglist__16027);
var y = cljs.core.first(arglist__16027);
arglist__16027 = cljs.core.next(arglist__16027);
var z = cljs.core.first(arglist__16027);
var args = cljs.core.rest(arglist__16027);
return G__16025__delegate(x,y,z,args);
});
G__16025.cljs$core$IFn$_invoke$arity$variadic = G__16025__delegate;
return G__16025;
})()
;
cljs$core$fn_16003_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16003_$_ep3__0.call(this);
case 1:
return cljs$core$fn_16003_$_ep3__1.call(this,x);
case 2:
return cljs$core$fn_16003_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$fn_16003_$_ep3__3.call(this,x,y,z);
default:
var G__16028 = null;
if (arguments.length > 3) {
var G__16029__i = 0, G__16029__a = new Array(arguments.length -  3);
while (G__16029__i < G__16029__a.length) {G__16029__a[G__16029__i] = arguments[G__16029__i + 3]; ++G__16029__i;}
G__16028 = new cljs.core.IndexedSeq(G__16029__a,0,null);
}
return cljs$core$fn_16003_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16003_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16003_$_ep3.cljs$lang$applyTo = cljs$core$fn_16003_$_ep3__4.cljs$lang$applyTo;
cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16003_$_ep3__0;
cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16003_$_ep3__1;
cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16003_$_ep3__2;
cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16003_$_ep3__3;
cljs$core$fn_16003_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16003_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16003_$_ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16005(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16005_$_epn = null;
var cljs$core$fn_16005_$_epn__0 = (function (){
return true;
});
var cljs$core$fn_16005_$_epn__1 = (function (x){
return cljs.core.every_QMARK_((function cljs$core$fn_16005_$_epn_$_fn_16006(p1__15990_SHARP_){
return (p1__15990_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15990_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__15990_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16005_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function cljs$core$fn_16005_$_epn_$_fn_16007(p1__15991_SHARP_){
var and__9487__auto__ = (p1__15991_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15991_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__15991_SHARP_.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
return (p1__15991_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15991_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__15991_SHARP_.call(null,y));
} else {
return and__9487__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16005_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function cljs$core$fn_16005_$_epn_$_fn_16008(p1__15992_SHARP_){
var and__9487__auto__ = (p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__15992_SHARP_.call(null,x));
if(cljs.core.truth_(and__9487__auto__)){
var and__9487__auto____$1 = (p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__15992_SHARP_.call(null,y));
if(cljs.core.truth_(and__9487__auto____$1)){
return (p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15992_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__15992_SHARP_.call(null,z));
} else {
return and__9487__auto____$1;
}
} else {
return and__9487__auto__;
}
}),ps__$1);
});
var cljs$core$fn_16005_$_epn__4 = (function() { 
var G__16030__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__9487__auto__ = cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__9487__auto__)){
return cljs.core.every_QMARK_((function cljs$core$fn_16005_$_epn_$_fn_16009(p1__15993_SHARP_){
return cljs.core.every_QMARK_(p1__15993_SHARP_,args);
}),ps__$1);
} else {
return and__9487__auto__;
}
})());
};
var G__16030 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16031__i = 0, G__16031__a = new Array(arguments.length -  3);
while (G__16031__i < G__16031__a.length) {G__16031__a[G__16031__i] = arguments[G__16031__i + 3]; ++G__16031__i;}
  args = new cljs.core.IndexedSeq(G__16031__a,0,null);
} 
return G__16030__delegate.call(this,x,y,z,args);};
G__16030.cljs$lang$maxFixedArity = 3;
G__16030.cljs$lang$applyTo = (function (arglist__16032){
var x = cljs.core.first(arglist__16032);
arglist__16032 = cljs.core.next(arglist__16032);
var y = cljs.core.first(arglist__16032);
arglist__16032 = cljs.core.next(arglist__16032);
var z = cljs.core.first(arglist__16032);
var args = cljs.core.rest(arglist__16032);
return G__16030__delegate(x,y,z,args);
});
G__16030.cljs$core$IFn$_invoke$arity$variadic = G__16030__delegate;
return G__16030;
})()
;
cljs$core$fn_16005_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16005_$_epn__0.call(this);
case 1:
return cljs$core$fn_16005_$_epn__1.call(this,x);
case 2:
return cljs$core$fn_16005_$_epn__2.call(this,x,y);
case 3:
return cljs$core$fn_16005_$_epn__3.call(this,x,y,z);
default:
var G__16033 = null;
if (arguments.length > 3) {
var G__16034__i = 0, G__16034__a = new Array(arguments.length -  3);
while (G__16034__i < G__16034__a.length) {G__16034__a[G__16034__i] = arguments[G__16034__i + 3]; ++G__16034__i;}
G__16033 = new cljs.core.IndexedSeq(G__16034__a,0,null);
}
return cljs$core$fn_16005_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16005_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16005_$_epn.cljs$lang$applyTo = cljs$core$fn_16005_$_epn__4.cljs$lang$applyTo;
cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16005_$_epn__0;
cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16005_$_epn__1;
cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16005_$_epn__2;
cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16005_$_epn__3;
cljs$core$fn_16005_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16005_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16005_$_epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function cljs$core$fn_16010(seq15995){
var G__15996 = cljs.core.first(seq15995);
var seq15995__$1 = cljs.core.next(seq15995);
var G__15997 = cljs.core.first(seq15995__$1);
var seq15995__$2 = cljs.core.next(seq15995__$1);
var G__15998 = cljs.core.first(seq15995__$2);
var seq15995__$3 = cljs.core.next(seq15995__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15996,G__15997,G__15998,seq15995__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__16046 = arguments.length;
switch (G__16046) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16059 = arguments.length;
var i__10823__auto___16060 = (0);
while(true){
if((i__10823__auto___16060 < len__10822__auto___16059)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16060]));

var G__16061 = (i__10823__auto___16060 + (1));
i__10823__auto___16060 = G__16061;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10852__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16047(p){
return (function() {
var cljs$core$fn_16047_$_sp1 = null;
var cljs$core$fn_16047_$_sp1__0 = (function (){
return null;
});
var cljs$core$fn_16047_$_sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$fn_16047_$_sp1__2 = (function (x,y){
var or__9493__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$fn_16047_$_sp1__3 = (function (x,y,z){
var or__9493__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$fn_16047_$_sp1__4 = (function() { 
var G__16062__delegate = function (x,y,z,args){
var or__9493__auto__ = cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__16062 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16063__i = 0, G__16063__a = new Array(arguments.length -  3);
while (G__16063__i < G__16063__a.length) {G__16063__a[G__16063__i] = arguments[G__16063__i + 3]; ++G__16063__i;}
  args = new cljs.core.IndexedSeq(G__16063__a,0,null);
} 
return G__16062__delegate.call(this,x,y,z,args);};
G__16062.cljs$lang$maxFixedArity = 3;
G__16062.cljs$lang$applyTo = (function (arglist__16064){
var x = cljs.core.first(arglist__16064);
arglist__16064 = cljs.core.next(arglist__16064);
var y = cljs.core.first(arglist__16064);
arglist__16064 = cljs.core.next(arglist__16064);
var z = cljs.core.first(arglist__16064);
var args = cljs.core.rest(arglist__16064);
return G__16062__delegate(x,y,z,args);
});
G__16062.cljs$core$IFn$_invoke$arity$variadic = G__16062__delegate;
return G__16062;
})()
;
cljs$core$fn_16047_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16047_$_sp1__0.call(this);
case 1:
return cljs$core$fn_16047_$_sp1__1.call(this,x);
case 2:
return cljs$core$fn_16047_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$fn_16047_$_sp1__3.call(this,x,y,z);
default:
var G__16065 = null;
if (arguments.length > 3) {
var G__16066__i = 0, G__16066__a = new Array(arguments.length -  3);
while (G__16066__i < G__16066__a.length) {G__16066__a[G__16066__i] = arguments[G__16066__i + 3]; ++G__16066__i;}
G__16065 = new cljs.core.IndexedSeq(G__16066__a,0,null);
}
return cljs$core$fn_16047_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16047_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16047_$_sp1.cljs$lang$applyTo = cljs$core$fn_16047_$_sp1__4.cljs$lang$applyTo;
cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16047_$_sp1__0;
cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16047_$_sp1__1;
cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16047_$_sp1__2;
cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16047_$_sp1__3;
cljs$core$fn_16047_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16047_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16047_$_sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16048(p1,p2){
return (function() {
var cljs$core$fn_16048_$_sp2 = null;
var cljs$core$fn_16048_$_sp2__0 = (function (){
return null;
});
var cljs$core$fn_16048_$_sp2__1 = (function (x){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$fn_16048_$_sp2__2 = (function (x,y){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
var or__9493__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9493__auto____$2)){
return or__9493__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$fn_16048_$_sp2__3 = (function (x,y,z){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
var or__9493__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9493__auto____$2)){
return or__9493__auto____$2;
} else {
var or__9493__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9493__auto____$3)){
return or__9493__auto____$3;
} else {
var or__9493__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9493__auto____$4)){
return or__9493__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$fn_16048_$_sp2__4 = (function() { 
var G__16067__delegate = function (x,y,z,args){
var or__9493__auto__ = cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16048_$_sp2_$_fn_16049(p1__16035_SHARP_){
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16035_SHARP_) : p1.call(null,p1__16035_SHARP_));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16035_SHARP_) : p2.call(null,p1__16035_SHARP_));
}
}),args);
}
};
var G__16067 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16068__i = 0, G__16068__a = new Array(arguments.length -  3);
while (G__16068__i < G__16068__a.length) {G__16068__a[G__16068__i] = arguments[G__16068__i + 3]; ++G__16068__i;}
  args = new cljs.core.IndexedSeq(G__16068__a,0,null);
} 
return G__16067__delegate.call(this,x,y,z,args);};
G__16067.cljs$lang$maxFixedArity = 3;
G__16067.cljs$lang$applyTo = (function (arglist__16069){
var x = cljs.core.first(arglist__16069);
arglist__16069 = cljs.core.next(arglist__16069);
var y = cljs.core.first(arglist__16069);
arglist__16069 = cljs.core.next(arglist__16069);
var z = cljs.core.first(arglist__16069);
var args = cljs.core.rest(arglist__16069);
return G__16067__delegate(x,y,z,args);
});
G__16067.cljs$core$IFn$_invoke$arity$variadic = G__16067__delegate;
return G__16067;
})()
;
cljs$core$fn_16048_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16048_$_sp2__0.call(this);
case 1:
return cljs$core$fn_16048_$_sp2__1.call(this,x);
case 2:
return cljs$core$fn_16048_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$fn_16048_$_sp2__3.call(this,x,y,z);
default:
var G__16070 = null;
if (arguments.length > 3) {
var G__16071__i = 0, G__16071__a = new Array(arguments.length -  3);
while (G__16071__i < G__16071__a.length) {G__16071__a[G__16071__i] = arguments[G__16071__i + 3]; ++G__16071__i;}
G__16070 = new cljs.core.IndexedSeq(G__16071__a,0,null);
}
return cljs$core$fn_16048_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16048_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16048_$_sp2.cljs$lang$applyTo = cljs$core$fn_16048_$_sp2__4.cljs$lang$applyTo;
cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16048_$_sp2__0;
cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16048_$_sp2__1;
cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16048_$_sp2__2;
cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16048_$_sp2__3;
cljs$core$fn_16048_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16048_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16048_$_sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16050(p1,p2,p3){
return (function() {
var cljs$core$fn_16050_$_sp3 = null;
var cljs$core$fn_16050_$_sp3__0 = (function (){
return null;
});
var cljs$core$fn_16050_$_sp3__1 = (function (x){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$fn_16050_$_sp3__2 = (function (x,y){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
var or__9493__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9493__auto____$2)){
return or__9493__auto____$2;
} else {
var or__9493__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9493__auto____$3)){
return or__9493__auto____$3;
} else {
var or__9493__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9493__auto____$4)){
return or__9493__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$fn_16050_$_sp3__3 = (function (x,y,z){
var or__9493__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
var or__9493__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__9493__auto____$2)){
return or__9493__auto____$2;
} else {
var or__9493__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__9493__auto____$3)){
return or__9493__auto____$3;
} else {
var or__9493__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__9493__auto____$4)){
return or__9493__auto____$4;
} else {
var or__9493__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__9493__auto____$5)){
return or__9493__auto____$5;
} else {
var or__9493__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__9493__auto____$6)){
return or__9493__auto____$6;
} else {
var or__9493__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__9493__auto____$7)){
return or__9493__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$fn_16050_$_sp3__4 = (function() { 
var G__16072__delegate = function (x,y,z,args){
var or__9493__auto__ = cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16050_$_sp3_$_fn_16051(p1__16036_SHARP_){
var or__9493__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__16036_SHARP_) : p1.call(null,p1__16036_SHARP_));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
var or__9493__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__16036_SHARP_) : p2.call(null,p1__16036_SHARP_));
if(cljs.core.truth_(or__9493__auto____$2)){
return or__9493__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__16036_SHARP_) : p3.call(null,p1__16036_SHARP_));
}
}
}),args);
}
};
var G__16072 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16073__i = 0, G__16073__a = new Array(arguments.length -  3);
while (G__16073__i < G__16073__a.length) {G__16073__a[G__16073__i] = arguments[G__16073__i + 3]; ++G__16073__i;}
  args = new cljs.core.IndexedSeq(G__16073__a,0,null);
} 
return G__16072__delegate.call(this,x,y,z,args);};
G__16072.cljs$lang$maxFixedArity = 3;
G__16072.cljs$lang$applyTo = (function (arglist__16074){
var x = cljs.core.first(arglist__16074);
arglist__16074 = cljs.core.next(arglist__16074);
var y = cljs.core.first(arglist__16074);
arglist__16074 = cljs.core.next(arglist__16074);
var z = cljs.core.first(arglist__16074);
var args = cljs.core.rest(arglist__16074);
return G__16072__delegate(x,y,z,args);
});
G__16072.cljs$core$IFn$_invoke$arity$variadic = G__16072__delegate;
return G__16072;
})()
;
cljs$core$fn_16050_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16050_$_sp3__0.call(this);
case 1:
return cljs$core$fn_16050_$_sp3__1.call(this,x);
case 2:
return cljs$core$fn_16050_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$fn_16050_$_sp3__3.call(this,x,y,z);
default:
var G__16075 = null;
if (arguments.length > 3) {
var G__16076__i = 0, G__16076__a = new Array(arguments.length -  3);
while (G__16076__i < G__16076__a.length) {G__16076__a[G__16076__i] = arguments[G__16076__i + 3]; ++G__16076__i;}
G__16075 = new cljs.core.IndexedSeq(G__16076__a,0,null);
}
return cljs$core$fn_16050_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16050_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16050_$_sp3.cljs$lang$applyTo = cljs$core$fn_16050_$_sp3__4.cljs$lang$applyTo;
cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16050_$_sp3__0;
cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16050_$_sp3__1;
cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16050_$_sp3__2;
cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16050_$_sp3__3;
cljs$core$fn_16050_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16050_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16050_$_sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16052(p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$fn_16052_$_spn = null;
var cljs$core$fn_16052_$_spn__0 = (function (){
return null;
});
var cljs$core$fn_16052_$_spn__1 = (function (x){
return cljs.core.some((function cljs$core$fn_16052_$_spn_$_fn_16053(p1__16037_SHARP_){
return (p1__16037_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16037_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16037_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$fn_16052_$_spn__2 = (function (x,y){
return cljs.core.some((function cljs$core$fn_16052_$_spn_$_fn_16054(p1__16038_SHARP_){
var or__9493__auto__ = (p1__16038_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16038_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16038_SHARP_.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return (p1__16038_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16038_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16038_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$fn_16052_$_spn__3 = (function (x,y,z){
return cljs.core.some((function cljs$core$fn_16052_$_spn_$_fn_16055(p1__16039_SHARP_){
var or__9493__auto__ = (p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__16039_SHARP_.call(null,x));
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__16039_SHARP_.call(null,y));
if(cljs.core.truth_(or__9493__auto____$1)){
return or__9493__auto____$1;
} else {
return (p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16039_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__16039_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$fn_16052_$_spn__4 = (function() { 
var G__16077__delegate = function (x,y,z,args){
var or__9493__auto__ = cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.some((function cljs$core$fn_16052_$_spn_$_fn_16056(p1__16040_SHARP_){
return cljs.core.some(p1__16040_SHARP_,args);
}),ps__$1);
}
};
var G__16077 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__16078__i = 0, G__16078__a = new Array(arguments.length -  3);
while (G__16078__i < G__16078__a.length) {G__16078__a[G__16078__i] = arguments[G__16078__i + 3]; ++G__16078__i;}
  args = new cljs.core.IndexedSeq(G__16078__a,0,null);
} 
return G__16077__delegate.call(this,x,y,z,args);};
G__16077.cljs$lang$maxFixedArity = 3;
G__16077.cljs$lang$applyTo = (function (arglist__16079){
var x = cljs.core.first(arglist__16079);
arglist__16079 = cljs.core.next(arglist__16079);
var y = cljs.core.first(arglist__16079);
arglist__16079 = cljs.core.next(arglist__16079);
var z = cljs.core.first(arglist__16079);
var args = cljs.core.rest(arglist__16079);
return G__16077__delegate(x,y,z,args);
});
G__16077.cljs$core$IFn$_invoke$arity$variadic = G__16077__delegate;
return G__16077;
})()
;
cljs$core$fn_16052_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16052_$_spn__0.call(this);
case 1:
return cljs$core$fn_16052_$_spn__1.call(this,x);
case 2:
return cljs$core$fn_16052_$_spn__2.call(this,x,y);
case 3:
return cljs$core$fn_16052_$_spn__3.call(this,x,y,z);
default:
var G__16080 = null;
if (arguments.length > 3) {
var G__16081__i = 0, G__16081__a = new Array(arguments.length -  3);
while (G__16081__i < G__16081__a.length) {G__16081__a[G__16081__i] = arguments[G__16081__i + 3]; ++G__16081__i;}
G__16080 = new cljs.core.IndexedSeq(G__16081__a,0,null);
}
return cljs$core$fn_16052_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__16080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16052_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$fn_16052_$_spn.cljs$lang$applyTo = cljs$core$fn_16052_$_spn__4.cljs$lang$applyTo;
cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16052_$_spn__0;
cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16052_$_spn__1;
cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16052_$_spn__2;
cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16052_$_spn__3;
cljs$core$fn_16052_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16052_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16052_$_spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function cljs$core$fn_16057(seq16042){
var G__16043 = cljs.core.first(seq16042);
var seq16042__$1 = cljs.core.next(seq16042);
var G__16044 = cljs.core.first(seq16042__$1);
var seq16042__$2 = cljs.core.next(seq16042__$1);
var G__16045 = cljs.core.first(seq16042__$2);
var seq16042__$3 = cljs.core.next(seq16042__$2);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16043,G__16044,G__16045,seq16042__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__16089 = arguments.length;
switch (G__16089) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16115 = arguments.length;
var i__10823__auto___16116 = (0);
while(true){
if((i__10823__auto___16116 < len__10822__auto___16115)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16116]));

var G__16117 = (i__10823__auto___16116 + (1));
i__10823__auto___16116 = G__16117;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16090(f){
return (function cljs$core$fn_16090_$_fn_16091(rf){
return (function() {
var cljs$core$fn_16090_$_fn_16091_$_fn_16092 = null;
var cljs$core$fn_16090_$_fn_16091_$_fn_16092__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16090_$_fn_16091_$_fn_16092__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16090_$_fn_16091_$_fn_16092__2 = (function (result,input){
var G__16093 = result;
var G__16094 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16093,G__16094) : rf.call(null,G__16093,G__16094));
});
var cljs$core$fn_16090_$_fn_16091_$_fn_16092__3 = (function() { 
var G__16118__delegate = function (result,input,inputs){
var G__16095 = result;
var G__16096 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__16095,G__16096) : rf.call(null,G__16095,G__16096));
};
var G__16118 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__16119__i = 0, G__16119__a = new Array(arguments.length -  2);
while (G__16119__i < G__16119__a.length) {G__16119__a[G__16119__i] = arguments[G__16119__i + 2]; ++G__16119__i;}
  inputs = new cljs.core.IndexedSeq(G__16119__a,0,null);
} 
return G__16118__delegate.call(this,result,input,inputs);};
G__16118.cljs$lang$maxFixedArity = 2;
G__16118.cljs$lang$applyTo = (function (arglist__16120){
var result = cljs.core.first(arglist__16120);
arglist__16120 = cljs.core.next(arglist__16120);
var input = cljs.core.first(arglist__16120);
var inputs = cljs.core.rest(arglist__16120);
return G__16118__delegate(result,input,inputs);
});
G__16118.cljs$core$IFn$_invoke$arity$variadic = G__16118__delegate;
return G__16118;
})()
;
cljs$core$fn_16090_$_fn_16091_$_fn_16092 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return cljs$core$fn_16090_$_fn_16091_$_fn_16092__0.call(this);
case 1:
return cljs$core$fn_16090_$_fn_16091_$_fn_16092__1.call(this,result);
case 2:
return cljs$core$fn_16090_$_fn_16091_$_fn_16092__2.call(this,result,input);
default:
var G__16121 = null;
if (arguments.length > 2) {
var G__16122__i = 0, G__16122__a = new Array(arguments.length -  2);
while (G__16122__i < G__16122__a.length) {G__16122__a[G__16122__i] = arguments[G__16122__i + 2]; ++G__16122__i;}
G__16121 = new cljs.core.IndexedSeq(G__16122__a,0,null);
}
return cljs$core$fn_16090_$_fn_16091_$_fn_16092__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__16121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$lang$maxFixedArity = 2;
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$lang$applyTo = cljs$core$fn_16090_$_fn_16091_$_fn_16092__3.cljs$lang$applyTo;
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16090_$_fn_16091_$_fn_16092__0;
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16090_$_fn_16091_$_fn_16092__1;
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16090_$_fn_16091_$_fn_16092__2;
cljs$core$fn_16090_$_fn_16091_$_fn_16092.cljs$core$IFn$_invoke$arity$variadic = cljs$core$fn_16090_$_fn_16091_$_fn_16092__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$fn_16090_$_fn_16091_$_fn_16092;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16097(f,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16097_$_fn_16098(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10581__auto___16123 = size;
var i_16124 = (0);
while(true){
if((i_16124 < n__10581__auto___16123)){
cljs.core.chunk_append(b,(function (){var G__16099 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16124);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16099) : f.call(null,G__16099));
})());

var G__16125 = (i_16124 + (1));
i_16124 = G__16125;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__16100 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16100) : f.call(null,G__16100));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16101(f,c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16101_$_fn_16102(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__16103 = cljs.core.first(s1);
var G__16104 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16103,G__16104) : f.call(null,G__16103,G__16104));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16105(f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16105_$_fn_16106(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__16107 = cljs.core.first(s1);
var G__16108 = cljs.core.first(s2);
var G__16109 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16107,G__16108,G__16109) : f.call(null,G__16107,G__16108,G__16109));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16110(f,c1,c2,c3,colls){
var step = (function cljs$core$fn_16110_$_step(cs){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16110_$_step_$_fn_16111(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$fn_16110_$_step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16110_$_fn_16112(p1__16082_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__16082_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function cljs$core$fn_16113(seq16084){
var G__16085 = cljs.core.first(seq16084);
var seq16084__$1 = cljs.core.next(seq16084);
var G__16086 = cljs.core.first(seq16084__$1);
var seq16084__$2 = cljs.core.next(seq16084__$1);
var G__16087 = cljs.core.first(seq16084__$2);
var seq16084__$3 = cljs.core.next(seq16084__$2);
var G__16088 = cljs.core.first(seq16084__$3);
var seq16084__$4 = cljs.core.next(seq16084__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16085,G__16086,G__16087,G__16088,seq16084__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__16127 = arguments.length;
switch (G__16127) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16128(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16128_$_fn_16129(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16128_$_fn_16129_$_fn_16130 = null;
var cljs$core$fn_16128_$_fn_16129_$_fn_16130__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16128_$_fn_16129_$_fn_16130__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16128_$_fn_16129_$_fn_16130__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
cljs$core$fn_16128_$_fn_16129_$_fn_16130 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16128_$_fn_16129_$_fn_16130__0.call(this);
case 1:
return cljs$core$fn_16128_$_fn_16129_$_fn_16130__1.call(this,result);
case 2:
return cljs$core$fn_16128_$_fn_16129_$_fn_16130__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16128_$_fn_16129_$_fn_16130.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16128_$_fn_16129_$_fn_16130__0;
cljs$core$fn_16128_$_fn_16129_$_fn_16130.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16128_$_fn_16129_$_fn_16130__1;
cljs$core$fn_16128_$_fn_16129_$_fn_16130.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16128_$_fn_16129_$_fn_16130__2;
return cljs$core$fn_16128_$_fn_16129_$_fn_16130;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16131(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function cljs$core$fn_16131_$_fn_16132(){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__16135 = arguments.length;
switch (G__16135) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16136(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function cljs$core$fn_16136_$_fn_16137(rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var cljs$core$fn_16136_$_fn_16137_$_fn_16138 = null;
var cljs$core$fn_16136_$_fn_16137_$_fn_16138__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16136_$_fn_16137_$_fn_16138__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16136_$_fn_16137_$_fn_16138__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16136_$_fn_16137_$_fn_16138 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16136_$_fn_16137_$_fn_16138__0.call(this);
case 1:
return cljs$core$fn_16136_$_fn_16137_$_fn_16138__1.call(this,result);
case 2:
return cljs$core$fn_16136_$_fn_16137_$_fn_16138__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16136_$_fn_16137_$_fn_16138.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16136_$_fn_16137_$_fn_16138__0;
cljs$core$fn_16136_$_fn_16137_$_fn_16138.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16136_$_fn_16137_$_fn_16138__1;
cljs$core$fn_16136_$_fn_16137_$_fn_16138.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16136_$_fn_16137_$_fn_16138__2;
return cljs$core$fn_16136_$_fn_16137_$_fn_16138;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16139(n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function cljs$core$fn_16139_$_fn_16140(n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__16143 = (n__$1 - (1));
var G__16144 = cljs.core.rest(s);
n__$1 = G__16143;
coll__$1 = G__16144;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16139_$_fn_16141(){
return step(n,coll);
}),null,null));
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__16146 = arguments.length;
switch (G__16146) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16147(s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16148(n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16148_$_fn_16149(x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__16151 = cljs.core.next(s);
var G__16152 = cljs.core.next(lead);
s = G__16151;
lead = G__16152;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__16154 = arguments.length;
switch (G__16154) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16155(pred){
return (function cljs$core$fn_16155_$_fn_16156(rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var cljs$core$fn_16155_$_fn_16156_$_fn_16157 = null;
var cljs$core$fn_16155_$_fn_16156_$_fn_16157__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16155_$_fn_16156_$_fn_16157__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16155_$_fn_16156_$_fn_16157__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__9487__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__9487__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__9487__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16155_$_fn_16156_$_fn_16157 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16155_$_fn_16156_$_fn_16157__0.call(this);
case 1:
return cljs$core$fn_16155_$_fn_16156_$_fn_16157__1.call(this,result);
case 2:
return cljs$core$fn_16155_$_fn_16156_$_fn_16157__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16155_$_fn_16156_$_fn_16157.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16155_$_fn_16156_$_fn_16157__0;
cljs$core$fn_16155_$_fn_16156_$_fn_16157.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16155_$_fn_16156_$_fn_16157__1;
cljs$core$fn_16155_$_fn_16156_$_fn_16157.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16155_$_fn_16156_$_fn_16157__2;
return cljs$core$fn_16155_$_fn_16156_$_fn_16157;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16158(pred,coll){
var step = (function cljs$core$fn_16158_$_fn_16159(pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__9487__auto__ = s;
if(and__9487__auto__){
var G__16160 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__16160) : pred__$1.call(null,G__16160));
} else {
return and__9487__auto__;
}
})())){
var G__16163 = pred__$1;
var G__16164 = cljs.core.rest(s);
pred__$1 = G__16163;
coll__$1 = G__16164;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16158_$_fn_16161(){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function cljs$core$fn_16165(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function cljs$core$fn_16166(){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___16186 = cljs.core.next(self__.prev);
if(temp__5718__auto___16186){
var c_16187 = temp__5718__auto___16186;
(self__.current = c_16187);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16167(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16168(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16169(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16170(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16171(coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__9493__auto__ = cljs.core.next(s);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__16174 = ret;
var G__16175 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16174,G__16175) : f.call(null,G__16174,G__16175));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16188 = s__$1;
var G__16189 = ret__$1;
s = G__16188;
ret = G__16189;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16176(coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__16177 = ret;
var G__16178 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16177,G__16178) : f.call(null,G__16177,G__16178));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16190 = (function (){var or__9493__auto__ = cljs.core.next(s);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return self__.all;
}
})();
var G__16191 = ret__$1;
s = G__16190;
ret = G__16191;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16179(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16180(coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16181(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16182(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16183(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function cljs$core$fn_16184(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function cljs$core$fn_16185(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Repeat.prototype.toString = (function cljs$core$fn_16192(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function cljs$core$fn_16193(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var cljs$core$fn_16194 = null;
var cljs$core$fn_16194__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16194__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16194 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16194__1.call(this,x);
case 2:
return cljs$core$fn_16194__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16194.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16194__1;
cljs$core$fn_16194.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16194__2;
return cljs$core$fn_16194;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var cljs$core$fn_16195 = null;
var cljs$core$fn_16195__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var cljs$core$fn_16195__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16195 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16195__1.call(this,x);
case 2:
return cljs$core$fn_16195__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16195.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16195__1;
cljs$core$fn_16195.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16195__2;
return cljs$core$fn_16195;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16196(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16197(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16198(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16199(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16200(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16201(coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16202(coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16211 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16211;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16212 = (i + (1));
var G__16213 = ret__$1;
i = G__16212;
ret = G__16213;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16203(coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__16214 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__16214;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__16215 = (i + (1));
var G__16216 = ret__$1;
i = G__16215;
ret = G__16216;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16204(coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16205(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16206(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16207(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16208(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.getBasis = (function cljs$core$fn_16209(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function cljs$core$fn_16210(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__16218 = arguments.length;
switch (G__16218) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16219(x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16220(n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__16223 = arguments.length;
switch (G__16223) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16224(f){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16224_$_fn_16225(){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16226(n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function cljs$core$fn_16228(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16229(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16230(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16231(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function cljs$core$fn_16232(coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16233(coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16242 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16243 = v__$2;
ret = G__16242;
v__$1 = G__16243;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16234(coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__16244 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__16245 = v__$2;
ret = G__16244;
v__$1 = G__16245;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16235(coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16236(coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16237(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16238(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16239(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function cljs$core$fn_16240(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function cljs$core$fn_16241(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__16250 = arguments.length;
switch (G__16250) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16260 = arguments.length;
var i__10823__auto___16261 = (0);
while(true){
if((i__10823__auto___16261 < len__10822__auto___16260)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16261]));

var G__16262 = (i__10823__auto___16261 + (1));
i__10823__auto___16261 = G__16262;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10852__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16251(){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16252(c1){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16252_$_fn_16253(){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16254(c1,c2){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16254_$_fn_16255(){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16256(c1,c2,colls){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16256_$_fn_16257(){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function cljs$core$fn_16258(seq16247){
var G__16248 = cljs.core.first(seq16247);
var seq16247__$1 = cljs.core.next(seq16247);
var G__16249 = cljs.core.first(seq16247__$1);
var seq16247__$2 = cljs.core.next(seq16247__$1);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16248,G__16249,seq16247__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__16264 = arguments.length;
switch (G__16264) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16265(sep){
return (function cljs$core$fn_16265_$_fn_16266(rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var cljs$core$fn_16265_$_fn_16266_$_fn_16267 = null;
var cljs$core$fn_16265_$_fn_16266_$_fn_16267__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16265_$_fn_16266_$_fn_16267__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16265_$_fn_16266_$_fn_16267__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
cljs$core$fn_16265_$_fn_16266_$_fn_16267 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16265_$_fn_16266_$_fn_16267__0.call(this);
case 1:
return cljs$core$fn_16265_$_fn_16266_$_fn_16267__1.call(this,result);
case 2:
return cljs$core$fn_16265_$_fn_16266_$_fn_16267__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16265_$_fn_16266_$_fn_16267.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16265_$_fn_16266_$_fn_16267__0;
cljs$core$fn_16265_$_fn_16266_$_fn_16267.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16265_$_fn_16266_$_fn_16267__1;
cljs$core$fn_16265_$_fn_16266_$_fn_16267.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16265_$_fn_16266_$_fn_16267__2;
return cljs$core$fn_16265_$_fn_16266_$_fn_16267;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16268(sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function cljs$core$flatten1_$_cat_$_fn_16270(){
var temp__5718__auto__ = cljs.core.seq(coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__16274 = arguments.length;
switch (G__16274) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16279 = arguments.length;
var i__10823__auto___16280 = (0);
while(true){
if((i__10823__auto___16280 < len__10822__auto___16279)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16280]));

var G__16281 = (i__10823__auto___16280 + (1));
i__10823__auto___16280 = G__16281;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10852__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16275(f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16276(f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function cljs$core$fn_16277(seq16272){
var G__16273 = cljs.core.first(seq16272);
var seq16272__$1 = cljs.core.next(seq16272);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16273,seq16272__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__16283 = arguments.length;
switch (G__16283) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16284(pred){
return (function cljs$core$fn_16284_$_fn_16285(rf){
return (function() {
var cljs$core$fn_16284_$_fn_16285_$_fn_16286 = null;
var cljs$core$fn_16284_$_fn_16285_$_fn_16286__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var cljs$core$fn_16284_$_fn_16285_$_fn_16286__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var cljs$core$fn_16284_$_fn_16285_$_fn_16286__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
cljs$core$fn_16284_$_fn_16285_$_fn_16286 = function(result,input){
switch(arguments.length){
case 0:
return cljs$core$fn_16284_$_fn_16285_$_fn_16286__0.call(this);
case 1:
return cljs$core$fn_16284_$_fn_16285_$_fn_16286__1.call(this,result);
case 2:
return cljs$core$fn_16284_$_fn_16285_$_fn_16286__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16284_$_fn_16285_$_fn_16286.cljs$core$IFn$_invoke$arity$0 = cljs$core$fn_16284_$_fn_16285_$_fn_16286__0;
cljs$core$fn_16284_$_fn_16285_$_fn_16286.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16284_$_fn_16285_$_fn_16286__1;
cljs$core$fn_16284_$_fn_16285_$_fn_16286.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16284_$_fn_16285_$_fn_16286__2;
return cljs$core$fn_16284_$_fn_16285_$_fn_16286;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16287(pred,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16287_$_fn_16288(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__10581__auto___16291 = size;
var i_16292 = (0);
while(true){
if((i_16292 < n__10581__auto___16291)){
if(cljs.core.truth_((function (){var G__16289 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16292);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__16289) : pred.call(null,G__16289));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_16292));
} else {
}

var G__16293 = (i_16292 + (1));
i_16292 = G__16293;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__16295 = arguments.length;
switch (G__16295) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16296(pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16297(pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function cljs$core$tree_seq_$_walk_$_fn_16299(){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function cljs$core$flatten_$_fn_16301(p1__16300_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__16300_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__16303 = arguments.length;
switch (G__16303) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function cljs$core$fn_16304(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16305(to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16306(to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16308(to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var cljs$core$fn_16308_$_fn_16310 = null;
var cljs$core$fn_16308_$_fn_16310__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var cljs$core$fn_16308_$_fn_16310__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
cljs$core$fn_16308_$_fn_16310 = function(coll,v){
switch(arguments.length){
case 1:
return cljs$core$fn_16308_$_fn_16310__1.call(this,coll);
case 2:
return cljs$core$fn_16308_$_fn_16310__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16308_$_fn_16310.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16308_$_fn_16310__1;
cljs$core$fn_16308_$_fn_16310.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16308_$_fn_16310__2;
return cljs$core$fn_16308_$_fn_16310;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__16318 = arguments.length;
switch (G__16318) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16326 = arguments.length;
var i__10823__auto___16327 = (0);
while(true){
if((i__10823__auto___16327 < len__10822__auto___16326)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16327]));

var G__16328 = (i__10823__auto___16327 + (1));
i__10823__auto___16327 = G__16328;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__10852__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16319(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$fn_16319_$_fn_16320(v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16321(f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16322(f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16323(f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function cljs$core$fn_16324(seq16313){
var G__16314 = cljs.core.first(seq16313);
var seq16313__$1 = cljs.core.next(seq16313);
var G__16315 = cljs.core.first(seq16313__$1);
var seq16313__$2 = cljs.core.next(seq16313__$1);
var G__16316 = cljs.core.first(seq16313__$2);
var seq16313__$3 = cljs.core.next(seq16313__$2);
var G__16317 = cljs.core.first(seq16313__$3);
var seq16313__$4 = cljs.core.next(seq16313__$3);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16314,G__16315,G__16316,G__16317,seq16313__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function cljs$core$filterv_$_fn_16329(v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__16331 = arguments.length;
switch (G__16331) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16332(n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16333(n,step,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16333_$_fn_16334(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16335(n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function cljs$core$fn_16335_$_fn_16336(){
var temp__5720__auto__ = cljs.core.seq(coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__16339 = arguments.length;
switch (G__16339) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16340(m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16341(m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__16343 = sentinel;
var G__16344 = m__$2;
var G__16345 = cljs.core.next(ks__$1);
sentinel = G__16343;
m__$1 = G__16344;
ks__$1 = G__16345;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__16346,v){
var vec__16347 = p__16346;
var seq__16348 = cljs.core.seq(vec__16347);
var first__16349 = cljs.core.first(seq__16348);
var seq__16348__$1 = cljs.core.next(seq__16348);
var k = first__16349;
var ks = seq__16348__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16350 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16351 = ks;
var G__16352 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__16350,G__16351,G__16352) : cljs.core.assoc_in.call(null,G__16350,G__16351,G__16352));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__16361 = arguments.length;
switch (G__16361) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16399 = arguments.length;
var i__10823__auto___16400 = (0);
while(true){
if((i__10823__auto___16400 < len__10822__auto___16399)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16400]));

var G__16401 = (i__10823__auto___16400 + (1));
i__10823__auto___16400 = G__16401;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10852__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16363(m,p__16362,f){
var vec__16364 = p__16362;
var seq__16365 = cljs.core.seq(vec__16364);
var first__16366 = cljs.core.first(seq__16365);
var seq__16365__$1 = cljs.core.next(seq__16365);
var k = first__16366;
var ks = seq__16365__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16367) : f.call(null,G__16367));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16369(m,p__16368,f,a){
var vec__16370 = p__16368;
var seq__16371 = cljs.core.seq(vec__16370);
var first__16372 = cljs.core.first(seq__16371);
var seq__16371__$1 = cljs.core.next(seq__16371);
var k = first__16372;
var ks = seq__16371__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16374 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16373,G__16374) : f.call(null,G__16373,G__16374));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16376(m,p__16375,f,a,b){
var vec__16377 = p__16375;
var seq__16378 = cljs.core.seq(vec__16377);
var first__16379 = cljs.core.first(seq__16378);
var seq__16378__$1 = cljs.core.next(seq__16378);
var k = first__16379;
var ks = seq__16378__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16381 = a;
var G__16382 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16380,G__16381,G__16382) : f.call(null,G__16380,G__16381,G__16382));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16384(m,p__16383,f,a,b,c){
var vec__16385 = p__16383;
var seq__16386 = cljs.core.seq(vec__16385);
var first__16387 = cljs.core.first(seq__16386);
var seq__16386__$1 = cljs.core.next(seq__16386);
var k = first__16387;
var ks = seq__16386__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16389 = a;
var G__16390 = b;
var G__16391 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16388,G__16389,G__16390,G__16391) : f.call(null,G__16388,G__16389,G__16390,G__16391));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16393(m,p__16392,f,a,b,c,args){
var vec__16394 = p__16392;
var seq__16395 = cljs.core.seq(vec__16394);
var first__16396 = cljs.core.first(seq__16395);
var seq__16395__$1 = cljs.core.next(seq__16395);
var k = first__16396;
var ks = seq__16395__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function cljs$core$fn_16397(seq16354){
var G__16355 = cljs.core.first(seq16354);
var seq16354__$1 = cljs.core.next(seq16354);
var G__16356 = cljs.core.first(seq16354__$1);
var seq16354__$2 = cljs.core.next(seq16354__$1);
var G__16357 = cljs.core.first(seq16354__$2);
var seq16354__$3 = cljs.core.next(seq16354__$2);
var G__16358 = cljs.core.first(seq16354__$3);
var seq16354__$4 = cljs.core.next(seq16354__$3);
var G__16359 = cljs.core.first(seq16354__$4);
var seq16354__$5 = cljs.core.next(seq16354__$4);
var G__16360 = cljs.core.first(seq16354__$5);
var seq16354__$6 = cljs.core.next(seq16354__$5);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16355,G__16356,G__16357,G__16358,G__16359,G__16360,seq16354__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__16410 = arguments.length;
switch (G__16410) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__10851__auto__ = [];
var len__10822__auto___16428 = arguments.length;
var i__10823__auto___16429 = (0);
while(true){
if((i__10823__auto___16429 < len__10822__auto___16428)){
args_arr__10851__auto__.push((arguments[i__10823__auto___16429]));

var G__16430 = (i__10823__auto___16429 + (1));
i__10823__auto___16429 = G__16430;
continue;
} else {
}
break;
}

var argseq__10852__auto__ = (new cljs.core.IndexedSeq(args_arr__10851__auto__.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__10852__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16411(m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16412) : f.call(null,G__16412));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16413(m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16415 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16414,G__16415) : f.call(null,G__16414,G__16415));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16416(m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16418 = x;
var G__16419 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16417,G__16418,G__16419) : f.call(null,G__16417,G__16418,G__16419));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16420(m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__16421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__16422 = x;
var G__16423 = y;
var G__16424 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16421,G__16422,G__16423,G__16424) : f.call(null,G__16421,G__16422,G__16423,G__16424));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16425(m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function cljs$core$fn_16426(seq16403){
var G__16404 = cljs.core.first(seq16403);
var seq16403__$1 = cljs.core.next(seq16403);
var G__16405 = cljs.core.first(seq16403__$1);
var seq16403__$2 = cljs.core.next(seq16403__$1);
var G__16406 = cljs.core.first(seq16403__$2);
var seq16403__$3 = cljs.core.next(seq16403__$2);
var G__16407 = cljs.core.first(seq16403__$3);
var seq16403__$4 = cljs.core.next(seq16403__$3);
var G__16408 = cljs.core.first(seq16403__$4);
var seq16403__$5 = cljs.core.next(seq16403__$4);
var G__16409 = cljs.core.first(seq16403__$5);
var seq16403__$6 = cljs.core.next(seq16403__$5);
var self__10807__auto__ = this;
return self__10807__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16404,G__16405,G__16406,G__16407,G__16408,G__16409,seq16403__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function cljs$core$fn_16431(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16432(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__16433 = (ll - (5));
var G__16434 = r;
ll = G__16433;
ret = G__16434;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__16435 = pv;
var G__16436 = (level - (5));
var G__16437 = child;
var G__16438 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__16435,G__16436,G__16437,G__16438) : cljs.core.push_tail.call(null,G__16435,G__16436,G__16437,G__16438));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16439 = cljs.core.pv_aget(node,(0));
var G__16440 = (level - (5));
node = G__16439;
level = G__16440;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__16441 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__16442 = (level - (5));
node = G__16441;
level = G__16442;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__16443 = pv;
var G__16444 = (level - (5));
var G__16445 = cljs.core.pv_aget(node,subidx);
var G__16446 = i;
var G__16447 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__16443,G__16444,G__16445,G__16446,G__16447) : cljs.core.do_assoc.call(null,G__16443,G__16444,G__16445,G__16446,G__16447));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16448 = pv;
var G__16449 = (level - (5));
var G__16450 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__16448,G__16449,G__16450) : cljs.core.pop_tail.call(null,G__16448,G__16449,G__16450));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function cljs$core$fn_16451(){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function cljs$core$fn_16452(){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function cljs$core$fn_16453(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16454(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__16456 = arguments.length;
switch (G__16456) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16457(pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16458(pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__16459 = acc;
var G__16460 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16459,G__16460) : f.call(null,G__16459,G__16460));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__16462 = nacc;
var G__16463 = (i + (1));
var G__16464 = arr__$1;
acc = G__16462;
i = G__16463;
arr = G__16464;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);








/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16466(coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function cljs$core$fn_16467(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function cljs$core$fn_16468(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var cljs$core$fn_16469 = null;
var cljs$core$fn_16469__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16469__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16469 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16469__1.call(this,x);
case 2:
return cljs$core$fn_16469__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16469.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16469__1;
cljs$core$fn_16469.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16469__2;
return cljs$core$fn_16469;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var cljs$core$fn_16470 = null;
var cljs$core$fn_16470__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16470__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16470 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16470__1.call(this,x);
case 2:
return cljs$core$fn_16470__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16470.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16470__1;
cljs$core$fn_16470.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16470__2;
return cljs$core$fn_16470;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16471(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16472(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16473(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16474 = init__$2;
var G__16475 = (j + i);
var G__16476 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16474,G__16475,G__16476) : f.call(null,G__16474,G__16475,G__16476));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16506 = (j + (1));
var G__16507 = init__$3;
j = G__16506;
init__$2 = G__16507;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16508 = (i + len);
var G__16509 = init__$2;
i = G__16508;
init__$1 = G__16509;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16477(coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16478(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16479(coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16480(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16481(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16482(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16483(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16484(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16485(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16486(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16487(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16488(coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16489(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16490(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16491(v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16492(v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__16493 = init__$2;
var G__16494 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16493,G__16494) : f.call(null,G__16493,G__16494));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__16510 = (j + (1));
var G__16511 = init__$3;
j = G__16510;
init__$2 = G__16511;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16512 = (i + len);
var G__16513 = init__$2;
i = G__16512;
init__$1 = G__16513;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16495(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16496(coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16497(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16498(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16499(coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__10581__auto___16514 = len;
var i_16515 = (0);
while(true){
if((i_16515 < n__10581__auto___16514)){
(new_tail[i_16515] = (self__.tail[i_16515]));

var G__16516 = (i_16515 + (1));
i_16515 = G__16516;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function cljs$core$fn_16500(self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.apply = (function cljs$core$fn_16501(self__,args16465){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16465);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16502 = args__10096__auto__.slice((0),(20));
G__16502.push(args__10096__auto__.slice((20)));

return G__16502;
})():args__10096__auto__)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16503(k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.getBasis = (function cljs$core$fn_16504(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16505(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function cljs$core$fn_16517(xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__16518 = (i + (1));
var G__16519 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__16518;
out = G__16519;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16520(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__10832__auto__ = [];
var len__10822__auto___16524 = arguments.length;
var i__10823__auto___16525 = (0);
while(true){
if((i__10823__auto___16525 < len__10822__auto___16524)){
args__10832__auto__.push((arguments[i__10823__auto___16525]));

var G__16526 = (i__10823__auto___16525 + (1));
i__10823__auto___16525 = G__16526;
continue;
} else {
}
break;
}

var argseq__10833__auto__ = ((((0) < args__10832__auto__.length))?(new cljs.core.IndexedSeq(args__10832__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10833__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function cljs$core$fn_16522(args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function cljs$core$fn_16523(seq16521){
var self__10808__auto__ = this;
return self__10808__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16521));
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedSeq.prototype.toString = (function cljs$core$fn_16527(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function cljs$core$fn_16528(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var cljs$core$fn_16529 = null;
var cljs$core$fn_16529__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16529__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16529 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16529__1.call(this,x);
case 2:
return cljs$core$fn_16529__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16529.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16529__1;
cljs$core$fn_16529.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16529__2;
return cljs$core$fn_16529;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16530 = null;
var cljs$core$fn_16530__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16530__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16530 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16530__1.call(this,x);
case 2:
return cljs$core$fn_16530__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16530.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16530__1;
cljs$core$fn_16530.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16530__2;
return cljs$core$fn_16530;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16531(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16532(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16533(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16534(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16535(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16536(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16537(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16538(coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16539(coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16540(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function cljs$core$fn_16541(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function cljs$core$fn_16542(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16543(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16544(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function cljs$core$fn_16545(coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function cljs$core$fn_16546(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16547(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16548(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__16550 = arguments.length;
switch (G__16550) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16551(vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16552(vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16553(vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16556(coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function cljs$core$fn_16557(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function cljs$core$fn_16558(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var cljs$core$fn_16559 = null;
var cljs$core$fn_16559__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16559__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16559 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16559__1.call(this,x);
case 2:
return cljs$core$fn_16559__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16559.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16559__1;
cljs$core$fn_16559.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16559__2;
return cljs$core$fn_16559;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var cljs$core$fn_16560 = null;
var cljs$core$fn_16560__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16560__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
cljs$core$fn_16560 = function(x,start__$1){
switch(arguments.length){
case 1:
return cljs$core$fn_16560__1.call(this,x);
case 2:
return cljs$core$fn_16560__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16560.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16560__1;
cljs$core$fn_16560.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16560__2;
return cljs$core$fn_16560;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16561(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16562(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16563(coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__16564 = init__$1;
var G__16565 = j;
var G__16566 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16564,G__16565,G__16566) : f.call(null,G__16564,G__16565,G__16566));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16598 = (i + (1));
var G__16599 = (j + (1));
var G__16600 = init__$2;
i = G__16598;
j = G__16599;
init__$1 = G__16600;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16567(coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16568(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16569(coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__9850__auto__ = self__.end;
var y__9851__auto__ = (v_pos + (1));
return ((x__9850__auto__ > y__9851__auto__) ? x__9850__auto__ : y__9851__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16570(coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16572(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16573(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16574(coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16575(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16576(coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16577(coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16578(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16579(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16580(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16581(coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16583(coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16585(coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16586(coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16587(coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$fn_16587_$_subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function cljs$core$fn_16587_$_subvec_seq_$_fn_16588(){
return cljs$core$fn_16587_$_subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16589(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16590(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var cljs$core$fn_16591 = null;
var cljs$core$fn_16591__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16591__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16591 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16591__2.call(this,self__,k);
case 3:
return cljs$core$fn_16591__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16591.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16591__2;
cljs$core$fn_16591.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16591__3;
return cljs$core$fn_16591;
})()
);

(cljs.core.Subvec.prototype.apply = (function cljs$core$fn_16592(self__,args16555){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16555);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16593 = args__10096__auto__.slice((0),(20));
G__16593.push(args__10096__auto__.slice((20)));

return G__16593;
})():args__10096__auto__)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16594(k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16595(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function cljs$core$fn_16596(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function cljs$core$fn_16597(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16601(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__16602 = meta;
var G__16603 = v.v;
var G__16604 = (v.start + start);
var G__16605 = (v.start + end);
var G__16606 = __hash;
meta = G__16602;
v = G__16603;
start = G__16604;
end = G__16605;
__hash = G__16606;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__16608 = arguments.length;
switch (G__16608) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16609(v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16610(v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__16614 = tv;
var G__16615 = (level - (5));
var G__16616 = child;
var G__16617 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__16614,G__16615,G__16616,G__16617) : cljs.core.tv_push_tail.call(null,G__16614,G__16615,G__16616,G__16617));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__16618 = tv;
var G__16619 = (level - (5));
var G__16620 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__16618,G__16619,G__16620) : cljs.core.tv_pop_tail.call(null,G__16618,G__16619,G__16620));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__16621 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__16622 = (level - (5));
node = G__16621;
level = G__16622;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16624(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16625(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16626(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function cljs$core$fn_16627(tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__16628 = (function cljs$core$fn_16627_$_go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$fn_16627_$_go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__16628(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function cljs$core$fn_16629(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16630(coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16631(coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16632(coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16633(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16634(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var cljs$core$fn_16635 = null;
var cljs$core$fn_16635__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16635__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16635 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16635__2.call(this,self__,k);
case 3:
return cljs$core$fn_16635__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16635.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16635__2;
cljs$core$fn_16635.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16635__3;
return cljs$core$fn_16635;
})()
);

(cljs.core.TransientVector.prototype.apply = (function cljs$core$fn_16636(self__,args16623){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16623);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16637 = args__10096__auto__.slice((0),(20));
G__16637.push(args__10096__auto__.slice((20)));

return G__16637;
})():args__10096__auto__)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16638(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16639(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function cljs$core$fn_16640(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function cljs$core$fn_16641(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function cljs$core$fn_16642(){
var self__ = this;
var _ = this;
var or__9493__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__9493__auto__){
return or__9493__auto__;
} else {
var and__9487__auto__ = (!((self__.riter == null)));
if(and__9487__auto__){
return self__.riter.hasNext();
} else {
return and__9487__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function cljs$core$fn_16643(){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function cljs$core$fn_16644(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function cljs$core$fn_16645(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16646(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function cljs$core$fn_16647(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function cljs$core$fn_16648(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var cljs$core$fn_16649 = null;
var cljs$core$fn_16649__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16649__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16649 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16649__1.call(this,x);
case 2:
return cljs$core$fn_16649__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16649.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16649__1;
cljs$core$fn_16649.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16649__2;
return cljs$core$fn_16649;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16650 = null;
var cljs$core$fn_16650__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16650__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16650 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16650__1.call(this,x);
case 2:
return cljs$core$fn_16650__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16650.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16650__1;
cljs$core$fn_16650.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16650__2;
return cljs$core$fn_16650;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16651(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16652(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16653(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16654(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16655(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16656(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16657(coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16658(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16659(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16660(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function cljs$core$fn_16661(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16662(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16663(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function cljs$core$fn_16664(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function cljs$core$fn_16665(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var cljs$core$fn_16666 = null;
var cljs$core$fn_16666__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16666__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16666 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16666__1.call(this,x);
case 2:
return cljs$core$fn_16666__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16666.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16666__1;
cljs$core$fn_16666.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16666__2;
return cljs$core$fn_16666;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var cljs$core$fn_16667 = null;
var cljs$core$fn_16667__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var cljs$core$fn_16667__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16667 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16667__1.call(this,x);
case 2:
return cljs$core$fn_16667__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16667.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16667__1;
cljs$core$fn_16667.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16667__2;
return cljs$core$fn_16667;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16668(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16669(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16670(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16671(coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16672(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16673(coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next(self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16674(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16675(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16676(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16677(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16678(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16679(coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__9493__auto__ = self__.front;
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16680(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16681(coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__9493__auto__ = self__.rear;
if(cljs.core.truth_(or__9493__auto__)){
return or__9493__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function cljs$core$fn_16682(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function cljs$core$fn_16683(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16684(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function cljs$core$fn_16685(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16686(o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function cljs$core$fn_16687(){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function cljs$core$fn_16688(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function cljs$core$equiv_map_$_fn_16690(_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function cljs$core$equiv_map_$_fn_16691(xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__16692 = (i + incr);
i = G__16692;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__16693 = (i + (1));
var G__16694 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get.call(null,so,k__$1));
i = G__16693;
out = G__16694;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_16700 = (0);
while(true){
if((i_16700 < l)){
var k_16701 = (ks[i_16700]);
var G__16697_16702 = new_obj;
var G__16698_16703 = k_16701;
var G__16699_16704 = cljs.core.goog$module$goog$object.get.call(null,obj,k_16701);
cljs.core.goog$module$goog$object.set.call(null,G__16697_16702,G__16698_16703,G__16699_16704);

var G__16705 = (i_16700 + (1));
i_16700 = G__16705;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16708(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function cljs$core$fn_16709(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function cljs$core$fn_16710(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16711(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16712(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16713(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__16714 = init__$1;
var G__16715 = k;
var G__16716 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16714,G__16715,G__16716) : f.call(null,G__16714,G__16715,G__16716));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16737 = cljs.core.rest(keys__$1);
var G__16738 = init__$2;
keys__$1 = G__16737;
init__$1 = G__16738;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16717(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16718(coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16719(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16720(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16721(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16722(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16723(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16724(coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set.call(null,new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16725(coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16726(coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function cljs$core$fn_16726_$_fn_16727(p1__16706_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__16706_SHARP_,(self__.strobj[p1__16706_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16728(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16729(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var cljs$core$fn_16730 = null;
var cljs$core$fn_16730__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16730__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16730 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16730__2.call(this,self__,k);
case 3:
return cljs$core$fn_16730__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16730.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16730__2;
cljs$core$fn_16730.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16730__3;
return cljs$core$fn_16730;
})()
);

(cljs.core.ObjMap.prototype.apply = (function cljs$core$fn_16731(self__,args16707){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16707);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16732 = args__10096__auto__.slice((0),(20));
G__16732.push(args__10096__auto__.slice((20)));

return G__16732;
})():args__10096__auto__)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16733(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16734(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function cljs$core$fn_16735(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16736(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function cljs$core$fn_16741(ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function cljs$core$fn_16742(){
var self__ = this;
var _ = this;
var or__9493__auto__ = (self__.i < self__.base_count);
if(or__9493__auto__){
return or__9493__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function cljs$core$fn_16743(){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function cljs$core$fn_16744(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function cljs$core$fn_16745(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_16746(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function cljs$core$fn_16747(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__16748 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16748,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16748,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function cljs$core$fn_16751(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16752(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function cljs$core$fn_16753(){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function cljs$core$fn_16754(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16755(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__16756 = (i + (2));
i = G__16756;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__16757 = (i + (2));
i = G__16757;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__16758 = (i + (2));
i = G__16758;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__16759 = (i + (2));
i = G__16759;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__16760 = (i + (2));
i = G__16760;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_16761 = (0);
while(true){
if((i_16761 < l)){
(narr[i_16761] = (arr[i_16761]));

var G__16762 = (i_16761 + (1));
i_16761 = G__16762;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16764(node,k){
var self__ = this;
var node__$1 = this;
var G__16765 = k;
switch (G__16765) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var cljs$core$fn_16766 = null;
var cljs$core$fn_16766__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16766__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16766 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16766__1.call(this,x);
case 2:
return cljs$core$fn_16766__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16766.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16766__1;
cljs$core$fn_16766.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16766__2;
return cljs$core$fn_16766;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var cljs$core$fn_16767 = null;
var cljs$core$fn_16767__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16767__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16767 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16767__1.call(this,x);
case 2:
return cljs$core$fn_16767__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16767.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16767__1;
cljs$core$fn_16767.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16767__2;
return cljs$core$fn_16767;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16768(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16769(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_16770(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_16771(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_16772(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16773(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16774(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_16775(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_16776(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_16777(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_16778(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_16779(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16780(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16781(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16782(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16783(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16784(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16785(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16786(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16787(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16788(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16789(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var cljs$core$fn_16790 = null;
var cljs$core$fn_16790__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_16790__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_16790 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16790__2.call(this,self__,k);
case 3:
return cljs$core$fn_16790__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16790.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16790__2;
cljs$core$fn_16790.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16790__3;
return cljs$core$fn_16790;
})()
);

(cljs.core.MapEntry.prototype.apply = (function cljs$core$fn_16791(self__,args16763){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16763);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16792 = args__10096__auto__.slice((0),(20));
G__16792.push(args__10096__auto__.slice((20)));

return G__16792;
})():args__10096__auto__)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16793(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16794(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function cljs$core$fn_16795(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function cljs$core$fn_16796(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function cljs$core$fn_16799(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function cljs$core$fn_16800(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_16801 = null;
var cljs$core$fn_16801__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_16801__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16801 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16801__1.call(this,x);
case 2:
return cljs$core$fn_16801__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16801.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16801__1;
cljs$core$fn_16801.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16801__2;
return cljs$core$fn_16801;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_16802 = null;
var cljs$core$fn_16802__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_16802__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_16802 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_16802__1.call(this,x);
case 2:
return cljs$core$fn_16802__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_16802__1;
cljs$core$fn_16802.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16802__2;
return cljs$core$fn_16802;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16803(coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_16804(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16805(coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16806(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16807(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16808(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16809(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16810(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_16811(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_16812(coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16813(coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16814(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16815(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function cljs$core$fn_16816(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_16817(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16818(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function cljs$core$fn_16819(){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function cljs$core$fn_16820(){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function cljs$core$fn_16821(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16822(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_16824(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function cljs$core$fn_16825(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function cljs$core$fn_16826(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function cljs$core$fn_16827(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function cljs$core$fn_16828(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function cljs$core$fn_16829(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function cljs$core$fn_16830(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function cljs$core$fn_16831(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function cljs$core$fn_16832(f){
var self__ = this;
var coll = this;
var seq__16833 = cljs.core.seq(coll);
var chunk__16834 = null;
var count__16835 = (0);
var i__16836 = (0);
while(true){
if((i__16836 < count__16835)){
var vec__16843 = chunk__16834.cljs$core$IIndexed$_nth$arity$2(null,i__16836);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16843,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16843,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16881 = seq__16833;
var G__16882 = chunk__16834;
var G__16883 = count__16835;
var G__16884 = (i__16836 + (1));
seq__16833 = G__16881;
chunk__16834 = G__16882;
count__16835 = G__16883;
i__16836 = G__16884;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__16833);
if(temp__5720__auto__){
var seq__16833__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__16833__$1)){
var c__10465__auto__ = cljs.core.chunk_first(seq__16833__$1);
var G__16885 = cljs.core.chunk_rest(seq__16833__$1);
var G__16886 = c__10465__auto__;
var G__16887 = cljs.core.count(c__10465__auto__);
var G__16888 = (0);
seq__16833 = G__16885;
chunk__16834 = G__16886;
count__16835 = G__16887;
i__16836 = G__16888;
continue;
} else {
var vec__16846 = cljs.core.first(seq__16833__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16846,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16846,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__16889 = cljs.core.next(seq__16833__$1);
var G__16890 = null;
var G__16891 = (0);
var G__16892 = (0);
seq__16833 = G__16889;
chunk__16834 = G__16890;
count__16835 = G__16891;
i__16836 = G__16892;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16849(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16850(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_16851(coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__16852 = init__$1;
var G__16853 = (self__.arr[i]);
var G__16854 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16852,G__16853,G__16854) : f.call(null,G__16852,G__16853,G__16854));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__16893 = (i + (2));
var G__16894 = init__$2;
i = G__16893;
init__$1 = G__16894;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16855(this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_16856(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_16857(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16858(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_16859(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_16860(coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__16895 = (i + (2));
i = G__16895;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_16861(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_16864(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_16865(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_16866(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_16867(coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__16896 = (s + (2));
var G__16897 = d;
s = G__16896;
d = G__16897;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__16898 = (s + (2));
var G__16899 = (d + (2));
s = G__16898;
d = G__16899;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_16868(coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__16869 = cljs.core.aclone(self__.arr);
(G__16869[(idx + (1))] = v);

return G__16869;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_16870(coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_16871(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_16872(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_16873(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__16900 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__16901 = cljs.core.next(es);
ret = G__16900;
es = G__16901;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var cljs$core$fn_16874 = null;
var cljs$core$fn_16874__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_16874__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_16874 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16874__2.call(this,self__,k);
case 3:
return cljs$core$fn_16874__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16874.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16874__2;
cljs$core$fn_16874.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16874__3;
return cljs$core$fn_16874;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function cljs$core$fn_16875(self__,args16823){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16823);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16876 = args__10096__auto__.slice((0),(20));
G__16876.push(args__10096__auto__.slice((20)));

return G__16876;
})():args__10096__auto__)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16877(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16878(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.getBasis = (function cljs$core$fn_16879(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16880(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function cljs$core$fn_16902(arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_16903 = (0);
while(true){
if((i_16903 < arr__$1.length)){
var k_16904 = (arr__$1[i_16903]);
var v_16905 = (arr__$1[(i_16903 + (1))]);
var idx_16906 = cljs.core.array_index_of(ret,k_16904);
if((idx_16906 === (-1))){
ret.push(k_16904);

ret.push(v_16905);
} else {
}

var G__16907 = (i_16903 + (2));
i_16903 = G__16907;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function cljs$core$fn_16908(arr){
var ret = [];
var i_16910 = (0);
while(true){
if((i_16910 < arr.length)){
var k_16911 = (arr[i_16910]);
var v_16912 = (arr[(i_16910 + (1))]);
var idx_16913 = cljs.core.array_index_of(ret,k_16911);
if((idx_16913 === (-1))){
var G__16909_16914 = ret;
G__16909_16914.push(k_16911);

G__16909_16914.push(v_16912);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_16911)].join('')));
}

var G__16915 = (i_16910 + (2));
i_16910 = G__16915;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9493__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9493__auto__){
return or__9493__auto__;
} else {
var G__16916 = ((2) + j);
j = G__16916;
continue;
}
} else {
return false;
}
break;
}
})();
var or__9493__auto__ = dupe_QMARK_;
if(or__9493__auto__){
return or__9493__auto__;
} else {
var G__16917 = ((2) + i);
i = G__16917;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__9493__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__9493__auto__){
return or__9493__auto__;
} else {
var G__16918 = ((2) + j);
j = G__16918;
continue;
}
} else {
return false;
}
break;
}
})();
var G__16919 = ((2) + i);
var G__16920 = ((dupe_QMARK_)?n:(n + (2)));
i = G__16919;
n = G__16920;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__16921 = ((2) + seed_cnt);
var G__16922 = cljs.core.next(extra_kvs__$1);
i = G__16921;
extra_kvs__$1 = G__16922;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function cljs$core$fn_16923(init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function cljs$core$fn_16924(init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_16925 = (0);
var m_16926 = (0);
while(true){
if((i_16925 < len)){
var dupe_QMARK__16927 = (function (){var j = (0);
while(true){
if((j < m_16926)){
var or__9493__auto__ = cljs.core.key_test((init__$1[i_16925]),(init__$1[j]));
if(or__9493__auto__){
return or__9493__auto__;
} else {
var G__16928 = ((2) + j);
j = G__16928;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__16927))){
var j_16929 = (function (){var j_16929 = (len - (2));
while(true){
if((j_16929 >= i_16925)){
if(cljs.core.key_test((init__$1[i_16925]),(init__$1[j_16929]))){
return j_16929;
} else {
var G__16930 = (j_16929 - (2));
j_16929 = G__16930;
continue;
}
} else {
return j_16929;
}
break;
}
})();
(nodups[m_16926] = (init__$1[i_16925]));

(nodups[(m_16926 + (1))] = (init__$1[(j_16929 + (1))]));

var G__16931 = ((2) + i_16925);
var G__16932 = ((2) + m_16926);
i_16925 = G__16931;
m_16926 = G__16932;
continue;
} else {
var G__16933 = ((2) + i_16925);
var G__16934 = m_16926;
i_16925 = G__16933;
m_16926 = G__16934;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_16935(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_16937(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_16938(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_16939(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_16940(tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__16952 = cljs.core.next(es);
var G__16953 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__16952;
tcoll__$2 = G__16953;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_16941(tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_16942(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_16943(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__16944_16954 = self__.arr;
G__16944_16954.pop();

G__16944_16954.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var cljs$core$fn_16945 = null;
var cljs$core$fn_16945__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var cljs$core$fn_16945__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_16945 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_16945__2.call(this,self__,key);
case 3:
return cljs$core$fn_16945__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_16945.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_16945__2;
cljs$core$fn_16945.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_16945__3;
return cljs$core$fn_16945;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function cljs$core$fn_16946(self__,args16936){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args16936);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__16947 = args__10096__auto__.slice((0),(20));
G__16947.push(args__10096__auto__.slice((20)));

return G__16947;
})():args__10096__auto__)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_16948(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_16949(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function cljs$core$fn_16950(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_16951(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__16955 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__16956 = (i + (2));
out = G__16955;
i = G__16956;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function cljs$core$fn_16957(){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function cljs$core$fn_16958(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__16960 = arguments.length;
switch (G__16960) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_16961(arr,i,a){
var G__16962 = cljs.core.aclone(arr);
(G__16962[i] = a);

return G__16962;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function cljs$core$fn_16963(arr,i,a,j,b){
var G__16964 = cljs.core.aclone(arr);
(G__16964[i] = a);

(G__16964[j] = b);

return G__16964;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__16967 = arguments.length;
switch (G__16967) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function cljs$core$fn_16968(inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_16969(inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__16971 = init__$1;
var G__16972 = k;
var G__16973 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16971,G__16972,G__16973) : f.call(null,G__16971,G__16972,G__16973));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__16974 = (i + (2));
var G__16975 = init__$2;
i = G__16974;
init__$1 = G__16975;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function cljs$core$fn_16976(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function cljs$core$fn_16977(){
var self__ = this;
var this$ = this;
var or__9493__auto__ = (!((self__.next_entry == null)));
if(or__9493__auto__){
return or__9493__auto__;
} else {
var or__9493__auto____$1 = (!((self__.next_iter == null)));
if(or__9493__auto____$1){
return or__9493__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function cljs$core$fn_16978(){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function cljs$core$fn_16979(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function cljs$core$fn_16980(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_16981(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function cljs$core$fn_16982(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function cljs$core$fn_16983(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function cljs$core$fn_16984(e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function cljs$core$fn_16985(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function cljs$core$fn_16986(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function cljs$core$fn_16987(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_16988(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_16995 = (0);
var j_16996 = (0);
while(true){
if((i_16995 < (32))){
if((((self__.bitmap >>> i_16995) & (1)) === (0))){
var G__16997 = (i_16995 + (1));
var G__16998 = j_16996;
i_16995 = G__16997;
j_16996 = G__16998;
continue;
} else {
(nodes[i_16995] = (((!(((self__.arr[j_16996]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_16996])),(self__.arr[j_16996]),(self__.arr[(j_16996 + (1))]),added_leaf_QMARK_):(self__.arr[(j_16996 + (1))])));

var G__16999 = (i_16995 + (1));
var G__17000 = (j_16996 + (2));
i_16995 = G__16999;
j_16996 = G__17000;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function cljs$core$fn_16989(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_17001 = (0);
var j_17002 = (0);
while(true){
if((i_17001 < (32))){
if((((self__.bitmap >>> i_17001) & (1)) === (0))){
var G__17003 = (i_17001 + (1));
var G__17004 = j_17002;
i_17001 = G__17003;
j_17002 = G__17004;
continue;
} else {
(nodes[i_17001] = (((!(((self__.arr[j_17002]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_17002])),(self__.arr[j_17002]),(self__.arr[(j_17002 + (1))]),added_leaf_QMARK_):(self__.arr[(j_17002 + (1))])));

var G__17005 = (i_17001 + (1));
var G__17006 = (j_17002 + (2));
i_17001 = G__17005;
j_17002 = G__17006;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function cljs$core$fn_16990(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function cljs$core$fn_16991(shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_16992(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function cljs$core$fn_16993(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_16994(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__17007 = (i + (1));
var G__17008 = (j + (2));
var G__17009 = (bitmap | ((1) << i));
i = G__17007;
j = G__17008;
bitmap = G__17009;
continue;
} else {
var G__17010 = (i + (1));
var G__17011 = j;
var G__17012 = bitmap;
i = G__17010;
j = G__17011;
bitmap = G__17012;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function cljs$core$fn_17013(){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function cljs$core$fn_17014(){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function cljs$core$fn_17015(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function cljs$core$fn_17016(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function cljs$core$fn_17017(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function cljs$core$fn_17018(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17019(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function cljs$core$fn_17020(){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function cljs$core$fn_17021(f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__17030 = (i + (1));
var G__17031 = init__$2;
i = G__17030;
init__$1 = G__17031;
continue;
}
} else {
var G__17032 = (i + (1));
var G__17033 = init__$1;
i = G__17032;
init__$1 = G__17033;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function cljs$core$fn_17022(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17023(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function cljs$core$fn_17024(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function cljs$core$fn_17025(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function cljs$core$fn_17026(shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17027(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function cljs$core$fn_17028(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17029(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__17034 = (i + (2));
i = G__17034;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function cljs$core$fn_17035(e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function cljs$core$fn_17036(edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function cljs$core$fn_17037(){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function cljs$core$fn_17038(f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function cljs$core$fn_17039(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function cljs$core$fn_17040(edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function cljs$core$fn_17041(shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function cljs$core$fn_17042(e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function cljs$core$fn_17043(shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function cljs$core$fn_17044(shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17045(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function cljs$core$fn_17046(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17047(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__17049 = arguments.length;
switch (G__17049) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function cljs$core$fn_17050(shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function cljs$core$fn_17051(edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function cljs$core$fn_17053(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function cljs$core$fn_17054(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17055 = null;
var cljs$core$fn_17055__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17055__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17055 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17055__1.call(this,x);
case 2:
return cljs$core$fn_17055__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17055.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17055__1;
cljs$core$fn_17055.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17055__2;
return cljs$core$fn_17055;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17056 = null;
var cljs$core$fn_17056__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17056__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17056 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17056__1.call(this,x);
case 2:
return cljs$core$fn_17056__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17056.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17056__1;
cljs$core$fn_17056.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17056__2;
return cljs$core$fn_17056;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17057(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17058(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17059(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17060(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17061(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17062(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17063(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17064(coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17065(coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17066(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17067(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17068(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function cljs$core$fn_17069(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17070(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17071(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__17073 = arguments.length;
switch (G__17073) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17074(nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17075(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__17077 = (j + (2));
j = G__17077;
continue;
}
} else {
var G__17078 = (j + (2));
j = G__17078;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function cljs$core$fn_17079(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function cljs$core$fn_17080(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var cljs$core$fn_17081 = null;
var cljs$core$fn_17081__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17081__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17081 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17081__1.call(this,x);
case 2:
return cljs$core$fn_17081__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17081.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17081__1;
cljs$core$fn_17081.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17081__2;
return cljs$core$fn_17081;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17082 = null;
var cljs$core$fn_17082__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17082__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17082 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17082__1.call(this,x);
case 2:
return cljs$core$fn_17082__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17082.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17082__1;
cljs$core$fn_17082.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17082__2;
return cljs$core$fn_17082;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17083(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17084(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17085(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17086(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17087(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17088(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17089(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17090(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17091(coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17092(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17093(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17094(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function cljs$core$fn_17095(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17096(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17097(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__17099 = arguments.length;
switch (G__17099) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17100(nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function cljs$core$fn_17101(nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__17103 = (j + (1));
j = G__17103;
continue;
}
} else {
var G__17104 = (j + (1));
j = G__17104;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function cljs$core$fn_17105(){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function cljs$core$fn_17106(){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function cljs$core$fn_17107(){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function cljs$core$fn_17108(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function cljs$core$fn_17109(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17111(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function cljs$core$fn_17112(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function cljs$core$fn_17113(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function cljs$core$fn_17114(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function cljs$core$fn_17115(){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function cljs$core$fn_17116(){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function cljs$core$fn_17117(k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function cljs$core$fn_17118(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function cljs$core$fn_17119(f){
var self__ = this;
var coll = this;
var seq__17120 = cljs.core.seq(coll);
var chunk__17121 = null;
var count__17122 = (0);
var i__17123 = (0);
while(true){
if((i__17123 < count__17122)){
var vec__17130 = chunk__17121.cljs$core$IIndexed$_nth$arity$2(null,i__17123);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17130,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17130,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17162 = seq__17120;
var G__17163 = chunk__17121;
var G__17164 = count__17122;
var G__17165 = (i__17123 + (1));
seq__17120 = G__17162;
chunk__17121 = G__17163;
count__17122 = G__17164;
i__17123 = G__17165;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17120);
if(temp__5720__auto__){
var seq__17120__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17120__$1)){
var c__10465__auto__ = cljs.core.chunk_first(seq__17120__$1);
var G__17166 = cljs.core.chunk_rest(seq__17120__$1);
var G__17167 = c__10465__auto__;
var G__17168 = cljs.core.count(c__10465__auto__);
var G__17169 = (0);
seq__17120 = G__17166;
chunk__17121 = G__17167;
count__17122 = G__17168;
i__17123 = G__17169;
continue;
} else {
var vec__17133 = cljs.core.first(seq__17120__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17133,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17133,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17170 = cljs.core.next(seq__17120__$1);
var G__17171 = null;
var G__17172 = (0);
var G__17173 = (0);
seq__17120 = G__17170;
chunk__17121 = G__17171;
count__17122 = G__17172;
i__17123 = G__17173;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17136(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17137(coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function cljs$core$fn_17138(coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function cljs$core$fn_17139(coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17140(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function cljs$core$fn_17141(_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17142(coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17143(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17144(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function cljs$core$fn_17145(coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17148(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function cljs$core$fn_17149(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17150(coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17151(coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17152(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17153(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17154(coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__17174 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__17175 = cljs.core.next(es);
ret = G__17174;
es = G__17175;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var cljs$core$fn_17155 = null;
var cljs$core$fn_17155__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var cljs$core$fn_17155__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
cljs$core$fn_17155 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17155__2.call(this,self__,k);
case 3:
return cljs$core$fn_17155__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17155.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17155__2;
cljs$core$fn_17155.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17155__3;
return cljs$core$fn_17155;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function cljs$core$fn_17156(self__,args17110){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args17110);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__17157 = args__10096__auto__.slice((0),(20));
G__17157.push(args__10096__auto__.slice((20)));

return G__17157;
})():args__10096__auto__)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17158(k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17159(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function cljs$core$fn_17160(){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17161(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function cljs$core$fn_17176(arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__17177 = (i + (2));
var G__17178 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__17177;
ret = G__17178;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function cljs$core$fn_17179(ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__17180 = (i + (1));
var G__17181 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__17180;
out = G__17181;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function cljs$core$fn_17182(arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_17183 = (0);
while(true){
if((i_17183 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_17183]),(arr[(i_17183 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_17183 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_17183]))].join('')));
} else {
var G__17184 = (i_17183 + (2));
i_17183 = G__17184;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17185(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function cljs$core$fn_17187(o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__17205 = cljs.core.next(es);
var G__17206 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__17205;
tcoll__$1 = G__17206;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function cljs$core$fn_17188(k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function cljs$core$fn_17189(k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function cljs$core$fn_17190(){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17191(coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17192(tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17193(tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function cljs$core$fn_17194(tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function cljs$core$fn_17195(tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function cljs$core$fn_17196(tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function cljs$core$fn_17197(tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var cljs$core$fn_17198 = null;
var cljs$core$fn_17198__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var cljs$core$fn_17198__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
cljs$core$fn_17198 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17198__2.call(this,self__,key);
case 3:
return cljs$core$fn_17198__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17198.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17198__2;
cljs$core$fn_17198.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17198__3;
return cljs$core$fn_17198;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function cljs$core$fn_17199(self__,args17186){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args17186);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__17200 = args__10096__auto__.slice((0),(20));
G__17200.push(args__10096__auto__.slice((20)));

return G__17200;
})():args__10096__auto__)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17201(key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17202(key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function cljs$core$fn_17203(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function cljs$core$fn_17204(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__17207 = ((ascending_QMARK_)?t.left:t.right);
var G__17208 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__17207;
stack__$1 = G__17208;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function cljs$core$fn_17209(){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function cljs$core$fn_17210(other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var cljs$core$fn_17211 = null;
var cljs$core$fn_17211__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17211__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17211 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17211__1.call(this,x);
case 2:
return cljs$core$fn_17211__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17211.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17211__1;
cljs$core$fn_17211.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17211__2;
return cljs$core$fn_17211;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var cljs$core$fn_17212 = null;
var cljs$core$fn_17212__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17212__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17212 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17212__1.call(this,x);
case 2:
return cljs$core$fn_17212__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17212.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17212__1;
cljs$core$fn_17212.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17212__2;
return cljs$core$fn_17212;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17213(coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function cljs$core$fn_17214(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17215(coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17216(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17217(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17218(coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17219(coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17220(coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function cljs$core$fn_17221(this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function cljs$core$fn_17222(this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17223(this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17224(coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17225(coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function cljs$core$fn_17226(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function cljs$core$fn_17227(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17228(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__17229 = node.left;
var G__17230 = f;
var G__17231 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17229,G__17230,G__17231) : cljs.core.tree_map_kv_reduce.call(null,G__17229,G__17230,G__17231));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__17232 = init__$1;
var G__17233 = node.key;
var G__17234 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17232,G__17233,G__17234) : f.call(null,G__17232,G__17233,G__17234));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__17235 = node.right;
var G__17236 = f;
var G__17237 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__17235,G__17236,G__17237) : cljs.core.tree_map_kv_reduce.call(null,G__17235,G__17236,G__17237));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17239(node,k){
var self__ = this;
var node__$1 = this;
var G__17240 = k;
switch (G__17240) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17241 = null;
var cljs$core$fn_17241__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17241__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17241 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17241__1.call(this,x);
case 2:
return cljs$core$fn_17241__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17241.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17241__1;
cljs$core$fn_17241.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17241__2;
return cljs$core$fn_17241;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var cljs$core$fn_17242 = null;
var cljs$core$fn_17242__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17242__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17242 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17242__1.call(this,x);
case 2:
return cljs$core$fn_17242__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17242.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17242__1;
cljs$core$fn_17242.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17242__2;
return cljs$core$fn_17242;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function cljs$core$fn_17243(ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function cljs$core$fn_17244(){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function cljs$core$fn_17245(){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function cljs$core$fn_17246(ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function cljs$core$fn_17247(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function cljs$core$fn_17248(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function cljs$core$fn_17249(parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function cljs$core$fn_17250(del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function cljs$core$fn_17251(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function cljs$core$fn_17252(del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17253(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17254(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17255(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17256(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17257(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17258(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17259(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17260(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17261(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17262(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17263(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17264(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17265(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17266(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17267(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17268(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17269(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17270(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17271(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17272(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17273(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17274(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var cljs$core$fn_17275 = null;
var cljs$core$fn_17275__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17275__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17275 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17275__2.call(this,self__,k);
case 3:
return cljs$core$fn_17275__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17275.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17275__2;
cljs$core$fn_17275.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17275__3;
return cljs$core$fn_17275;
})()
);

(cljs.core.BlackNode.prototype.apply = (function cljs$core$fn_17276(self__,args17238){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args17238);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__17277 = args__10096__auto__.slice((0),(20));
G__17277.push(args__10096__auto__.slice((20)));

return G__17277;
})():args__10096__auto__)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17278(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17279(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function cljs$core$fn_17280(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17281(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17283(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17285(node,k){
var self__ = this;
var node__$1 = this;
var G__17286 = k;
switch (G__17286) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var cljs$core$fn_17287 = null;
var cljs$core$fn_17287__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var cljs$core$fn_17287__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17287 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17287__1.call(this,x);
case 2:
return cljs$core$fn_17287__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17287.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17287__1;
cljs$core$fn_17287.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17287__2;
return cljs$core$fn_17287;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var cljs$core$fn_17288 = null;
var cljs$core$fn_17288__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var cljs$core$fn_17288__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
cljs$core$fn_17288 = function(x,start){
switch(arguments.length){
case 1:
return cljs$core$fn_17288__1.call(this,x);
case 2:
return cljs$core$fn_17288__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fn_17288.cljs$core$IFn$_invoke$arity$1 = cljs$core$fn_17288__1;
cljs$core$fn_17288.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17288__2;
return cljs$core$fn_17288;
})()
);

(cljs.core.RedNode.prototype.add_right = (function cljs$core$fn_17289(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function cljs$core$fn_17290(){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function cljs$core$fn_17291(){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function cljs$core$fn_17292(ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function cljs$core$fn_17293(key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function cljs$core$fn_17294(parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function cljs$core$fn_17295(parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function cljs$core$fn_17296(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function cljs$core$fn_17297(f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function cljs$core$fn_17298(del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function cljs$core$fn_17299(node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function cljs$core$fn_17300(node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function cljs$core$fn_17301(node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function cljs$core$fn_17302(node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function cljs$core$fn_17303(node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function cljs$core$fn_17304(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function cljs$core$fn_17305(node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function cljs$core$fn_17306(node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function cljs$core$fn_17307(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function cljs$core$fn_17308(node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function cljs$core$fn_17309(node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function cljs$core$fn_17310(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function cljs$core$fn_17311(coll){
var self__ = this;
var coll__$1 = this;
var h__9954__auto__ = self__.__hash;
if((!((h__9954__auto__ == null)))){
return h__9954__auto__;
} else {
var h__9954__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__9954__auto____$1);

return h__9954__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function cljs$core$fn_17312(coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function cljs$core$fn_17313(node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function cljs$core$fn_17314(node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function cljs$core$fn_17315(node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function cljs$core$fn_17316(node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function cljs$core$fn_17317(node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function cljs$core$fn_17318(node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function cljs$core$fn_17319(node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function cljs$core$fn_17320(node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var cljs$core$fn_17321 = null;
var cljs$core$fn_17321__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var cljs$core$fn_17321__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
cljs$core$fn_17321 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$fn_17321__2.call(this,self__,k);
case 3:
return cljs$core$fn_17321__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$fn_17321.cljs$core$IFn$_invoke$arity$2 = cljs$core$fn_17321__2;
cljs$core$fn_17321.cljs$core$IFn$_invoke$arity$3 = cljs$core$fn_17321__3;
return cljs$core$fn_17321;
})()
);

(cljs.core.RedNode.prototype.apply = (function cljs$core$fn_17322(self__,args17284){
var self__ = this;
var self____$1 = this;
var args__10096__auto__ = cljs.core.aclone(args17284);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__10096__auto__.length > (20)))?(function (){var G__17323 = args__10096__auto__.slice((0),(20));
G__17323.push(args__10096__auto__.slice((20)));

return G__17323;
})():args__10096__auto__)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function cljs$core$fn_17324(k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function cljs$core$fn_17325(k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function cljs$core$fn_17326(){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.RedNode.cljs$lang$type = true);

(cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode");

(cljs.core.RedNode.cljs$lang$ctorPrWriter = (function cljs$core$fn_17327(this__10170__auto__,writer__10171__auto__,opt__10172__auto__){
return cljs.core._write(writer__10171__auto__,"cljs.core/RedNode");
}));

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function cljs$core$fn_17329(){
var this__10683__auto__ = this;
return cljs.core.es6_iterator(this__10683__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__17330 = k;
var G__17331 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17330,G__17331) : comp.call(null,G__17330,G__17331));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__17332 = comp;
var G__17333 = tree.left;
var G__17334 = k;
var G__17335 = v;
var G__17336 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__17332,G__17333,G__17334,G__17335,G__17336) : cljs.core.tree_map_add.call(null,G__17332,G__17333,G__17334,G__17335,G__17336));
})();
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__17337 = comp;
var G__17338 = tree.right;
var G__17339 = k;
var G__17340 = v;
var G__17341 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__17337,G__17338,G__17339,G__17340,G__17341) : cljs.core.tree_map_add.call(null,G__17337,G__17338,G__17339,G__17340,G__17341));
})();
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__17342 = left.right;
var G__17343 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__17342,G__17343) : cljs.core.tree_map_append.call(null,G__17342,G__17343));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__17344 = left.right;
var G__17345 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__17344,G__17345) : cljs.core.tree_map_append.call(null,G__17344,G__17345));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__17346 = left;
var G__17347 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__17346,G__17347) : cljs.core.tree_map_append.call(null,G__17346,G__17347));
})(),right.right,null));
} else {
var app = (function (){var G__17348 = left.right;
var G__17349 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__17348,G__17349) : cljs.core.tree_map_append.call(null,G__17348,G__17349));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = (function (){var G__17350 = k;
var G__17351 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__17350,G__17351) : comp.call(null,G__17350,G__17351));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__17352 = comp;
var G__17353 = tree.left;
var G__17354 = k;
var G__17355 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__17352,G__17353,G__17354,G__17355) : cljs.core.tree_map_remove.call(null,G__17352,G__17353,G__17354,G__17355));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__17356 = comp;
var G__17357 = tree.right;
var G__17358 = k;
var G__17359 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__17356,G__17357,G__17358,G__17359) : cljs.core.tree_map_remove.call(null,G__17356,G__17357,G__17358,G__17359));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__17360 = comp;
var G__17361 = tree.left;
var G__17362 = k;
var G__17363 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__17360,G__17361,G__17362,G__17363) : cljs.core.tree_map_replace.call(null,G__17360,G__17361,G__17362,G__17363));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__17364 = comp;
var G__17365 = tree.right;
var G__17366 = k;
var G__17367 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__17364,G__17365,G__17366,G__17367) : cljs.core.tree_map_replace.call(null,G__17364,G__17365,G__17366,G__17367));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function cljs$core$fn_17369(coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
}));

(cljs.core.PersistentTreeMap.prototype.forEach = (function cljs$core$fn_17370(f){
var self__ = this;
var coll = this;
var seq__17371 = cljs.core.seq(coll);
var chunk__17372 = null;
var count__17373 = (0);
var i__17374 = (0);
while(true){
if((i__17374 < count__17373)){
var vec__17381 = chunk__17372.cljs$core$IIndexed$_nth$arity$2(null,i__17374);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17381,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17381,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17428 = seq__17371;
var G__17429 = chunk__17372;
var G__17430 = count__17373;
var G__17431 = (i__17374 + (1));
seq__17371 = G__17428;
chunk__17372 = G__17429;
count__17373 = G__17430;
i__17374 = G__17431;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__17371);
if(temp__5720__auto__){
var seq__17371__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17371__$1)){
var c__10465__auto__ = cljs.core.chunk_first(seq__17371__$1);
var G__17432 = cljs.core.chunk_rest(seq__17371__$1);
var G__17433 = c__10465__auto__;
var G__17434 = cljs.core.count(c__10465__auto__);
var G__17435 = (0);
seq__17371 = G__17432;
chunk__17372 = G__17433;
count__17373 = G__17434;
i__17374 = G__17435;
continue;
} else {
var vec__17384 = cljs.core.first(seq__17371__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17384,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17384,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__17436 = cljs.core.next(seq__17371__$1);
var G__17437 = null;
var G__17438 = (0);
var G__17439 = (0);
seq__17371 = G__17436;
chunk__17372 = G__17437;
count__17373 = G__17438;
i__17374 = G__17439;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.get = (function cljs$core$fn_17387(k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.entries = (function cljs$core$fn_17388(){
var self__ 