package icepick;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;

import java.io.Serializable;
import java.util.ArrayList;

public class Injector {

    protected String baseKey = "";

    protected boolean getBoolean(Bundle state, String key) {
        return state.getBoolean(key + baseKey);
    }

    protected void putBoolean(Bundle state, String key, boolean x) {
        state.putBoolean(key + baseKey, x);
    }

    protected Boolean getBoxedBoolean(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getBoolean(key + baseKey);
        }
        return null;
    }

    protected void putBoxedBoolean(Bundle state, String key, Boolean x) {
        if (x != null) {
            state.putBoolean(key + baseKey, x);
        }
    }

    protected boolean[] getBooleanArray(Bundle state, String key) {
        return state.getBooleanArray(key + baseKey);
    }

    protected void putBooleanArray(Bundle state, String key, boolean[] x) {
        state.putBooleanArray(key + baseKey, x);
    }

    protected byte getByte(Bundle state, String key) {
        return state.getByte(key + baseKey);
    }

    protected void putByte(Bundle state, String key, byte x) {
        state.putByte(key + baseKey, x);
    }

    protected Byte getBoxedByte(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getByte(key + baseKey);
        }
        return null;
    }

    protected void putBoxedByte(Bundle state, String key, Byte x) {
        if (x != null) {
            state.putByte(key + baseKey, x);
        }
    }

    protected byte[] getByeArray(Bundle state, String key) {
        return state.getByteArray(key + baseKey);
    }

    protected void putByteArray(Bundle state, String key, byte[] x) {
        state.putByteArray(key + baseKey, x);
    }


    protected short getShort(Bundle state, String key) {
        return state.getShort(key + baseKey);
    }

    protected void putShort(Bundle state, String key, short x) {
        state.putShort(key + baseKey, x);
    }

    protected Short getBoxedShort(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getShort(key + baseKey);
        }
        return null;
    }

    protected void putBoxedShort(Bundle state, String key, Short x) {
        if (x != null) {
            state.putShort(key + baseKey, x);
        }
    }

    protected short[] getShortArray(Bundle state, String key) {
        return state.getShortArray(key + baseKey);
    }

    protected void putShortArray(Bundle state, String key, short[] x) {
        state.putShortArray(key + baseKey, x);
    }

    protected int getInt(Bundle state, String key) {
        return state.getInt(key + baseKey);
    }

    protected void putInt(Bundle state, String key, int x) {
        state.putInt(key + baseKey, x);
    }

    protected Integer getBoxedInt(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getInt(key + baseKey);
        }
        return null;
    }

    protected void putBoxedInt(Bundle state, String key, Integer x) {
        if (x != null) {
            state.putInt(key + baseKey, x);
        }
    }

    protected int[] getIntArray(Bundle state, String key) {
        return state.getIntArray(key + baseKey);
    }

    protected void putIntArray(Bundle state, String key, int[] x) {
        state.putIntArray(key + baseKey, x);
    }

    protected long getLong(Bundle state, String key) {
        return state.getLong(key + baseKey);
    }

    protected void putLong(Bundle state, String key, long x) {
        state.putLong(key + baseKey, x);
    }

    protected Long getBoxedLong(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getLong(key + baseKey);
        }
        return null;
    }

    protected void putBoxedLong(Bundle state, String key, Long x) {
        if (x != null) {
            state.putLong(key + baseKey, x);
        }
    }

    protected long[] getLongArray(Bundle state, String key) {
        return state.getLongArray(key + baseKey);
    }

    protected void putLongArray(Bundle state, String key, long[] x) {
        state.putLongArray(key + baseKey, x);
    }

    protected float getFloat(Bundle state, String key) {
        return state.getFloat(key + baseKey);
    }

    protected void putFloat(Bundle state, String key, float x) {
        state.putFloat(key + baseKey, x);
    }

    protected Float getBoxedFloat(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getFloat(key + baseKey);
        }
        return null;
    }

    protected void putBoxedFloat(Bundle state, String key, Float x) {
        if (x != null) {
            state.putFloat(key + baseKey, x);
        }
    }

    protected float[] getFloatArray(Bundle state, String key) {
        return state.getFloatArray(key + baseKey);
    }

    protected void putFloatArray(Bundle state, String key, float[] x) {
        state.putFloatArray(key + baseKey, x);
    }

    protected double getDouble(Bundle state, String key) {
        return state.getDouble(key + baseKey);
    }

    protected void putDouble(Bundle state, String key, double x) {
        state.putDouble(key + baseKey, x);
    }

    protected Double getBoxedDouble(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getDouble(key + baseKey);
        }
        return null;
    }

    protected void putBoxedDouble(Bundle state, String key, Double x) {
        if (x != null) {
            state.putDouble(key + baseKey, x);
        }
    }

    protected double[] getDoubleArray(Bundle state, String key) {
        return state.getDoubleArray(key + baseKey);
    }

    protected void putDoubleArray(Bundle state, String key, double[] x) {
        state.putDoubleArray(key + baseKey, x);
    }

    protected char getChar(Bundle state, String key) {
        return state.getChar(key + baseKey);
    }

    protected void putChar(Bundle state, String key, char x) {
        state.putChar(key + baseKey, x);
    }

    protected Character getBoxedChar(Bundle state, String key) {
        if (state.containsKey(key + baseKey)) {
            return state.getChar(key + baseKey);
        }
        return null;
    }

    protected void putBoxedChar(Bundle state, String key, Character x) {
        if (x != null) {
            state.putChar(key + baseKey, x);
        }
    }

    protected char[] getCharArray(Bundle state, String key) {
        return state.getCharArray(key + baseKey);
    }

    protected void putCharArray(Bundle state, String key, char[] x) {
        state.putCharArray(key + baseKey, x);
    }

    protected String getString(Bundle state, String key) {
        return state.getString(key + baseKey);
    }

    protected void putString(Bundle state, String key, String x) {
        state.putString(key + baseKey, x);
    }

    protected String[] getStringArray(Bundle state, String key) {
        return state.getStringArray(key + baseKey);
    }

    protected void putStringAray(Bundle state, String key, String[] x) {
        state.putStringArray(key + baseKey, x);
    }

    protected CharSequence getCharSequence(Bundle state, String key) {
        return state.getCharSequence(key + baseKey);
    }

    protected void putCharSequence(Bundle state, String key, CharSequence x) {
        state.putCharSequence(key + baseKey, x);
    }

    protected CharSequence[] getCharSequenceArray(Bundle state, String key) {
        return state.getCharSequenceArray(key + baseKey);
    }

    protected void putCharSequenceArray(Bundle state, String key, CharSequence[] x) {
        state.putCharSequenceArray(key + baseKey, x);
    }

    protected Bundle getBundle(Bundle state, String key) {
        return state.getBundle(key + baseKey);
    }

    protected void putBundle(Bundle state, String key, Bundle x) {
        state.putBundle(key + baseKey, x);
    }

    protected <T extends Parcelable> T getParcelable(Bundle state, String key) {
        return state.getParcelable(key + baseKey);
    }

    protected void putParcelable(Bundle state, String key, Parcelable x) {
        state.putParcelable(key + baseKey, x);
    }

    protected Parcelable[] getParcelableArray(Bundle state, String key) {
        return state.getParcelableArray(key + baseKey);
    }

    protected void putParcelableArray(Bundle state, String key, Parcelable[] x) {
        state.putParcelableArray(key + baseKey, x);
    }

    protected <T extends Serializable> T getSerializable(Bundle state, String key) {
        return (T) state.getSerializable(key + baseKey);
    }

    protected void putSerializable(Bundle state, String key, Serializable x) {
        state.putSerializable(key + baseKey, x);
    }

    protected ArrayList<Integer> getIntegerArrayList(Bundle state, String key) {
        return state.getIntegerArrayList(key + baseKey);
    }

    protected void putIntegerArrayList(Bundle state, String key, ArrayList<Integer> x) {
        state.putIntegerArrayList(key + baseKey, x);
    }

    protected ArrayList<String> getStringArrayList(Bundle state, String key) {
        return state.getStringArrayList(key + baseKey);
    }

    protected void putStringArrayList(Bundle state, String key, ArrayList<String> x) {
        state.putStringArrayList(key + baseKey, x);
    }

    protected ArrayList<CharSequence> getCharSequenceArrayList(Bundle state, String key) {
        return state.getCharSequenceArrayList(key + baseKey);
    }

    protected void putCharSequenceArrayList(Bundle state, String key, ArrayList<CharSequence> x) {
        state.putCharSequenceArrayList(key + baseKey, x);
    }

    protected <T extends Parcelable> ArrayList<T> getParcelableArrayList(Bundle state, String key) {
        return state.getParcelableArrayList(key + baseKey);
    }

    protected void putParcelableArrayList(Bundle state, String key, ArrayList<Parcelable> x) {
        state.putParcelableArrayList(key + baseKey, x);
    }

    protected <T extends Parcelable> SparseArray<T> getSparseParcelableArray(Bundle state, String key) {
        return state.getSparseParcelableArray(key + baseKey);
    }

    protected void putSparseParcelableArray(Bundle state, String key, SparseArray<Parcelable> x) {
        state.putSparseParcelableArray(key + baseKey, x);
    }

    public static class Object<T> extends Injector {

        public void restore(T target, Bundle state) {
        }

        public void save(T target, Bundle state) {
        }
    }

    public static class ViewParent<T> extends Injector {
        public Parcelable restore(T target, Parcelable state) {
            return state;
        }

        public Parcelable save(T target, Parcelable state) {
            return state;
        }
    }

    public static class View<T> extends ViewParent<T> {
        protected Parcelable restoreSuperState(T target, Bundle state) {
            Parcelable superState = state.getParcelable(baseKey + "$$SUPER");
            return super.restore(target, superState);
        }

        protected Bundle saveSuperState(T target, Parcelable state) {
            Bundle outState = new Bundle();
            Parcelable superState = super.save(target, state);
            outState.putParcelable(baseKey + "$$SUPER", superState);
            return outState;
        }
    }
}
