;; In my brief experience writing and debugging nREPL middleware the process was
;; obscure and fragile in the extreme, including sporadic and seemingly
;; non-deterministic failures on superficially innocuous code changes like
;; trying to set the correct middleware description. Not sure if related to
;; Shadow CLJS. Thread with caution.

(ns playback.nrepl-middleware
  (:require [clojure.string :as string]
            [clojure.pprint :as pprint]))


(def ^:private ^:dynamic *reload-fn-sym* nil)
(def ^:private ^:dynamic *reloadable-ns-prefixes* [])
;; Call this from your user.clj, e.g.:
;; (middleware/init-reload-on-eval! 'gnl.clojure-playground.main/mount-root
;;                                  ["gnl.clojure-playground"])
(defn init-reload-on-eval!
  [reload-fn-sym reloadable-ns-prefixes]
  (alter-var-root #'*reload-fn-sym* (constantly reload-fn-sym))
  (alter-var-root #'*reloadable-ns-prefixes* (constantly reloadable-ns-prefixes)))


(def ^:private ^:dynamic *reload-on-trace-eval?* false)
(defn set-reload-on-trace-eval!
  [reload-on-trace-eval?]
  (alter-var-root #'*reload-on-trace-eval?* (constantly reload-on-trace-eval?)))


(def ^:private ^:dynamic *debug?* false)
(defn set-debug!
  [debug?]
  (alter-var-root #'*debug?* (constantly debug?)))


(defn reload-on-eval [handler]
  (fn [{:keys [op code ns] :as msg}]
    (if (and (= op "eval")
             (some #(string/starts-with? (str ns) %) *reloadable-ns-prefixes*)
             (or (not (string/starts-with? code "#>"))
                 *reload-on-trace-eval?*))
      (do
        (when *debug?*
          (println (str "\nEval and reload in " ns ":\n"))
          (pprint/pprint msg))
        (handler (assoc msg :code (str "(let [result (do " code ")]"
                                       "  (" *reload-fn-sym* ")"
                                       "  result)"))))
      (handler msg))))
