(ns com.github.ivarref.paginate-vector.impl.multi-last
  (:require [com.github.ivarref.paginate-vector.impl.single :as single]
            [clojure.edn :as edn]))


(defn maybe-paginate [prev-cursor f d new-opts]
  (if-let [{:keys [valid before]} prev-cursor]
    (if (and (= before 0)
             (= (nth valid 1) (count d)))
      (do
        #_(println "skipping")
        {})
      (single/paginate f d new-opts))
    (single/paginate f d new-opts)))


(defn paginate-multi-last [vectors f {:keys [item-count report-f-used]} cursor]
  (assert (fn? f) "Expected f to be a function")
  (assert (vector? vectors) "Expected vectors to be a vector")
  (assert (every? vector? vectors) "Expected every item in vectors to be a vector")
  (let [[_ edges pageInfo] (reduce
                             (fn [[prev-cursor o _pageInfo] [vector-idx d]]
                               (let [wrap-cursor-f (fn [cursor]
                                                     (assoc-in prev-cursor [:cursor vector-idx] cursor))
                                     new-opts (-> {:last (- item-count (count o))
                                                   :report-f-used report-f-used}
                                                  (merge (get-in cursor [:cursor vector-idx]))
                                                  (assoc :wrap-cursor-f wrap-cursor-f))
                                     {:keys [pageInfo edges]} (maybe-paginate (get-in cursor [:cursor vector-idx]) f d new-opts)]
                                 (let [edges (into edges o)
                                       res [(merge prev-cursor (some-> (:startCursor pageInfo) edn/read-string))
                                            edges
                                            pageInfo]]
                                   (if (pos-int? (- item-count (count edges)))
                                     res
                                     (reduced res)))))
                             [cursor [] {}]
                             (vec (map-indexed vector vectors)))]
    {:edges edges
     :pageInfo (assoc
                 pageInfo
                 :totalCount (reduce + 0 (mapv count vectors))
                 :startCursor (or (get (first edges) :cursor)
                                  (pr-str cursor))
                 :endCursor (or (get (last edges) :cursor)
                                (pr-str cursor)))}))