(ns com.github.ivarref.paginate-vector.impl.single-first
  (:require [com.github.ivarref.paginate-vector.impl.utils :as u]))


(defn pag-handler-first
  [f d {:keys [after]
        :as   opts}]
  (let [^Long fst (get opts :first)
        ^Long start (or (some-> after (inc)) 0)
        end (u/math-min (count d) (+ start fst))]
    (if (or
          (and (> start end) (not= start 0))
          (and (int? after)
               (or (> after (count d))
                   (neg-int? after))))
      (throw (ex-info "Bad input for :first" {:first fst :after after}))
      (let [edges (u/get-edges f d start end)]
        {:edges    edges
         :pageInfo {:startCursor (get (first edges) :cursor)
                    :endCursor   (get (last edges) :cursor)
                    :hasNextPage (not= end (count d))
                    :hasPrevPage (not= start 0)
                    :totalCount  (count d)}}))))

