(ns com.github.ivarref.paginate-vector.impl.multi-first
  (:require [com.github.ivarref.paginate-vector.impl.single :as single]
            [clojure.edn :as edn]))


(defn paginate-multi-first [vectors
                            f
                            item-count                      ; max number of items to return
                            cursor]
  (assert (fn? f) "Expected f to be a function")
  (assert (vector? vectors) "Expected vectors to be a vector")
  (assert (every? vector? vectors) "Expected every item in vectors to be a vector")
  (let [[edges pageInfo]
        (loop [prev-cursor cursor
               o []
               vector-idx (get cursor :vec-idx 0)
               seen-vecs 0]
          (let [d (nth vectors vector-idx)
                {:keys [pageInfo edges]}
                (single/paginate (fn [idx e]
                                   {:node   (f e)
                                    :cursor (-> prev-cursor
                                                (assoc-in [:cursor vector-idx] idx)
                                                (assoc :vec-idx vector-idx)
                                                (pr-str))})
                                 d
                                 {:first (- item-count (count o))
                                  :after (get-in cursor [:cursor vector-idx])})]
            (let [edges (into o edges)
                  res [edges pageInfo]
                  done? (= (inc seen-vecs) (count vectors))]
              (if (and (false? done?) (pos-int? (- item-count (count edges))))
                (recur (assoc (merge prev-cursor (or (some-> (:endCursor pageInfo) edn/read-string)
                                                     #_(-> prev-cursor
                                                           (assoc-in [:cursor vector-idx] after)
                                                           (assoc :vec-idx vector-idx))))
                         :vec-idx
                         vector-idx)
                       edges
                       (mod (inc vector-idx) (count vectors))
                       (inc seen-vecs))
                res))))]
       {:edges    edges
        :pageInfo (assoc
                    pageInfo
                    :startCursor (or (get (first edges) :cursor)
                                     (pr-str cursor))
                    :endCursor (or (get (last edges) :cursor)
                                   (pr-str cursor))
                    :totalCount (reduce + 0 (mapv count vectors)))}))