(ns com.github.ivarref.paginate-vector.impl.single-last
  (:require [com.github.ivarref.paginate-vector.impl.utils :as u]))


(defn pag-handler-last
  [f d {:keys [before valid wrap-cursor-f report-f-used]
        :or   {wrap-cursor-f identity}
        :as   opts}]
  (let [^Long lst (get opts :last)
        start-offset (first valid)
        end-exclusive (second valid)]
    (cond
      (nil? before)
      (pag-handler-last f d (assoc opts :before (count d)))

      (or (not (pos-int? lst))
          (neg-int? before)
          (> before (count d)))
      {:edges    []
       :pageInfo {:startCursor nil
                  :endCursor   nil
                  :hasNextPage false
                  :hasPrevPage false
                  :totalCount  -1}}

      (and (= before start-offset) (not= end-exclusive (count d)))
      (let [new-valid [end-exclusive (count d)]]
        (pag-handler-last f d (assoc opts :valid new-valid :before (count d))))

      :else
      (let [start (u/math-max start-offset (- before lst))
            num-elements (u/math-min (- (u/math-min before end-exclusive) start-offset) lst)
            end (+ start num-elements)
            edges (u/get-edges (fn [idx e]
                                 {:node   e
                                  :cursor (pr-str (wrap-cursor-f (assoc {} :valid valid :before idx)))})
                             d
                            start
                            end
                            report-f-used)
            mor (when (and (not-empty edges)
                           (not= num-elements lst)
                           (not= end-exclusive (count d))
                           (pos-int? (- lst (count edges))))
                  (let [new-opts (-> opts
                                     (update :last (fn [old-val] (- old-val (count edges))))
                                     (assoc :before start))]
                    (pag-handler-last f d new-opts)))]
        (let [edges (into edges (:edges mor))]
          {:edges    edges
           :pageInfo {:startCursor (or (get (first edges) :cursor)
                                       (pr-str (wrap-cursor-f (select-keys opts [:valid :before]))))
                      :endCursor   (or (get (last edges) :cursor)
                                       (pr-str (wrap-cursor-f (select-keys opts [:valid :before]))))
                      :hasNextPage (if mor
                                     (get-in mor [:pageInfo :hasNextPage])
                                     (not= start start-offset))
                      :hasPrevPage (not= (count d) end)
                      :totalCount  (count d)}})))))