(ns com.github.ivarref.paginate-vector.impl.bst-multi-last
  (:require [com.github.ivarref.paginate-vector.impl.bst :as bst]
            [clojure.edn :as edn]))


(defn maybe-decode-cursor [cursor]
  (when cursor
    (when (string? cursor)
      (edn/read-string cursor))))


(defn paginate-last [{:keys [root id opts]}
                     {:keys [max-items
                             f
                             keep?
                             context]
                      :or   {f       identity
                             context nil
                             keep?   (constantly true)}}
                     cursor]
  (let [sort-attrs (get opts :sort-by)
        max-items (inc max-items)]
    (let [org-cursor cursor
          decoded-cursor (maybe-decode-cursor cursor)
          cursor (atom (merge {:context context} decoded-cursor))
          all-nodes (transient [])
          last-node (transient [])

          [old-cursor _] (swap-vals! cursor assoc :id id)
          need-new-count? (not= (:id old-cursor) id)
          get-total-count (fn [old-count]
                            (or (and (false? need-new-count?)
                                     (when-let [oc old-count]
                                       oc))
                                (let [cnt (atom 0)]
                                  (bst/visit-all-depth-first
                                    root
                                    keep?
                                    (fn [_] (swap! cnt inc)))
                                  @cnt)))
          totalCount (:totalCount (swap! cursor (fn [cursor] (update cursor :totalCount get-total-count))))
          nodes (if-let [from-value (get @cursor :cursor)]
                  (bst/before-value root keep? from-value sort-attrs max-items)
                  (bst/from-end root keep? max-items))]
      (doseq [node nodes]
        (when (= node (last nodes))
          (conj! last-node node))
        (swap! cursor assoc :cursor (select-keys node sort-attrs))
        (conj! all-nodes {:node   (f node)
                          :cursor (pr-str @cursor)}))
      (let [all-nodes (persistent! all-nodes)
            edges (vec (take-last (dec max-items) all-nodes))
            hasPrevPage (or (let [last-node (persistent! last-node)]
                              (when (not-empty last-node)
                                (not= (first last-node)
                                      (bst/get-rightmost-value root keep?))))
                            (and (empty? all-nodes)
                                 (some? org-cursor)))]
        {:edges    edges
         :pageInfo {:hasPrevPage (true? hasPrevPage)
                    :hasNextPage (= (count all-nodes) max-items)
                    :startCursor (or (get (first edges) :cursor)
                                     org-cursor)
                    :endCursor   (or (get (last edges) :cursor)
                                     org-cursor)
                    :totalCount  totalCount}}))))

