(ns com.github.ivarref.paginate-vector.impl.single
  (:require [com.github.ivarref.paginate-vector.impl.single-first :as impl]
            [com.github.ivarref.paginate-vector.impl.single-last :as single-last]
            [clojure.string :as str]
            [clojure.edn :as edn]))


(defn try-parse-string [opts prop]
  (when-let [maybe-s (get opts prop)]
    (when (and (some? maybe-s) (string? maybe-s))
      (if (str/starts-with? maybe-s "{")
        (edn/read-string maybe-s)
        {prop (Long/valueOf ^String maybe-s)}))))


(defn parse-opts [opts]
  (merge
    opts
    (try-parse-string opts :before)
    (try-parse-string opts :after)))


(defn paginate [f d opts]
  (assert (fn? f) "Expected f to be a function")
  (assert (vector? d) "Expected d to be a vector")
  (assert (map? opts) "Expected opts to be a map")
  (let [opts (-> opts
                 (parse-opts)
                 (update :valid (fn [old-val] (or old-val [0 (count d)]))))]
    (cond
      (and (some? (get opts :first)) (some? (get opts :last)))
      (throw (ex-info "Both :first and :last given, don't know what to do." {:opts opts}))

      (and (some? (get opts :first)) (some? (get opts :before)))
      (throw (ex-info ":first and :before given, please use :first with :after" {:opts opts}))

      (and (some? (get opts :last)) (some? (get opts :after)))
      (throw (ex-info ":last and :after given, please use :last with :before" {:opts opts}))

      (pos-int? (get opts :first))
      (with-meta
        (impl/pag-handler-first f d opts)
        {:first (get opts :first)})

      (pos-int? (get opts :last))
      (with-meta
        (single-last/pag-handler-last f d opts)
        {:last (get opts :last)})

      :else
      (throw (ex-info "Bad opts given, expected either :first or :last to be a positive integer."
                      {:opts opts})))))