(ns com.github.ivarref.paginate-vector.impl.utils)

(defn math-max [^long a ^long b]
  (Math/max a b))

(defn math-min [^long a ^long b]
  (Math/min a b))


(defn get-edges [f d start end report-f-used]
  (let [start-time (System/nanoTime)
        edges (transient [])]
    (doseq [i (range start end)]
      (conj! edges (f i (nth d i))))
    (when report-f-used
      (report-f-used (- (System/nanoTime) start-time)))
    (persistent! edges)))