(ns com.github.ivarref.paginate-vector.impl.utils
  (:require [clojure.edn :as edn]))


(defn maybe-decode-cursor [cursor]
  (when cursor
    (when (string? cursor)
      (edn/read-string cursor))))


(defn get-cursor [opts]
  (or
    (let [cursor (or (get opts :after) (get opts :before))]
      (when (and (string? cursor) (not-empty cursor))
        (edn/read-string cursor)))
    {}))