/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.EntitiesData;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Parser;

public class Entities {
    private static final int empty = -1;
    private static final String emptyName = "";
    static final int codepointRadix = 36;
    private static final char[] codeDelims = new char[]{',', ';'};
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final Document.OutputSettings DefaultOutput = new Document.OutputSettings();

    private Entities() {
    }

    public static boolean isNamedEntity(String name2) {
        return EscapeMode.extended.codepointForName(name2) != -1;
    }

    public static boolean isBaseNamedEntity(String name2) {
        return EscapeMode.base.codepointForName(name2) != -1;
    }

    public static String getByName(String name2) {
        String val2 = multipoints.get(name2);
        if (val2 != null) {
            return val2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name2);
        if (codepoint != -1) {
            return new String(new int[]{codepoint}, 0, 1);
        }
        return emptyName;
    }

    public static int codepointsForName(String name2, int[] codepoints) {
        String val2 = multipoints.get(name2);
        if (val2 != null) {
            codepoints[0] = val2.codePointAt(0);
            codepoints[1] = val2.codePointAt(1);
            return 2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name2);
        if (codepoint != -1) {
            codepoints[0] = codepoint;
            return 1;
        }
        return 0;
    }

    public static String escape(String string2, Document.OutputSettings out) {
        if (string2 == null) {
            return emptyName;
        }
        StringBuilder accum = StringUtil.borrowBuilder();
        try {
            Entities.escape(accum, string2, out, false, false, false);
        }
        catch (IOException e2) {
            throw new SerializationException(e2);
        }
        return StringUtil.releaseBuilder(accum);
    }

    public static String escape(String string2) {
        return Entities.escape(string2, DefaultOutput);
    }

    static void escape(Appendable accum, String string2, Document.OutputSettings out, boolean inAttribute, boolean normaliseWhite, boolean stripLeadingWhite) throws IOException {
        int codePoint;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        EscapeMode escapeMode = out.escapeMode();
        CharsetEncoder encoder = out.encoder();
        CoreCharset coreCharset = out.coreCharset;
        int length = string2.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = string2.codePointAt(offset);
            if (normaliseWhite) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if (stripLeadingWhite && !reachedNonWhite || lastWasWhite) continue;
                    accum.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            if (codePoint < 65536) {
                char c = (char)codePoint;
                switch (c) {
                    case '&': {
                        accum.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            accum.append("&nbsp;");
                            break;
                        }
                        accum.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!inAttribute || escapeMode == EscapeMode.xhtml || out.syntax() == Document.OutputSettings.Syntax.xml) {
                            accum.append("&lt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '>': {
                        if (!inAttribute) {
                            accum.append("&gt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\"': {
                        if (inAttribute) {
                            accum.append("&quot;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        accum.append(c);
                        break;
                    }
                    default: {
                        if (c < ' ' || !Entities.canEncode(coreCharset, c, encoder)) {
                            Entities.appendEncoded(accum, escapeMode, codePoint);
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                }
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum.append(c);
                continue;
            }
            Entities.appendEncoded(accum, escapeMode, codePoint);
        }
    }

    private static void appendEncoded(Appendable accum, EscapeMode escapeMode, int codePoint) throws IOException {
        String name2 = escapeMode.nameForCodepoint(codePoint);
        if (!emptyName.equals(name2)) {
            accum.append('&').append(name2).append(';');
        } else {
            accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
        }
    }

    public static String unescape(String string2) {
        return Entities.unescape(string2, false);
    }

    static String unescape(String string2, boolean strict) {
        return Parser.unescapeEntities(string2, strict);
    }

    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        switch (charset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return fallback.canEncode(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(EscapeMode e2, String pointsData, int size) {
        EscapeMode.access$102(e2, new String[size]);
        EscapeMode.access$202(e2, new int[size]);
        EscapeMode.access$302(e2, new int[size]);
        EscapeMode.access$402(e2, new String[size]);
        int i = 0;
        try (CharacterReader reader2 = new CharacterReader(pointsData);){
            while (!reader2.isEmpty()) {
                int cp2;
                String name2 = reader2.consumeTo('=');
                reader2.advance();
                int cp1 = Integer.parseInt(reader2.consumeToAny(codeDelims), 36);
                char codeDelim = reader2.current();
                reader2.advance();
                if (codeDelim == ',') {
                    cp2 = Integer.parseInt(reader2.consumeTo(';'), 36);
                    reader2.advance();
                } else {
                    cp2 = -1;
                }
                String indexS = reader2.consumeTo('&');
                int index2 = Integer.parseInt(indexS, 36);
                reader2.advance();
                ((EscapeMode)e2).nameKeys[i] = name2;
                ((EscapeMode)e2).codeVals[i] = cp1;
                ((EscapeMode)e2).codeKeys[index2] = cp1;
                ((EscapeMode)e2).nameVals[index2] = name2;
                if (cp2 != -1) {
                    multipoints.put(name2, new String(new int[]{cp1, cp2}, 0, 2));
                }
                ++i;
            }
            Validate.isTrue(i == size, "Unexpected count of entities loaded");
        }
    }

    public static enum EscapeMode {
        xhtml(EntitiesData.xmlPoints, 4),
        base(EntitiesData.basePoints, 106),
        extended(EntitiesData.fullPoints, 2125);

        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;

        private EscapeMode(String file2, int size) {
            Entities.load(this, file2, size);
        }

        int codepointForName(String name2) {
            int index2 = Arrays.binarySearch(this.nameKeys, name2);
            return index2 >= 0 ? this.codeVals[index2] : -1;
        }

        String nameForCodepoint(int codepoint) {
            int index2 = Arrays.binarySearch(this.codeKeys, codepoint);
            if (index2 >= 0) {
                return index2 < this.nameVals.length - 1 && this.codeKeys[index2 + 1] == codepoint ? this.nameVals[index2 + 1] : this.nameVals[index2];
            }
            return Entities.emptyName;
        }

        private int size() {
            return this.nameKeys.length;
        }

        static /* synthetic */ String[] access$102(EscapeMode x0, String[] x1) {
            x0.nameKeys = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(EscapeMode x0, int[] x1) {
            x0.codeVals = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(EscapeMode x0, int[] x1) {
            x0.codeKeys = x1;
            return x1;
        }

        static /* synthetic */ String[] access$402(EscapeMode x0, String[] x1) {
            x0.nameVals = x1;
            return x1;
        }
    }

    static enum CoreCharset {
        ascii,
        utf,
        fallback;


        static CoreCharset byName(String name2) {
            if (name2.equals("US-ASCII")) {
                return ascii;
            }
            if (name2.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }
    }
}

