/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import javax.annotation.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;

public class Comment
extends LeafNode {
    public Comment(String data2) {
        this.value = data2;
    }

    @Override
    public String nodeName() {
        return "#comment";
    }

    public String getData() {
        return this.coreValue();
    }

    public Comment setData(String data2) {
        this.coreValue(data2);
        return this;
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.prettyPrint() && (this.siblingIndex() == 0 && this.parentNode instanceof Element && ((Element)this.parentNode).tag().formatAsBlock() || out.outline())) {
            this.indent(accum, depth, out);
        }
        accum.append("<!--").append(this.getData()).append("-->");
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    public boolean isXmlDeclaration() {
        String data2 = this.getData();
        return Comment.isXmlDeclarationData(data2);
    }

    private static boolean isXmlDeclarationData(String data2) {
        return data2.length() > 1 && (data2.startsWith("!") || data2.startsWith("?"));
    }

    @Nullable
    public XmlDeclaration asXmlDeclaration() {
        String data2 = this.getData();
        XmlDeclaration decl = null;
        String declContent = data2.substring(1, data2.length() - 1);
        if (Comment.isXmlDeclarationData(declContent)) {
            return null;
        }
        String fragment = "<" + declContent + ">";
        Document doc2 = Parser.htmlParser().settings(ParseSettings.preserveCase).parseInput(fragment, this.baseUri());
        if (doc2.body().children().size() > 0) {
            Element el = doc2.body().child(0);
            decl = new XmlDeclaration(NodeUtils.parser(doc2).settings().normalizeTag(el.tagName()), data2.startsWith("!"));
            decl.attributes().addAll(el.attributes());
        }
        return decl;
    }
}

