/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    @Nullable
    private String val;
    @Nullable
    Attributes parent;
    private static final Pattern xmlKeyValid = Pattern.compile("[a-zA-Z_:][-a-zA-Z0-9_:.]*");
    private static final Pattern xmlKeyReplace = Pattern.compile("[^-a-zA-Z0-9_:.]");
    private static final Pattern htmlKeyValid = Pattern.compile("[^\\x00-\\x1f\\x7f-\\x9f \"'/=]+");
    private static final Pattern htmlKeyReplace = Pattern.compile("[\\x00-\\x1f\\x7f-\\x9f \"'/=]");

    public Attribute(String key2, @Nullable String value) {
        this(key2, value, null);
    }

    public Attribute(String key2, @Nullable String val2, @Nullable Attributes parent) {
        Validate.notNull(key2);
        key2 = key2.trim();
        Validate.notEmpty(key2);
        this.key = key2;
        this.val = val2;
        this.parent = parent;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key2) {
        int i;
        Validate.notNull(key2);
        key2 = key2.trim();
        Validate.notEmpty(key2);
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            this.parent.keys[i] = key2;
        }
        this.key = key2;
    }

    @Override
    public String getValue() {
        return Attributes.checkNotNull(this.val);
    }

    public boolean hasDeclaredValue() {
        return this.val != null;
    }

    @Override
    public String setValue(@Nullable String val2) {
        int i;
        String oldVal = this.val;
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            oldVal = this.parent.get(this.key);
            this.parent.vals[i] = val2;
        }
        this.val = val2;
        return Attributes.checkNotNull(oldVal);
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return StringUtil.releaseBuilder(sb);
    }

    protected void html(Appendable accum, Document.OutputSettings out) throws IOException {
        Attribute.html(this.key, this.val, accum, out);
    }

    protected static void html(String key2, @Nullable String val2, Appendable accum, Document.OutputSettings out) throws IOException {
        if ((key2 = Attribute.getValidKey(key2, out.syntax())) == null) {
            return;
        }
        Attribute.htmlNoValidate(key2, val2, accum, out);
    }

    static void htmlNoValidate(String key2, @Nullable String val2, Appendable accum, Document.OutputSettings out) throws IOException {
        accum.append(key2);
        if (!Attribute.shouldCollapseAttribute(key2, val2, out)) {
            accum.append("=\"");
            Entities.escape(accum, Attributes.checkNotNull(val2), out, true, false, false);
            accum.append('\"');
        }
    }

    @Nullable
    public static String getValidKey(String key2, Document.OutputSettings.Syntax syntax) {
        if (syntax == Document.OutputSettings.Syntax.xml && !xmlKeyValid.matcher(key2).matches()) {
            return xmlKeyValid.matcher(key2 = xmlKeyReplace.matcher(key2).replaceAll("")).matches() ? key2 : null;
        }
        if (syntax == Document.OutputSettings.Syntax.html && !htmlKeyValid.matcher(key2).matches()) {
            return htmlKeyValid.matcher(key2 = htmlKeyReplace.matcher(key2).replaceAll("")).matches() ? key2 : null;
        }
        return key2;
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value, null);
    }

    protected boolean isDataAttribute() {
        return Attribute.isDataAttribute(this.key);
    }

    protected static boolean isDataAttribute(String key2) {
        return key2.startsWith("data-") && key2.length() > "data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings out) {
        return Attribute.shouldCollapseAttribute(this.key, this.val, out);
    }

    protected static boolean shouldCollapseAttribute(String key2, @Nullable String val2, Document.OutputSettings out) {
        return out.syntax() == Document.OutputSettings.Syntax.html && (val2 == null || (val2.isEmpty() || val2.equalsIgnoreCase(key2)) && Attribute.isBooleanAttribute(key2));
    }

    public static boolean isBooleanAttribute(String key2) {
        return Arrays.binarySearch(booleanAttributes, key2) >= 0;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return this.val != null ? this.val.equals(attribute.val) : attribute.val == null;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.val != null ? this.val.hashCode() : 0);
        return result;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

