/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CDom {
    public static final String SourceProperty = "jsoupSource";
    public static final String XPathFactoryProperty = "javax.xml.xpath.XPathFactory:jsoup";
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public static org.w3c.dom.Document convert(Document in) {
        return new W3CDom().fromJsoup(in);
    }

    public static String asString(org.w3c.dom.Document doc2, @Nullable Map<String, String> properties) {
        try {
            DOMSource domSource = new DOMSource(doc2);
            StringWriter writer2 = new StringWriter();
            StreamResult result = new StreamResult(writer2);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (properties != null) {
                transformer.setOutputProperties(W3CDom.propertiesFromMap(properties));
            }
            if (doc2.getDoctype() != null) {
                DocumentType doctype = doc2.getDoctype();
                if (!StringUtil.isBlank(doctype.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (!StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                } else if (doctype.getName().equalsIgnoreCase("html") && StringUtil.isBlank(doctype.getPublicId()) && StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform(domSource, result);
            return writer2.toString();
        }
        catch (TransformerException e2) {
            throw new IllegalStateException(e2);
        }
    }

    static Properties propertiesFromMap(Map<String, String> map2) {
        Properties props = new Properties();
        props.putAll(map2);
        return props;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    private static HashMap<String, String> methodMap(String method) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("method", method);
        return map2;
    }

    public org.w3c.dom.Document fromJsoup(Document in) {
        return this.fromJsoup((org.jsoup.nodes.Element)in);
    }

    public org.w3c.dom.Document fromJsoup(org.jsoup.nodes.Element in) {
        Validate.notNull(in);
        try {
            org.jsoup.nodes.DocumentType doctype;
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            DOMImplementation impl2 = builder.getDOMImplementation();
            org.w3c.dom.Document out = builder.newDocument();
            Document inDoc = in.ownerDocument();
            org.jsoup.nodes.DocumentType documentType = doctype = inDoc != null ? inDoc.documentType() : null;
            if (doctype != null) {
                DocumentType documentType2 = impl2.createDocumentType(doctype.name(), doctype.publicId(), doctype.systemId());
                out.appendChild(documentType2);
            }
            out.setXmlStandalone(true);
            this.convert(in, out);
            return out;
        }
        catch (ParserConfigurationException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void convert(Document in, org.w3c.dom.Document out) {
        this.convert((org.jsoup.nodes.Element)in, out);
    }

    public void convert(org.jsoup.nodes.Element in, org.w3c.dom.Document out) {
        Document inDoc = in.ownerDocument();
        if (inDoc != null && !StringUtil.isBlank(inDoc.location())) {
            out.setDocumentURI(inDoc.location());
        }
        org.jsoup.nodes.Element rootEl = in instanceof Document ? in.child(0) : in;
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(out), rootEl);
    }

    public NodeList selectXpath(String xpath, org.w3c.dom.Document doc2) {
        NodeList nodeList;
        Validate.notEmpty(xpath);
        Validate.notNull(doc2);
        try {
            String property = System.getProperty(XPathFactoryProperty);
            XPathFactory xPathFactory = property != null ? XPathFactory.newInstance("jsoup") : XPathFactory.newInstance();
            XPathExpression expression = xPathFactory.newXPath().compile(xpath);
            nodeList = (NodeList)expression.evaluate(doc2, XPathConstants.NODESET);
            Validate.notNull(nodeList);
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException e2) {
            throw new Selector.SelectorParseException("Could not evaluate XPath query [%s]: %s", xpath, e2.getMessage());
        }
        return nodeList;
    }

    public <T extends Node> List<T> sourceNodes(NodeList nodeList, Class<T> nodeType) {
        Validate.notNull(nodeList);
        Validate.notNull(nodeType);
        ArrayList<Node> nodes = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            Object source2 = node2.getUserData(SourceProperty);
            if (!nodeType.isInstance(source2)) continue;
            nodes.add((Node)nodeType.cast(source2));
        }
        return nodes;
    }

    public String asString(org.w3c.dom.Document doc2) {
        return W3CDom.asString(doc2, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private org.w3c.dom.Node dest;

        public W3CBuilder(org.w3c.dom.Document doc2) {
            this.doc = doc2;
            this.namespacesStack.push(new HashMap());
            this.dest = doc2;
        }

        @Override
        public void head(Node source2, int depth) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source2 instanceof org.jsoup.nodes.Element) {
                org.jsoup.nodes.Element sourceEl = (org.jsoup.nodes.Element)source2;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace2 = this.namespacesStack.peek().get(prefix);
                String tagName = sourceEl.tagName();
                try {
                    Element el = namespace2 == null && tagName.contains(":") ? this.doc.createElementNS("", tagName) : this.doc.createElementNS(namespace2, tagName);
                    this.copyAttributes(sourceEl, el);
                    this.append(el, sourceEl);
                    this.dest = el;
                }
                catch (DOMException e2) {
                    this.append(this.doc.createTextNode("<" + tagName + ">"), sourceEl);
                }
            } else if (source2 instanceof TextNode) {
                TextNode sourceText = (TextNode)source2;
                Text text = this.doc.createTextNode(sourceText.getWholeText());
                this.append(text, sourceText);
            } else if (source2 instanceof org.jsoup.nodes.Comment) {
                org.jsoup.nodes.Comment sourceComment = (org.jsoup.nodes.Comment)source2;
                Comment comment2 = this.doc.createComment(sourceComment.getData());
                this.append(comment2, sourceComment);
            } else if (source2 instanceof DataNode) {
                DataNode sourceData = (DataNode)source2;
                Text node2 = this.doc.createTextNode(sourceData.getWholeData());
                this.append(node2, sourceData);
            }
        }

        private void append(org.w3c.dom.Node append, Node source2) {
            append.setUserData(W3CDom.SourceProperty, source2, null);
            this.dest.appendChild(append);
        }

        @Override
        public void tail(Node source2, int depth) {
            if (source2 instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node source2, Element el) {
            for (Attribute attribute : source2.attributes()) {
                String key2 = Attribute.getValidKey(attribute.getKey(), Document.OutputSettings.Syntax.xml);
                if (key2 == null) continue;
                el.setAttribute(key2, attribute.getValue());
            }
        }

        private String updateNamespaces(org.jsoup.nodes.Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key2 = attr.getKey();
                if (key2.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!key2.startsWith(xmlnsPrefix)) continue;
                    prefix = key2.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf(58);
            return pos > 0 ? el.tagName().substring(0, pos) : "";
        }
    }
}

