/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    public static void traverse(NodeVisitor visitor, Node root2) {
        Validate.notNull(visitor);
        Validate.notNull(root2);
        Node node2 = root2;
        int depth = 0;
        while (node2 != null) {
            Node parent = node2.parentNode();
            visitor.head(node2, depth);
            if (parent != null && !node2.hasParent()) {
                node2 = parent.childNode(node2.siblingIndex());
            }
            if (node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node2 != null);
                if (node2.nextSibling() != null || depth <= 0) break;
                visitor.tail(node2, depth);
                node2 = node2.parentNode();
                --depth;
            }
            visitor.tail(node2, depth);
            if (node2 == root2) break;
            node2 = node2.nextSibling();
        }
    }

    public static void traverse(NodeVisitor visitor, Elements elements) {
        Validate.notNull(visitor);
        Validate.notNull(elements);
        for (Element el : elements) {
            NodeTraversor.traverse(visitor, el);
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter filter2, Node root2) {
        Node node2 = root2;
        int depth = 0;
        while (node2 != null) {
            Node prev2;
            NodeFilter.FilterResult result = filter2.head(node2, depth);
            if (result == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (result == NodeFilter.FilterResult.CONTINUE && node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node2 != null);
                if (node2.nextSibling() != null || depth <= 0) break;
                if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter2.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                    return result;
                }
                prev2 = node2;
                node2 = node2.parentNode();
                --depth;
                if (result == NodeFilter.FilterResult.REMOVE) {
                    prev2.remove();
                }
                result = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result == NodeFilter.FilterResult.CONTINUE || result == NodeFilter.FilterResult.SKIP_CHILDREN) && (result = filter2.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                return result;
            }
            if (node2 == root2) {
                return result;
            }
            prev2 = node2;
            node2 = node2.nextSibling();
            if (result != NodeFilter.FilterResult.REMOVE) continue;
            prev2.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public static void filter(NodeFilter filter2, Elements elements) {
        Element el;
        Validate.notNull(filter2);
        Validate.notNull(elements);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext() && NodeTraversor.filter(filter2, el = (Element)iterator.next()) != NodeFilter.FilterResult.STOP) {
        }
    }
}

