(ns {{ns-name}}.command
  (:require [slash.command :refer [defhandler defpaths]]
            [slash.response :as rsp]
            [slash.command.structure :as cmd]))

(def greet-command
  (cmd/command
   "greet"
   "Send a greeting."
   :options
   [(cmd/option "user" "The user to greet." :user)]))

(comment
  (require '[discljord.messaging :as dm])
  (def conn (dm/start-connection! "token"))
  @(dm/bulk-overwrite-guild-application-commands! conn (:id @(dm/get-current-user! conn)) "guild-id" [greet-command]))

(defhandler greet-handler
  ["greet"]
  _interaction
  [user]
  (-> {:content (str ":wave: Hey there" (when user (str ", <@" user ">")) \!)}
      rsp/channel-message))

(defpaths command-paths
  #'greet-handler)
