/*
 * Decompiled with CFR 0.152.
 */
package com.github.kevinsawicki.timeago;

import com.github.kevinsawicki.timeago.Messages;
import java.text.MessageFormat;
import java.util.Date;

public class TimeAgo {
    private String prefixAgo = null;
    private String prefixFromNow = null;
    private String suffixAgo = Messages.getString("TimeAgo.AGO");
    private String suffixFromNow = Messages.getString("TimeAgo.SUFFIX_FROM_NOW");
    private String seconds = Messages.getString("TimeAgo.SECONDS");
    private String minute = Messages.getString("TimeAgo.MINUTE");
    private String minutes = Messages.getString("TimeAgo.MINUTES");
    private String hour = Messages.getString("TimeAgo.HOUR");
    private String hours = Messages.getString("TimeAgo.HOURS");
    private String day = Messages.getString("TimeAgo.DAY");
    private String days = Messages.getString("TimeAgo.DAYS");
    private String month = Messages.getString("TimeAgo.MONTH");
    private String months = Messages.getString("TimeAgo.MONTHS");
    private String year = Messages.getString("TimeAgo.YEAR");
    private String years = Messages.getString("TimeAgo.YEARS");

    public String timeUntil(Date date) {
        return this.timeUntil(date.getTime());
    }

    public String timeAgo(Date date) {
        return this.timeAgo(date.getTime());
    }

    public String timeUntil(long millis) {
        return this.time(millis - System.currentTimeMillis(), true);
    }

    public String timeAgo(long millis) {
        return this.time(System.currentTimeMillis() - millis, false);
    }

    public String time(long distanceMillis, boolean allowFuture) {
        String suffix;
        String prefix;
        if (allowFuture && distanceMillis < 0L) {
            distanceMillis = Math.abs(distanceMillis);
            prefix = this.prefixFromNow;
            suffix = this.suffixFromNow;
        } else {
            prefix = this.prefixAgo;
            suffix = this.suffixAgo;
        }
        double seconds = distanceMillis / 1000L;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        double days = hours / 24.0;
        double years = days / 365.0;
        String time = seconds < 45.0 ? this.seconds : (seconds < 90.0 ? this.minute : (minutes < 45.0 ? MessageFormat.format(this.minutes, Math.round(minutes)) : (minutes < 90.0 ? this.hour : (hours < 24.0 ? MessageFormat.format(this.hours, Math.round(hours)) : (hours < 48.0 ? this.day : (days < 30.0 ? MessageFormat.format(this.days, Math.floor(days)) : (days < 60.0 ? this.month : (days < 365.0 ? MessageFormat.format(this.months, Math.floor(days / 30.0)) : (years < 2.0 ? this.year : MessageFormat.format(this.years, Math.floor(years)))))))))));
        return this.join(prefix, time, suffix);
    }

    public String join(String prefix, String time, String suffix) {
        StringBuilder joined = new StringBuilder();
        if (prefix != null && prefix.length() > 0) {
            joined.append(prefix).append(' ');
        }
        joined.append(time);
        if (suffix != null && suffix.length() > 0) {
            joined.append(' ').append(suffix);
        }
        return joined.toString();
    }

    public String getPrefixAgo() {
        return this.prefixAgo;
    }

    public TimeAgo setPrefixAgo(String prefixAgo) {
        this.prefixAgo = prefixAgo;
        return this;
    }

    public String getPrefixFromNow() {
        return this.prefixFromNow;
    }

    public TimeAgo setPrefixFromNow(String prefixFromNow) {
        this.prefixFromNow = prefixFromNow;
        return this;
    }

    public String getSuffixAgo() {
        return this.suffixAgo;
    }

    public TimeAgo setSuffixAgo(String suffixAgo) {
        this.suffixAgo = suffixAgo;
        return this;
    }

    public String getSuffixFromNow() {
        return this.suffixFromNow;
    }

    public TimeAgo setSuffixFromNow(String suffixFromNow) {
        this.suffixFromNow = suffixFromNow;
        return this;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public TimeAgo setSeconds(String seconds) {
        this.seconds = seconds;
        return this;
    }

    public String getMinute() {
        return this.minute;
    }

    public TimeAgo setMinute(String minute) {
        this.minute = minute;
        return this;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public TimeAgo setMinutes(String minutes) {
        this.minutes = minutes;
        return this;
    }

    public String getHour() {
        return this.hour;
    }

    public TimeAgo setHour(String hour) {
        this.hour = hour;
        return this;
    }

    public String getHours() {
        return this.hours;
    }

    public TimeAgo setHours(String hours) {
        this.hours = hours;
        return this;
    }

    public String getDay() {
        return this.day;
    }

    public TimeAgo setDay(String day) {
        this.day = day;
        return this;
    }

    public String getDays() {
        return this.days;
    }

    public TimeAgo setDays(String days) {
        this.days = days;
        return this;
    }

    public String getMonth() {
        return this.month;
    }

    public TimeAgo setMonth(String month) {
        this.month = month;
        return this;
    }

    public String getMonths() {
        return this.months;
    }

    public TimeAgo setMonths(String months) {
        this.months = months;
        return this;
    }

    public String getYear() {
        return this.year;
    }

    public TimeAgo setYear(String year) {
        this.year = year;
        return this;
    }

    public String getYears() {
        return this.years;
    }

    public TimeAgo setYears(String years) {
        this.years = years;
        return this;
    }
}

