(ns telsos.lib.validation)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defmacro invalid
  ([message data]
   `(invalid {:message           ~message
              :data              ~data
              :with-stack-trace? false}))

  ([{:keys [message data cause with-stack-trace?]}]
   (let [file (str *file*)
         line (long (or (-> &form meta :line) -1))]

     `(throw (telsos.lib.ValidationException.
               (str ~message)
               ~cause
               (boolean ~with-stack-trace?)
               ~file
               ~line
               ~data)))))

(defmacro validating
  [& body]
  `(try (do ~@body)
        (catch telsos.lib.ValidationException e# (throw e#))
        (catch java.lang.Exception e#
          (invalid {:message           (.getMessage e#)
                    :data              {}
                    :cause             e#
                    :with-stack-trace? false}))

        (catch Throwable t# (throw t#))))
