/*
 * Decompiled with CFR 0.152.
 */
package telsos.lib;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import telsos.lib.Threads;

public final class PerfStats {
    private final Lock lock = new ReentrantLock();
    private long accNanos;
    private long n;
    private final long lastN;

    public PerfStats() {
        this(Long.MAX_VALUE);
    }

    public PerfStats(long l) {
        this.lastN = l;
    }

    public void update(long l, long l2) {
        Threads.execLocking(this.lock, () -> this.updateImpl(l, l2));
    }

    private void updateImpl(long l, long l2) {
        long l3 = l2 - l;
        if (this.n == this.lastN) {
            this.accNanos = l3;
            this.n = 1L;
        } else {
            this.accNanos += l3;
            ++this.n;
        }
    }

    public double[] statsMsecs() {
        AtomicReference atomicReference = new AtomicReference();
        Threads.execLocking(this.lock, () -> this.statsMsecsImpl(atomicReference));
        return (double[])atomicReference.get();
    }

    private void statsMsecsImpl(AtomicReference<double[]> atomicReference) {
        double d = (double)this.accNanos / (double)this.n;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        atomicReference.set(new double[]{this.n, (double)this.accNanos / 1000000.0, d / 1000000.0});
    }

    public void reset() {
        Threads.execLocking(this.lock, this::resetImpl);
    }

    private void resetImpl() {
        this.accNanos = 0L;
        this.n = 0L;
    }
}

