(ns telsos.lib.algorithms.trees
  (:require
   [telsos.lib.algorithms.paip :as paip]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

;; EXTRACTION OF PATHS FROM THE TREES
(defrecord ^:private TreePathIncomplete [nodes])
(defrecord ^:private TreePathComplete   [nodes])
(defrecord TreeEntry [parent-node index-or-key node])

(defn- tree-path-adjs
  [adjs {:keys [nodes] :as path}]
  (when (instance? TreePathIncomplete path)
    (if-let [adj-nodes (seq (adjs (first nodes)))]
      (map #(->TreePathIncomplete (cons % nodes)) adj-nodes)

      [(->TreePathComplete nodes)])))

(defn- tree-path->associative-keys
  [{:keys [nodes]} repr]
  (->> nodes
       (map (fn [node]
              (or (when (instance? TreeEntry node) (:index-or-key node))
                  (repr node)
                  (str  node))))
       (reverse)
       (vec)))

(defn tree->associative-paths
  [e adjs repr]
  (->> (paip/breadth-first-tree-seq
         (->TreePathIncomplete (list e))
         (partial tree-path-adjs adjs))

       (filter #(instance? TreePathComplete %))
       (map    #(tree-path->associative-keys % repr))))
