(ns telsos.lib.time
  (:require
   [telsos.lib.human-readable :as human-readable]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn stopwatch {:inline (fn [] `(System/nanoTime))}
  []
  (System/nanoTime))

(defn elapsed-nanosecs ^long
  [^long swatch]
  (- (System/nanoTime) swatch))

(defn elapsed-msecs ^double
  [^long swatch]
  (/ (double (elapsed-nanosecs swatch)) 1e6))

(defn elapstr ^String
  [^long swatch]
  (human-readable/human-readable-nanosecs
    (elapsed-nanosecs swatch) #_digits 2))

(defn catimela
  [body {:keys [msg]}]
  (let [start (stopwatch)
        value (body)
        msecs (elapsed-msecs start)
        msg   (if msg (str msg " elapsed ") "elapsed ")]

    (println (str msg  msecs " msecs"))

    #_returning value))
