(ns perfortress.docker
  (:require
   [schema.core :as s])
  (:import
   [com.spotify.docker.client DefaultDockerClient DockerCertificates]
   [java.nio.file Paths]
   [java.net URI]))

(def DockerClientConfig {:uri       s/Str
                         :cert-path s/Str})

(s/defn make-docker-client
  ([]
   (.. (DefaultDockerClient/fromEnv) build))
  ([config :- DockerClientConfig]
   (let [builder (DefaultDockerClient/builder)]
     (.uri builder (:uri config))
     (.dockerCertificates
      builder
      (->
       (DockerCertificates/builder)
       (.dockerCertPath (Paths/get (URI. (str "file://" (:cert-path config)))))
       .build
       .get))
     (.build builder))))

(s/defn list-images
  ([cli]
   (.listImages cli (make-array com.spotify.docker.client.DockerClient$ListImagesParam 0)))
  ([cli params]
   (->>
    params
    (map (fn [[k v]] (com.spotify.docker.client.DockerClient$ListImagesParam. k v)))
    (into-array com.spotify.docker.client.DockerClient$ListImagesParam)
    (.listImages cli))))

(s/defn info [cli]
  (.info cli))

(comment
  (def cli
    (make-docker-client {:uri       "https://192.168.99.100:2376"
                         :cert-path (format "%s/.docker/machine/certs" (System/getProperty "user.home"))}))

  (def cli (make-docker-client))
  (bean (info cli))
  (-> cli info)

  (count (list-images cli))


  ("perfortress-p4d:1.0")

  )

;; TODO: movet this into its own library



;; (defn docker-config []
;;   (->
;;    "config/docker.json"
;;    slurp
;;    (json/read-str :key-fn keyword)))

;; (defn config->docker-client-config [config]
;;   (let [builder (com.github.dockerjava.core.DockerClientConfig/createDefaultConfigBuilder)]
;;     (when (:uri config)
;;       (.withUri builder (:uri config)))
;;     (when (:cert-path config)
;;       (.withDockerCertPath builder (:cert-path config)))
;;     (when (:registry-username config)
;;      (.withRegistryUsername builder (:registry-username config)))
;;     (when (:registry-password config)
;;       (.withRegistryPassword builder (:registry-username config)))
;;     (when (:registry-email config)
;;       (.withRegistryEmail builder (:registry-email config)))
;;     (.build builder)))

;; (defn make-docker-client [config]
;;   (let [docker-client-config  (config->docker-client-config config)
;;         docker-client-builder (com.github.dockerjava.core.DockerClientBuilder/getInstance docker-client-config)
;;         cmd-exec-factory      (doto
;;                                   (com.github.dockerjava.jaxrs.DockerCmdExecFactoryImpl.)
;;                                 (.withReadTimeout (int 1000))
;;                                 (.withConnectTimeout (int 1000))
;;                                 (.withMaxTotalConnections (int 10))
;;                                 (.withMaxPerRouteConnections (int 10)))]
;;     (.withDockerCmdExecFactory docker-client-builder cmd-exec-factory)
;;     (.build docker-client-builder)))

;; (comment
;;   (def testclient (make-docker-client (docker-config)))

;;   (-> testclient
;;       .infoCmd
;;       .exec)


;;   )

;; (defn with-perforce-docker [f]
;;   (let [config (docker-config)]
;;     (try
;;       ;; shut down the running container if there is one
;;       ()
;;       ;; start it up
;;       (f)
;;       (finally
;;         ;; shut down the running container if there is one
;;         ))))
