(ns ^{:mranderson/inlined true} mrandersonicednrepl.rewrite-clj.v0v6v1.rewrite-clj.node.regex
  (:require [mrandersonicednrepl.rewrite-clj.v0v6v1.rewrite-clj.node.protocols :as node]))


;; ## Node

(defrecord RegexNode [pattern]
  mrandersonicednrepl.rewrite-clj.v0v6v1.rewrite-clj.node.protocols/Node
  (tag [_] :regex)
  (printable-only? [_] false)
  (sexpr [_] (list 're-pattern pattern))
  (length [_] 1)
  (string [_] (str "#\"" pattern "\"")))

(node/make-printable! RegexNode)

;; ## Constructor

(defn regex-node
  "Create node representing a regex"
  [pattern-string]
  (->RegexNode pattern-string))
