/*
 * Decompiled with CFR 0.152.
 */
package mesosphere.marathon.client.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mesosphere.marathon.client.model.v2.Container;
import mesosphere.marathon.client.model.v2.Docker;
import mesosphere.marathon.client.model.v2.HealthCheck;
import mesosphere.marathon.client.model.v2.Parameter;
import mesosphere.marathon.client.model.v2.Port;
import mesosphere.marathon.client.model.v2.Task;
import mesosphere.marathon.client.model.v2.UpgradeStrategy;
import mesosphere.marathon.client.model.v2.Volume;
import mesosphere.marathon.client.utils.ModelUtils;

public class App {
    private String id;
    private String cmd;
    private Integer instances;
    private Double cpus;
    private Double mem;
    private Map<String, String> labels;
    private Collection<String> uris;
    private List<List<String>> constraints;
    private Container container;
    private Map<String, String> env;
    private String executor;
    private List<Integer> ports;
    private Collection<Task> tasks;
    private Integer tasksStaged;
    private Integer tasksRunning;
    private List<HealthCheck> healthChecks;
    private UpgradeStrategy upgradeStrategy;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public Integer getInstances() {
        return this.instances;
    }

    public void setInstances(Integer instances) {
        this.instances = instances;
    }

    public Double getCpus() {
        return this.cpus;
    }

    public void setCpus(Double cpus) {
        this.cpus = cpus;
    }

    public Double getMem() {
        return this.mem;
    }

    public void setMem(Double mem) {
        this.mem = mem;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Collection<String> getUris() {
        return this.uris;
    }

    public void setUris(Collection<String> uris) {
        this.uris = uris;
    }

    public List<List<String>> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<List<String>> constraints) {
        this.constraints = constraints;
    }

    public void addConstraint(String attribute, String operator, String value) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<List<String>>();
        }
        ArrayList<String> constraint = new ArrayList<String>(3);
        constraint.add(attribute == null ? "" : attribute);
        constraint.add(operator == null ? "" : operator);
        constraint.add(value == null ? "" : value);
        this.constraints.add(constraint);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Integer> ports) {
        this.ports = ports;
    }

    public void addUri(String uri) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(uri);
    }

    public void addPort(int port) {
        if (this.ports == null) {
            this.ports = new ArrayList<Integer>();
        }
        this.ports.add(port);
    }

    public Collection<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        this.tasks = tasks;
    }

    public Integer getTasksStaged() {
        return this.tasksStaged;
    }

    public void setTasksStaged(Integer tasksStaged) {
        this.tasksStaged = tasksStaged;
    }

    public Integer getTasksRunning() {
        return this.tasksRunning;
    }

    public void setTasksRunning(Integer tasksRunning) {
        this.tasksRunning = tasksRunning;
    }

    public List<HealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<HealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public UpgradeStrategy getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    public void setUpgradeStrategy(UpgradeStrategy upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
    }

    public String toString() {
        return ModelUtils.toString(this);
    }

    public static DockerAppBuilder dockerAppBuilder(String appId, String dockerImage, Double cpus, Double mem, Integer instances) {
        return new DockerAppBuilder(appId, dockerImage, cpus, mem, instances);
    }

    public static class DockerAppBuilder {
        private Collection<Port> portMappings = new ArrayList<Port>();
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private String network = "BRIDGE";
        private String appId = null;
        private Integer instances = 1;
        private String dockerImage = null;
        private Double cpus = null;
        private Double mem = null;
        private boolean forcePullImage = false;
        private boolean privileged = false;
        private Collection<Volume> volumes = new ArrayList<Volume>();

        public DockerAppBuilder(String appId, String dockerImage, Double cpus, Double mem, Integer instances) {
            this.appId = appId;
            this.dockerImage = dockerImage;
            this.cpus = cpus;
            this.mem = mem;
            this.instances = instances;
        }

        public DockerAppBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public DockerAppBuilder paramter(String key, String value) {
            Parameter parameter = new Parameter(key, value);
            this.parameters.add(parameter);
            return this;
        }

        public DockerAppBuilder volume(String containerPath, String hostPath, String mode) {
            Volume volume = new Volume();
            volume.setContainerPath(containerPath);
            volume.setHostPath(hostPath);
            volume.setMode(mode);
            this.volumes.add(volume);
            return this;
        }

        public DockerAppBuilder volume(String containerPath, String hostPath) {
            this.volume(containerPath, hostPath, null);
            return this;
        }

        public DockerAppBuilder portMappings(Integer containerPort, Integer hostPort) {
            Port port = this.buildPort(containerPort, hostPort);
            this.portMappings.add(port);
            return this;
        }

        public DockerAppBuilder portMappings(Integer containerPort) {
            this.portMappings(containerPort, null);
            return this;
        }

        private Port buildPort(Integer containerPort, Integer hostPort) {
            Port port = new Port(containerPort);
            port.setHostPort(hostPort);
            return port;
        }

        public DockerAppBuilder network(String network) {
            this.network = network;
            return this;
        }

        public DockerAppBuilder forcePullImage(boolean forcePullImage) {
            this.forcePullImage = forcePullImage;
            return this;
        }

        public DockerAppBuilder privileged(boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public App build() {
            Docker docker = new Docker();
            docker.setImage(this.dockerImage);
            docker.setForcePullImage(this.forcePullImage);
            docker.setPrivileged(this.privileged);
            docker.setNetwork(this.network);
            if (!this.portMappings.isEmpty()) {
                docker.setPortMappings(this.portMappings);
            }
            if (!this.parameters.isEmpty()) {
                docker.setParameters(this.parameters);
            }
            Container container = new Container();
            container.setType("DOCKER");
            container.setDocker(docker);
            if (!this.volumes.isEmpty()) {
                container.setVolumes(this.volumes);
            }
            App app = new App();
            app.setId(this.appId);
            app.setInstances(this.instances);
            app.setCpus(this.cpus);
            app.setMem(this.mem);
            app.setContainer(container);
            return app;
        }
    }
}

