/*
 * Decompiled with CFR 0.152.
 */
package mesosphere.marathon.client;

import feign.Param;
import feign.RequestLine;
import java.util.List;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.model.v2.DeleteAppTaskResponse;
import mesosphere.marathon.client.model.v2.DeleteAppTasksResponse;
import mesosphere.marathon.client.model.v2.Deployment;
import mesosphere.marathon.client.model.v2.GetAppResponse;
import mesosphere.marathon.client.model.v2.GetAppTasksResponse;
import mesosphere.marathon.client.model.v2.GetAppsResponse;
import mesosphere.marathon.client.model.v2.GetEventSubscriptionRegisterResponse;
import mesosphere.marathon.client.model.v2.GetEventSubscriptionsResponse;
import mesosphere.marathon.client.model.v2.GetGroupsResponse;
import mesosphere.marathon.client.model.v2.GetServerInfoResponse;
import mesosphere.marathon.client.model.v2.GetTasksResponse;
import mesosphere.marathon.client.model.v2.Group;
import mesosphere.marathon.client.model.v2.Result;
import mesosphere.marathon.client.utils.MarathonException;

public interface Marathon {
    @RequestLine(value="GET /v2/apps")
    public GetAppsResponse getApps();

    @RequestLine(value="GET /v2/apps?label={labelSelectorQuery}")
    public GetAppsResponse getApps(@Param(value="labelSelectorQuery") String var1);

    @RequestLine(value="GET /v2/apps/{id}")
    public GetAppResponse getApp(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/apps/{id}/tasks")
    public GetAppTasksResponse getAppTasks(@Param(value="id") String var1);

    @RequestLine(value="GET /v2/tasks")
    public GetTasksResponse getTasks();

    @RequestLine(value="POST /v2/apps")
    public App createApp(App var1) throws MarathonException;

    @RequestLine(value="PUT /v2/apps/{app_id}")
    public void updateApp(@Param(value="app_id") String var1, App var2);

    @RequestLine(value="POST /v2/apps/{id}/restart?force={force}")
    public void restartApp(@Param(value="id") String var1, @Param(value="force") boolean var2);

    @RequestLine(value="DELETE /v2/apps/{id}")
    public Result deleteApp(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks?host={host}&scale={scale}")
    public DeleteAppTasksResponse deleteAppTasks(@Param(value="app_id") String var1, @Param(value="host") String var2, @Param(value="scale") String var3);

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks/{task_id}?scale={scale}")
    public DeleteAppTaskResponse deleteAppTask(@Param(value="app_id") String var1, @Param(value="task_id") String var2, @Param(value="scale") String var3);

    @RequestLine(value="POST /v2/groups")
    public Result createGroup(Group var1) throws MarathonException;

    @RequestLine(value="PUT /v2/groups/{id}")
    public Result updateGroup(@Param(value="id") String var1, Group var2) throws MarathonException;

    @RequestLine(value="DELETE /v2/groups/{id}")
    public Result deleteGroup(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/groups/{id}")
    public Group getGroup(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/groups")
    public GetGroupsResponse getGroups() throws MarathonException;

    @RequestLine(value="GET /v2/deployments")
    public List<Deployment> getDeployments();

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}")
    public void cancelDeploymentAndRollback(@Param(value="deploymentId") String var1);

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}?force=true")
    public void cancelDeployment(@Param(value="deploymentId") String var1);

    @RequestLine(value="POST /v2/eventSubscriptions?callbackUrl={url}")
    public GetEventSubscriptionRegisterResponse register(@Param(value="url") String var1);

    @RequestLine(value="DELETE /v2/eventSubscriptions?callbackUrl={url}")
    public GetEventSubscriptionRegisterResponse unregister(@Param(value="url") String var1);

    @RequestLine(value="GET /v2/eventSubscriptions")
    public GetEventSubscriptionsResponse subscriptions();

    @RequestLine(value="GET /v2/info")
    public GetServerInfoResponse getServerInfo();
}

