/*
 * Decompiled with CFR 0.152.
 */
package mesosphere.marathon.client.model.v2;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LabelSelectorQuery {
    private String query;

    public LabelSelectorQuery(String query) {
        this.query = query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public static LabelSelectorQueryBuilder builder() {
        return new LabelSelectorQueryBuilder();
    }

    public static enum QueryOperator {
        EQUALS,
        NOT_EQUALS,
        IN,
        NOT_IN,
        EXISTS;

    }

    public static class QueryElement {
        private String lhs;
        private QueryOperator operator;
        private Set<String> rhs = new HashSet<String>();

        public QueryElement(String lhs, QueryOperator operator, Set<String> rhs) {
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
            this.validate();
        }

        private void validate() {
            if (this.lhs == null || this.lhs.isEmpty()) {
                throw new RuntimeException("QueryElement must have a lhs which is neither null nor empty");
            }
            if (this.rhs == null) {
                throw new RuntimeException("QueryElement must have a non-null rhs");
            }
            if (this.rhs.isEmpty() && this.operator != QueryOperator.EXISTS) {
                throw new RuntimeException("QueryElement must have a non-empty rhs for a non exists operation");
            }
            this.rhs.stream().forEach(s -> {
                if (s == null || s.isEmpty()) {
                    throw new RuntimeException("QueryElement has a invalid rhs: rhs contains null or empty strings");
                }
            });
            if (this.rhs.size() > 1 && this.operator != QueryOperator.IN && this.operator != QueryOperator.NOT_IN) {
                throw new RuntimeException("QueryElement has a invalid operator: operator must be of type in or notin");
            }
        }

        public String stringify() {
            return this.lhs.replaceAll("([^A-Za-z0-9-_])", "\\\\$1") + this.getOperatorString() + this.getRhsString();
        }

        private String getRhsString() {
            if (this.rhs.isEmpty()) {
                return "";
            }
            if (this.rhs.size() == 1) {
                return this.rhs.stream().map(s -> s.replaceAll("([^A-Za-z0-9-_])", "\\\\$1")).reduce("", (a, b) -> a + b);
            }
            String ret = this.rhs.stream().map(s -> s.replaceAll("([^A-Za-z0-9-_])", "\\\\$1")).reduce("", (a, b) -> {
                if (a.isEmpty()) {
                    return b;
                }
                if (b.isEmpty()) {
                    return a;
                }
                return a + ", " + b;
            });
            return "(" + ret + ")";
        }

        private String getOperatorString() {
            switch (this.operator) {
                case EQUALS: {
                    return "==";
                }
                case NOT_EQUALS: {
                    return "!=";
                }
                case IN: {
                    return " in ";
                }
                case NOT_IN: {
                    return " notin ";
                }
                case EXISTS: {
                    return "";
                }
            }
            return "";
        }

        public static QueryElementBuilder builder() {
            return new QueryElementBuilder();
        }

        public QueryElement() {
        }

        public static class QueryElementBuilder {
            private String lhs;
            private QueryOperator operator;
            private ArrayList<String> rhs;

            QueryElementBuilder() {
            }

            public QueryElementBuilder lhs(String lhs) {
                this.lhs = lhs;
                return this;
            }

            public QueryElementBuilder operator(QueryOperator operator) {
                this.operator = operator;
                return this;
            }

            public QueryElementBuilder rh(String rh) {
                if (this.rhs == null) {
                    this.rhs = new ArrayList();
                }
                this.rhs.add(rh);
                return this;
            }

            public QueryElementBuilder rhs(Collection<? extends String> rhs) {
                if (this.rhs == null) {
                    this.rhs = new ArrayList();
                }
                this.rhs.addAll(rhs);
                return this;
            }

            public QueryElement build() {
                Set<String> rhs;
                switch (this.rhs == null ? 0 : this.rhs.size()) {
                    case 0: {
                        rhs = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        rhs = Collections.singleton(this.rhs.get(0));
                        break;
                    }
                    default: {
                        rhs = new LinkedHashSet(this.rhs.size() < 0x40000000 ? 1 + this.rhs.size() + (this.rhs.size() - 3) / 3 : Integer.MAX_VALUE);
                        rhs.addAll(this.rhs);
                        rhs = Collections.unmodifiableSet(rhs);
                    }
                }
                return new QueryElement(this.lhs, this.operator, rhs);
            }

            public String toString() {
                return "LabelSelectorQuery.QueryElement.QueryElementBuilder(lhs=" + this.lhs + ", operator=" + (Object)((Object)this.operator) + ", rhs=" + this.rhs + ")";
            }
        }
    }

    public static class LabelSelectorQueryBuilder {
        private List<QueryElement> queryElements = new ArrayList<QueryElement>();

        private String constructQuery() {
            String query = "";
            query = this.queryElements.stream().map(queryElement -> queryElement.stringify()).reduce("", (a, b) -> {
                if (a.isEmpty()) {
                    return b;
                }
                if (b.isEmpty()) {
                    return a;
                }
                return a + ", " + b;
            });
            try {
                query = URLEncoder.encode(query, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException("Wrong charset string", e);
            }
            return query;
        }

        public LabelSelectorQueryBuilder addQueryElement(QueryElement queryElement) {
            this.queryElements.add(queryElement);
            return this;
        }

        public LabelSelectorQuery build() {
            return new LabelSelectorQuery(this.constructQuery());
        }
    }
}

