/*
 * Decompiled with CFR 0.152.
 */
package com.github.nishgpt.chainexecutor.exceptions;

import com.github.nishgpt.chainexecutor.exceptions.ErrorCode;

public class ChainExecutorException
extends RuntimeException {
    private static final long serialVersionUID = 1084352069557055978L;
    private static final String ERROR_OCCURRED_MESSAGE = "Error occurred";
    private final ErrorCode errorCode;

    public ChainExecutorException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public static ChainExecutorException error(ErrorCode errorCode) {
        return new ChainExecutorException(errorCode, ERROR_OCCURRED_MESSAGE, null);
    }

    public static ChainExecutorException propagate(ErrorCode errorCode, Throwable cause) {
        if (cause instanceof ChainExecutorException) {
            return (ChainExecutorException)cause;
        }
        return new ChainExecutorException(errorCode, ERROR_OCCURRED_MESSAGE, cause);
    }

    public static ChainExecutorExceptionBuilder builder() {
        return new ChainExecutorExceptionBuilder();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return "ChainExecutorException(errorCode=" + this.getErrorCode() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChainExecutorException)) {
            return false;
        }
        ChainExecutorException other = (ChainExecutorException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErrorCode this$errorCode = this.getErrorCode();
        ErrorCode other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChainExecutorException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ErrorCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
        return result;
    }

    public static class ChainExecutorExceptionBuilder {
        private ErrorCode errorCode;
        private String message;
        private Throwable cause;

        ChainExecutorExceptionBuilder() {
        }

        public ChainExecutorExceptionBuilder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public ChainExecutorExceptionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ChainExecutorExceptionBuilder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public ChainExecutorException build() {
            return new ChainExecutorException(this.errorCode, this.message, this.cause);
        }

        public String toString() {
            return "ChainExecutorException.ChainExecutorExceptionBuilder(errorCode=" + this.errorCode + ", message=" + this.message + ", cause=" + this.cause + ")";
        }
    }
}

