/*
 * Decompiled with CFR 0.152.
 */
package com.github.nishgpt.chainexecutor.models.stage;

import java.util.Set;

public enum StageStatus {
    NOT_INITIATED,
    INITIATED,
    COMPLETED,
    SKIPPED,
    FAILED,
    ERRORRED;


    public boolean isTerminal() {
        return this.isFailed() || this.isCompleted();
    }

    public boolean isFailed() {
        return FAILED.equals((Object)this);
    }

    public boolean isCompleted() {
        return COMPLETED.equals((Object)this);
    }

    public boolean isPending() {
        return INITIATED.equals((Object)this);
    }

    public boolean isNotInitiated() {
        return NOT_INITIATED.equals((Object)this);
    }

    public boolean isSkipped() {
        return SKIPPED.equals((Object)this);
    }

    public boolean isExecutable() {
        return Set.of(NOT_INITIATED, INITIATED, ERRORRED).contains((Object)this);
    }

    public boolean isCompletedOrSkipped() {
        return Set.of(COMPLETED, SKIPPED).contains((Object)this);
    }
}

