/*
 * Decompiled with CFR 0.152.
 */
package com.github.nishgpt.chainexecutor.models.stage;

import com.github.nishgpt.chainexecutor.exceptions.ChainExecutorException;
import com.github.nishgpt.chainexecutor.exceptions.ErrorCode;
import com.github.nishgpt.chainexecutor.models.stage.Stage;
import com.github.nishgpt.chainexecutor.models.stage.StageChain;
import com.github.nishgpt.chainexecutor.models.stage.StageChainIdentifier;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageChainRegistry<T extends Stage, K extends StageChainIdentifier>
extends HashMap<K, StageChain<T>> {
    private static final Logger log = LoggerFactory.getLogger(StageChainRegistry.class);

    public StageChain<T> getStageChain(K chainIdentifier) {
        return (StageChain)this.get(chainIdentifier);
    }

    public T getNextStage(K chainIdentifier, T currentStage) {
        StageChain<T> chain = this.getStageChain(chainIdentifier);
        if (Objects.isNull(chain)) {
            return null;
        }
        if (Objects.isNull(currentStage)) {
            return chain.getHead();
        }
        return (T)((Stage)chain.getForwardChainMappings().get(currentStage));
    }

    public T getChainHead(K chainIdentifier) {
        StageChain<T> chain = this.getStageChain(chainIdentifier);
        if (Objects.isNull(chain)) {
            return null;
        }
        return chain.getHead();
    }

    public void validateAllChains() {
        this.forEach(this::validateChain);
    }

    private void validateChain(K identifier, StageChain<T> chain) {
        HashMap allStages = new HashMap();
        chain.getForwardChainMappings().forEach((key, value) -> {
            allStages.putIfAbsent(key, Boolean.FALSE);
            allStages.putIfAbsent(value, Boolean.FALSE);
        });
        Object currentStage = chain.getHead();
        do {
            if (((Boolean)allStages.get(currentStage)).booleanValue()) {
                log.error("Stage already encountered, possible loop; Invalid chain for {}", identifier);
                throw ChainExecutorException.error(ErrorCode.INVALID_CHAIN);
            }
            allStages.put(currentStage, Boolean.TRUE);
        } while (Objects.nonNull(currentStage = (Stage)chain.getForwardChainMappings().get(currentStage)));
        if (allStages.entrySet().stream().anyMatch(entry -> ((Boolean)entry.getValue()).equals(Boolean.FALSE))) {
            log.error("Possible chain breakage; Invalid chain for {}", identifier);
            throw ChainExecutorException.error(ErrorCode.INVALID_CHAIN);
        }
    }
}

