/*
 * Decompiled with CFR 0.152.
 */
package com.github.nishgpt.chainexecutor;

import com.github.nishgpt.chainexecutor.exceptions.ChainExecutorException;
import com.github.nishgpt.chainexecutor.exceptions.ErrorCode;
import com.github.nishgpt.chainexecutor.models.execution.ExecutionContext;
import com.github.nishgpt.chainexecutor.models.execution.ExecutorAuxiliaryKey;
import com.github.nishgpt.chainexecutor.models.execution.StageExecutionRequest;
import com.github.nishgpt.chainexecutor.models.execution.StageExecutor;
import com.github.nishgpt.chainexecutor.models.execution.StageExecutorFactory;
import com.github.nishgpt.chainexecutor.models.execution.StageExecutorKey;
import com.github.nishgpt.chainexecutor.models.stage.Stage;
import com.github.nishgpt.chainexecutor.models.stage.StageChainIdentifier;
import com.github.nishgpt.chainexecutor.models.stage.StageChainRegistry;
import com.github.nishgpt.chainexecutor.models.stage.StageStatus;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StageExecutionManager<T extends Stage, U extends ExecutionContext, V extends StageExecutionRequest, K extends ExecutorAuxiliaryKey, C extends StageChainIdentifier> {
    private static final Logger log = LoggerFactory.getLogger(StageExecutionManager.class);
    private final StageChainRegistry<T, C> chainRegistry;
    private final StageExecutorFactory executorFactory;

    public U execute(StageExecutorKey<T, K> stageExecutorKey, C chainIdentifier, U context, V request) throws ChainExecutorException {
        try {
            this.validatePreviousStagesCompletion(chainIdentifier, context, stageExecutorKey.getAuxiliaryKey(), stageExecutorKey.getStage());
            if (!stageExecutorKey.getStage().equals(this.getFirstNonCompletedStage(chainIdentifier, context, stageExecutorKey.getAuxiliaryKey()))) {
                throw ChainExecutorException.error(ErrorCode.INVALID_EXECUTION_STAGE);
            }
            StageExecutor executor = this.executorFactory.getExecutor(stageExecutorKey);
            StageStatus currentStatus = executor.getStageStatus(context);
            if (currentStatus.isNotInitiated()) {
                U updatedContext = executor.skipIfApplicable(context);
                if (executor.getStageStatus(updatedContext).isSkipped()) {
                    context = updatedContext;
                    log.info("Skipped {} Stage for id - {}", stageExecutorKey.getStage(), (Object)((ExecutionContext)context).getId());
                } else {
                    log.info("Initiating {} Stage for id - {}", stageExecutorKey.getStage(), (Object)((ExecutionContext)context).getId());
                    context = executor.init(context);
                }
            }
            if (currentStatus.isFailed()) {
                return context;
            }
            if (currentStatus.isExecutable()) {
                log.info("Executing {} Stage for id - {}", stageExecutorKey.getStage(), (Object)((ExecutionContext)context).getId());
                context = executor.execute(context, request);
            }
            if (executor.getStageStatus(context).isCompletedOrSkipped()) {
                return this.performPostCompletionSteps(context, executor, stageExecutorKey, chainIdentifier);
            }
            return context;
        }
        catch (ChainExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing stage {}", stageExecutorKey.getStage());
            throw ChainExecutorException.propagate(ErrorCode.EXECUTION_ERROR, e);
        }
    }

    public U resume(StageExecutorKey<T, K> stageExecutorKey, C chainIdentifier, U context) throws ChainExecutorException {
        try {
            StageExecutor executor = this.executorFactory.getExecutor(stageExecutorKey);
            StageStatus currentStatus = executor.getStageStatus(context);
            if (!currentStatus.isPending()) {
                log.info("Cannot resume stage {}, current status {}", stageExecutorKey.getStage(), (Object)currentStatus);
                return context;
            }
            U updatedContext = executor.resume(context);
            if (executor.getStageStatus(updatedContext).isCompleted()) {
                return this.performPostCompletionSteps(updatedContext, executor, stageExecutorKey, chainIdentifier);
            }
            return updatedContext;
        }
        catch (ChainExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing stage {}", stageExecutorKey.getStage());
            throw ChainExecutorException.propagate(ErrorCode.EXECUTION_ERROR, e);
        }
    }

    protected abstract U finishExecution(U var1);

    public U initNext(StageExecutorKey<T, K> stageExecutorKey, C chainIdentifier, U context) {
        try {
            StageStatus stageStatus;
            T nextStage = this.chainRegistry.getNextStage(chainIdentifier, stageExecutorKey.getStage());
            while (Objects.nonNull(nextStage)) {
                StageExecutor nextExecutor = this.getExecutor(nextStage, stageExecutorKey.getAuxiliaryKey());
                nextExecutor.validateStatus(context);
                if (nextExecutor.getStageStatus(context).isNotInitiated()) {
                    nextExecutor.skipIfApplicable(context);
                }
                if (!nextExecutor.getStageStatus(context).isCompletedOrSkipped()) break;
                nextStage = this.chainRegistry.getNextStage(chainIdentifier, nextStage);
            }
            if (Objects.isNull(nextStage)) {
                return this.finishExecution(context);
            }
            StageExecutor executor = this.getExecutor(nextStage, stageExecutorKey.getAuxiliaryKey());
            if (executor.getStageStatus(context).isNotInitiated()) {
                log.info("Initiating {} Stage for id - {}", nextStage, (Object)((ExecutionContext)context).getId());
                context = executor.init(context);
            }
            if (executor.isBackground(context) && executor.getStageStatus(context).isExecutable() && (stageStatus = executor.getStageStatus(context = executor.execute(context, null))).isCompletedOrSkipped()) {
                return this.performPostCompletionSteps(context, executor, stageExecutorKey, chainIdentifier);
            }
            return context;
        }
        catch (ChainExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error initiating next stage after {}", stageExecutorKey.getStage());
            throw ChainExecutorException.propagate(ErrorCode.EXECUTION_ERROR, e);
        }
    }

    public U fetchInfo(StageExecutorKey<T, K> stageExecutorKey, C chainIdentifier, U context) {
        try {
            T stage = this.getFirstNonCompletedStage(chainIdentifier, context, stageExecutorKey.getAuxiliaryKey());
            StageExecutor executor = this.getExecutor(stage, stageExecutorKey.getAuxiliaryKey());
            return executor.fetchInfo(context);
        }
        catch (ChainExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error fetching info for key {}", stageExecutorKey);
            throw ChainExecutorException.propagate(ErrorCode.EXECUTION_ERROR, e);
        }
    }

    protected T getFirstNonCompletedStage(C chainIdentifier, U context, K auxiliaryKey) {
        StageExecutor executor;
        T currentStage = this.chainRegistry.getChainHead(chainIdentifier);
        while ((executor = this.getExecutor(currentStage, auxiliaryKey)).getStageStatus(context).isCompletedOrSkipped() && Objects.nonNull(currentStage = this.chainRegistry.getNextStage(chainIdentifier, currentStage))) {
        }
        return currentStage;
    }

    protected StageExecutor getExecutor(T stage, K auxiliaryKey) {
        StageExecutorKey executorKey = StageExecutorKey.builder().stage(stage).auxiliaryKey(auxiliaryKey).build();
        return this.executorFactory.getExecutor(executorKey);
    }

    protected void validatePreviousStagesCompletion(C chainIdentifier, U context, K auxiliaryKey, T endStage) {
        T currentStage = this.chainRegistry.getChainHead(chainIdentifier);
        while (Objects.nonNull(currentStage) && !currentStage.equals(endStage)) {
            StageExecutor executor = this.getExecutor(currentStage, auxiliaryKey);
            executor.validateStatus(context);
            if (!executor.getStageStatus(context).isCompletedOrSkipped()) break;
            currentStage = this.chainRegistry.getNextStage(chainIdentifier, currentStage);
        }
    }

    private U performPostCompletionSteps(U context, StageExecutor executor, StageExecutorKey<T, K> stageExecutorKey, C chainIdentifier) {
        U updatedContext = executor.postExecution(context);
        return this.initNext(stageExecutorKey, chainIdentifier, updatedContext);
    }

    protected StageExecutionManager(StageExecutionManagerBuilder<T, U, V, K, C, ?, ?> b) {
        this.chainRegistry = b.chainRegistry;
        this.executorFactory = b.executorFactory;
    }

    public StageExecutionManager(StageChainRegistry<T, C> chainRegistry, StageExecutorFactory executorFactory) {
        this.chainRegistry = chainRegistry;
        this.executorFactory = executorFactory;
    }

    public StageChainRegistry<T, C> getChainRegistry() {
        return this.chainRegistry;
    }

    public static abstract class StageExecutionManagerBuilder<T extends Stage, U extends ExecutionContext, V extends StageExecutionRequest, K extends ExecutorAuxiliaryKey, C extends StageChainIdentifier, C2 extends StageExecutionManager<T, U, V, K, C>, B extends StageExecutionManagerBuilder<T, U, V, K, C, C2, B>> {
        private StageChainRegistry<T, C> chainRegistry;
        private StageExecutorFactory executorFactory;

        protected abstract B self();

        public abstract C2 build();

        public B chainRegistry(StageChainRegistry<T, C> chainRegistry) {
            this.chainRegistry = chainRegistry;
            return this.self();
        }

        public B executorFactory(StageExecutorFactory executorFactory) {
            this.executorFactory = executorFactory;
            return this.self();
        }

        public String toString() {
            return "StageExecutionManager.StageExecutionManagerBuilder(chainRegistry=" + this.chainRegistry + ", executorFactory=" + this.executorFactory + ")";
        }
    }
}

