/*
 * Decompiled with CFR 0.152.
 */
package com.github.nishgpt.chainexecutor.models.execution;

import com.github.nishgpt.chainexecutor.models.execution.StageExecutor;
import com.github.nishgpt.chainexecutor.models.execution.StageExecutorKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StageExecutorFactory<A extends Annotation> {
    private static final Logger log = LoggerFactory.getLogger(StageExecutorFactory.class);
    private final Map<StageExecutorKey, StageExecutor> executors = Maps.newConcurrentMap();

    public StageExecutorFactory(String executorPackage, Injector injector, Class<A> annotationClass) {
        Preconditions.checkNotNull((Object)injector, (Object)"Injector cannot be null");
        Reflections reflections = new Reflections(executorPackage, new Scanner[0]);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(annotationClass);
        annotatedClasses.forEach(annotatedClass -> {
            if (StageExecutor.class.isAssignableFrom((Class<?>)annotatedClass)) {
                StageExecutor instance = (StageExecutor)injector.getInstance(annotatedClass);
                instance.getExecutorKeys().forEach(key -> this.executors.put((StageExecutorKey)key, instance));
            }
        });
    }

    public StageExecutor getExecutor(StageExecutorKey key) {
        return this.executors.get(key);
    }
}

