(ns omkamra.fluidsynth-example
  (:require [omkamra.fluidsynth.settings :as settings]
            [omkamra.fluidsynth.synth :as synth]
            [omkamra.fluidsynth.audio-driver :as audio-driver]))

(let [settings (settings/create)
      synth (synth/create settings)
      audio-driver (audio-driver/create synth)]

  (try
    (synth/sfload synth "/usr/share/soundfonts/FluidR3_GM.sf2")

    (let [channel 0
          program 0
          velocity 100]
      (settings/decode (synth/get-settings synth))
      (synth/program-change synth channel program)
      (doseq [interval [0 2 4 5 7 9 11 12]]
        (let [note (+ 60 interval)]
          (synth/noteon synth channel note velocity)
          (Thread/sleep 1000)
          (synth/noteoff synth channel note))))

    (finally
      (audio-driver/delete audio-driver)
      (synth/delete synth)
      (settings/delete settings))))
