(ns omkamra.jnr.test
  (:require [omkamra.jnr.library :as library]
            [omkamra.jnr.struct :as struct]
            [omkamra.jnr.union :as union]
            [omkamra.jnr.enum :as enum]
            [omkamra.jnr.util :as util]))

(library/define $sdl2 "SDL2"
  (^int SDL_VideoInit [^String driver_name])
  (^int SDL_GetDisplayDPI [^int displayIndex
                           ^Float* ^:out ddpi
                           ^Float* ^:out hdpi
                           ^Float* ^:out vdpi])
  (^void SDL_VideoQuit []))

(let [ddpi (jnr.ffi.byref.FloatByReference.)
      hdpi (jnr.ffi.byref.FloatByReference.)
      vdpi (jnr.ffi.byref.FloatByReference.)]
  (assert (zero? (.SDL_VideoInit $sdl2 nil)))
  (.SDL_GetDisplayDPI $sdl2 0 ddpi hdpi vdpi)
  (.SDL_VideoQuit $sdl2)
  (printf "ddpi: %f hdpi: %f vdpi: %f\n"
          (.getValue ddpi)
          (.getValue hdpi)
          (.getValue vdpi)))
