/*
 * Decompiled with CFR 0.152.
 */
package com.github.phaneesh.actors.ratelimit;

import io.github.bucket4j.TokensInheritanceStrategy;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class RateLimitConfiguration {
    private String bucketName;
    private int rateLimit;
    private int rateLimitPeriod;
    private TemporalUnit rateLimitPeriodUnit;
    private int refillRate;
    private RateLimitType rateLimitType;
    private TokensInheritanceStrategy tokensInheritanceStrategy;

    private static int $default$rateLimitPeriod() {
        return 1;
    }

    private static TemporalUnit $default$rateLimitPeriodUnit() {
        return ChronoUnit.SECONDS;
    }

    private static RateLimitType $default$rateLimitType() {
        return RateLimitType.THROTTLE;
    }

    private static TokensInheritanceStrategy $default$tokensInheritanceStrategy() {
        return TokensInheritanceStrategy.AS_IS;
    }

    public static RateLimitConfigurationBuilder builder() {
        return new RateLimitConfigurationBuilder();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public int getRateLimitPeriod() {
        return this.rateLimitPeriod;
    }

    public TemporalUnit getRateLimitPeriodUnit() {
        return this.rateLimitPeriodUnit;
    }

    public int getRefillRate() {
        return this.refillRate;
    }

    public RateLimitType getRateLimitType() {
        return this.rateLimitType;
    }

    public TokensInheritanceStrategy getTokensInheritanceStrategy() {
        return this.tokensInheritanceStrategy;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
    }

    public void setRateLimitPeriod(int rateLimitPeriod) {
        this.rateLimitPeriod = rateLimitPeriod;
    }

    public void setRateLimitPeriodUnit(TemporalUnit rateLimitPeriodUnit) {
        this.rateLimitPeriodUnit = rateLimitPeriodUnit;
    }

    public void setRefillRate(int refillRate) {
        this.refillRate = refillRate;
    }

    public void setRateLimitType(RateLimitType rateLimitType) {
        this.rateLimitType = rateLimitType;
    }

    public void setTokensInheritanceStrategy(TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.tokensInheritanceStrategy = tokensInheritanceStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitConfiguration)) {
            return false;
        }
        RateLimitConfiguration other = (RateLimitConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRateLimit() != other.getRateLimit()) {
            return false;
        }
        if (this.getRateLimitPeriod() != other.getRateLimitPeriod()) {
            return false;
        }
        if (this.getRefillRate() != other.getRefillRate()) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        TemporalUnit this$rateLimitPeriodUnit = this.getRateLimitPeriodUnit();
        TemporalUnit other$rateLimitPeriodUnit = other.getRateLimitPeriodUnit();
        if (this$rateLimitPeriodUnit == null ? other$rateLimitPeriodUnit != null : !this$rateLimitPeriodUnit.equals(other$rateLimitPeriodUnit)) {
            return false;
        }
        RateLimitType this$rateLimitType = this.getRateLimitType();
        RateLimitType other$rateLimitType = other.getRateLimitType();
        if (this$rateLimitType == null ? other$rateLimitType != null : !((Object)((Object)this$rateLimitType)).equals((Object)other$rateLimitType)) {
            return false;
        }
        TokensInheritanceStrategy this$tokensInheritanceStrategy = this.getTokensInheritanceStrategy();
        TokensInheritanceStrategy other$tokensInheritanceStrategy = other.getTokensInheritanceStrategy();
        return !(this$tokensInheritanceStrategy == null ? other$tokensInheritanceStrategy != null : !this$tokensInheritanceStrategy.equals(other$tokensInheritanceStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimitConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRateLimit();
        result = result * 59 + this.getRateLimitPeriod();
        result = result * 59 + this.getRefillRate();
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        TemporalUnit $rateLimitPeriodUnit = this.getRateLimitPeriodUnit();
        result = result * 59 + ($rateLimitPeriodUnit == null ? 43 : $rateLimitPeriodUnit.hashCode());
        RateLimitType $rateLimitType = this.getRateLimitType();
        result = result * 59 + ($rateLimitType == null ? 43 : ((Object)((Object)$rateLimitType)).hashCode());
        TokensInheritanceStrategy $tokensInheritanceStrategy = this.getTokensInheritanceStrategy();
        result = result * 59 + ($tokensInheritanceStrategy == null ? 43 : $tokensInheritanceStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "RateLimitConfiguration(bucketName=" + this.getBucketName() + ", rateLimit=" + this.getRateLimit() + ", rateLimitPeriod=" + this.getRateLimitPeriod() + ", rateLimitPeriodUnit=" + this.getRateLimitPeriodUnit() + ", refillRate=" + this.getRefillRate() + ", rateLimitType=" + this.getRateLimitType() + ", tokensInheritanceStrategy=" + this.getTokensInheritanceStrategy() + ")";
    }

    public RateLimitConfiguration(String bucketName, int rateLimit, int rateLimitPeriod, TemporalUnit rateLimitPeriodUnit, int refillRate, RateLimitType rateLimitType, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.bucketName = bucketName;
        this.rateLimit = rateLimit;
        this.rateLimitPeriod = rateLimitPeriod;
        this.rateLimitPeriodUnit = rateLimitPeriodUnit;
        this.refillRate = refillRate;
        this.rateLimitType = rateLimitType;
        this.tokensInheritanceStrategy = tokensInheritanceStrategy;
    }

    public RateLimitConfiguration() {
        this.rateLimitPeriod = RateLimitConfiguration.$default$rateLimitPeriod();
        this.rateLimitPeriodUnit = RateLimitConfiguration.$default$rateLimitPeriodUnit();
        this.rateLimitType = RateLimitConfiguration.$default$rateLimitType();
        this.tokensInheritanceStrategy = RateLimitConfiguration.$default$tokensInheritanceStrategy();
    }

    public static enum RateLimitType {
        THROTTLE,
        REJECT;

    }

    public static class RateLimitConfigurationBuilder {
        private String bucketName;
        private int rateLimit;
        private boolean rateLimitPeriod$set;
        private int rateLimitPeriod$value;
        private boolean rateLimitPeriodUnit$set;
        private TemporalUnit rateLimitPeriodUnit$value;
        private int refillRate;
        private boolean rateLimitType$set;
        private RateLimitType rateLimitType$value;
        private boolean tokensInheritanceStrategy$set;
        private TokensInheritanceStrategy tokensInheritanceStrategy$value;

        RateLimitConfigurationBuilder() {
        }

        public RateLimitConfigurationBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public RateLimitConfigurationBuilder rateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public RateLimitConfigurationBuilder rateLimitPeriod(int rateLimitPeriod) {
            this.rateLimitPeriod$value = rateLimitPeriod;
            this.rateLimitPeriod$set = true;
            return this;
        }

        public RateLimitConfigurationBuilder rateLimitPeriodUnit(TemporalUnit rateLimitPeriodUnit) {
            this.rateLimitPeriodUnit$value = rateLimitPeriodUnit;
            this.rateLimitPeriodUnit$set = true;
            return this;
        }

        public RateLimitConfigurationBuilder refillRate(int refillRate) {
            this.refillRate = refillRate;
            return this;
        }

        public RateLimitConfigurationBuilder rateLimitType(RateLimitType rateLimitType) {
            this.rateLimitType$value = rateLimitType;
            this.rateLimitType$set = true;
            return this;
        }

        public RateLimitConfigurationBuilder tokensInheritanceStrategy(TokensInheritanceStrategy tokensInheritanceStrategy) {
            this.tokensInheritanceStrategy$value = tokensInheritanceStrategy;
            this.tokensInheritanceStrategy$set = true;
            return this;
        }

        public RateLimitConfiguration build() {
            int rateLimitPeriod$value = this.rateLimitPeriod$value;
            if (!this.rateLimitPeriod$set) {
                rateLimitPeriod$value = RateLimitConfiguration.$default$rateLimitPeriod();
            }
            TemporalUnit rateLimitPeriodUnit$value = this.rateLimitPeriodUnit$value;
            if (!this.rateLimitPeriodUnit$set) {
                rateLimitPeriodUnit$value = RateLimitConfiguration.$default$rateLimitPeriodUnit();
            }
            RateLimitType rateLimitType$value = this.rateLimitType$value;
            if (!this.rateLimitType$set) {
                rateLimitType$value = RateLimitConfiguration.$default$rateLimitType();
            }
            TokensInheritanceStrategy tokensInheritanceStrategy$value = this.tokensInheritanceStrategy$value;
            if (!this.tokensInheritanceStrategy$set) {
                tokensInheritanceStrategy$value = RateLimitConfiguration.$default$tokensInheritanceStrategy();
            }
            return new RateLimitConfiguration(this.bucketName, this.rateLimit, rateLimitPeriod$value, rateLimitPeriodUnit$value, this.refillRate, rateLimitType$value, tokensInheritanceStrategy$value);
        }

        public String toString() {
            return "RateLimitConfiguration.RateLimitConfigurationBuilder(bucketName=" + this.bucketName + ", rateLimit=" + this.rateLimit + ", rateLimitPeriod$value=" + this.rateLimitPeriod$value + ", rateLimitPeriodUnit$value=" + this.rateLimitPeriodUnit$value + ", refillRate=" + this.refillRate + ", rateLimitType$value=" + this.rateLimitType$value + ", tokensInheritanceStrategy$value=" + this.tokensInheritanceStrategy$value + ")";
        }
    }
}

