/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.oor;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.oor.BirHook;
import io.dropwizard.oor.OorHook;
import io.dropwizard.oor.healtcheck.OorHealthCheck;
import io.dropwizard.oor.tasks.BirTask;
import io.dropwizard.oor.tasks.OorTask;
import io.dropwizard.servlets.tasks.Task;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(OorBundle.class);
    public static final List<OorHook> oorHooks = new ArrayList<OorHook>();
    public static final List<BirHook> birHooks = new ArrayList<BirHook>();

    public abstract boolean withOor();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void registerOorHook(OorHook oorHook) {
        oorHooks.add(oorHook);
    }

    public void registerBirHook(BirHook birHook) {
        birHooks.add(birHook);
    }

    public void run(T configuration, Environment environment) {
        environment.healthChecks().register("oor", (HealthCheck)new OorHealthCheck(this.withOor()));
        environment.admin().addTask((Task)new OorTask());
        environment.admin().addTask((Task)new BirTask());
    }
}

