/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.oor.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OorHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(OorHealthCheck.class);
    public static AtomicBoolean oor;

    public OorHealthCheck(boolean status) {
        oor = new AtomicBoolean(status);
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result = null;
        result = oor.get() ? HealthCheck.Result.unhealthy((String)"Service is out of rotation") : HealthCheck.Result.healthy();
        if (log.isDebugEnabled()) {
            log.debug("OORBundle HealthCheck status: {}, {}", (Object)result.isHealthy(), (Object)result.getMessage());
        }
        return result;
    }

    public static void setOor(boolean state) {
        oor.getAndSet(state);
    }
}

