(ns gcp.vertexai.v1.api.Candidate
  (:require [gcp.global :as global]
            [gcp.vertexai.v1.api.CitationMetadata :as CitationMetadata]
            [gcp.vertexai.v1.api.Content :as Content]
            [gcp.vertexai.v1.api.GroundingMetadata :as GroundingMetadata]
            [gcp.vertexai.v1.api.SafetyRating :as SafetyRating])
  (:import [com.google.cloud.vertexai.api Candidate Candidate$FinishReason]))

(def finish-reasons
  {"BLOCKED_REASON_UNSPECIFIED"          "Unspecified blocked reason."
   "BLOCKLIST"                           "Candidates blocked due to the terms which are included from the terminology blocklist."
   "FINISH_REASON_UNSPECIFIED"           "The finish reason is unspecified."
   "MALFORMED_FUNCTION_CALL"             "The function call generated by the model is invalid."
   "MAX_TOKENS"                          "Token generation reached the configured maximum output tokens."
   "OTHER"                               "All other reasons that stopped the token generation."
   "PROHIBITED_CONTENT"                  "Token generation stopped for potentially containing prohibited content."
   "RECITATION"                          "Token generation stopped because the content potentially contains copyright violations."
   "SAFETY"                              "Token generation stopped because the content potentially contains safety violations. NOTE: When streaming, content is empty if content filters blocks the output."
   "SPII"                                "Token generation stopped because the content potentially contains Sensitive Personally Identifiable Information (SPII)."
   "STOP"                                "Token generation reached a natural stopping point or a configured stop sequence."
   "UNRECOGNIZED"                        "UNRECOGNIZED"})

(defn ^String FinishReason-to-edn [arg]
  (if (int? arg)
    (.name (Candidate$FinishReason/forNumber ^int arg))
    (.name arg)))

(defn ^String FinishReason-from-edn [arg]
  (if (number? arg)
    (Candidate$FinishReason/forNumber ^int (int arg))
    (Candidate$FinishReason/valueOf ^String arg)))

#!-----------------------------------------------------------------------------

(defn ^Candidate from-edn [arg]
  (let [builder (Candidate/newBuilder)
        {:keys [content safetyRatings
                citationMetadata finishReason
                groundingMetadata avgLogprobs
                score
                index]} arg]
    (some->> content Content/from-edn (.setContent builder))
    (some->> safetyRatings (map SafetyRating/from-edn) (.addAllSafetyRatings builder))
    (some->> citationMetadata CitationMetadata/from-edn (.setCitationMetadata builder))
    (some->> finishReason FinishReason-from-edn (.setFinishReason builder))
    (some->> avgLogprobs (.setAvgLogprobs builder))
    (some->> groundingMetadata GroundingMetadata/from-edn (.setGroundingMetadata builder))
    (some->> index (.setIndex builder))
    (some->> score (.setScore builder))
    (.build builder)))

(defn to-edn [^Candidate arg]
  {:post [(global/strict! :gcp/vertexai.api.Candidate %)]}
  (cond-> {:avgLogprobs (.getAvgLogprobs arg)
           :index (.getIndex arg)
           :score (.getScore arg)
           :finishReason (FinishReason-to-edn (.getFinishReason arg))
           :safetyRatings (mapv SafetyRating/to-edn (.getSafetyRatingsList arg))}
          (.hasCitationMetadata arg)
          (assoc :citationMetadata (CitationMetadata/to-edn (.getCitationMetadata arg)))
          (.hasFinishMessage arg)
          (assoc :finishMessage (.getFinishMessage arg))
          (.hasContent arg)
          (assoc :content (Content/to-edn (.getContent arg)))
          (.hasGroundingMetadata arg)
          (assoc :groundingMetadata (GroundingMetadata/to-edn (.getGroundingMetadata arg)))))