/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.common;

import backtype.storm.tuple.Values;
import com.google.common.base.Preconditions;
import java.util.List;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;
import stormy.pythian.model.instance.InputFixedFeaturesMapper;
import stormy.pythian.model.instance.InputUserSelectionFeaturesMapper;
import stormy.pythian.model.instance.Instance;

public class ExtractFeatures
extends BaseFunction {
    private static final long serialVersionUID = -2823417821288444544L;
    private final InputUserSelectionFeaturesMapper userSelectionFeaturesMapper;
    private final InputFixedFeaturesMapper fixedFeaturesMapper;
    private final String[] featureNames;

    public ExtractFeatures(InputFixedFeaturesMapper mapper, String ... featureNames) {
        Preconditions.checkNotNull((Object)mapper);
        Preconditions.checkNotNull((Object)featureNames);
        this.userSelectionFeaturesMapper = null;
        this.fixedFeaturesMapper = mapper;
        this.featureNames = featureNames;
    }

    public ExtractFeatures(InputUserSelectionFeaturesMapper userSelectionFeaturesMapper) {
        Preconditions.checkNotNull((Object)userSelectionFeaturesMapper);
        this.userSelectionFeaturesMapper = userSelectionFeaturesMapper;
        this.fixedFeaturesMapper = null;
        this.featureNames = null;
    }

    public void execute(TridentTuple tuple, TridentCollector collector) {
        Instance instance = Instance.from((TridentTuple)tuple);
        Object[] features = this.getFeatures(instance);
        collector.emit((List)new Values(features));
    }

    private Object[] getFeatures(Instance instance) {
        if (this.userSelectionFeaturesMapper != null) {
            Object[] selectedFeatures = instance.getSelectedFeatures(this.userSelectionFeaturesMapper);
            return selectedFeatures;
        }
        if (this.fixedFeaturesMapper != null && this.featureNames != null) {
            Object[] features = new Object[this.featureNames.length];
            for (int i = 0; i < this.featureNames.length; ++i) {
                String featureName = this.featureNames[i];
                features[i] = instance.getInputFeature(this.fixedFeaturesMapper, featureName);
            }
            return features;
        }
        throw new IllegalStateException("Either userSelectionFeaturesMapper or fixedFeaturesMapper should be set");
    }
}

