/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.model.annotation;

public enum PropertyType {
    INTEGER(Integer.class, Long.class),
    DECIMAL(Double.class, Float.class),
    NUMBER(Number.class),
    BOOLEAN(Boolean.class),
    STRING(String.class),
    ENUM(Enum.class);

    private final Class<?>[] supportedClasses;

    private PropertyType(Class<?> ... supportedClasses) {
        this.supportedClasses = supportedClasses;
    }

    public boolean support(Class<?> type) {
        for (Class<?> supportedClass : this.supportedClasses) {
            if (!supportedClass.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static PropertyType fromType(Class<?> type) {
        for (PropertyType candidate : PropertyType.values()) {
            if (!candidate.support(type)) continue;
            return candidate;
        }
        throw new IllegalArgumentException(type + " isn't supported for property");
    }
}

